/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonEncoding;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonFactory;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileGenerator$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileParser$Feature;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Tool {
    public final JsonFactory jsonFactory = new JsonFactory();
    public final SmileFactory smileFactory = new SmileFactory();

    public Tool() {
        this.smileFactory.configure(SmileGenerator$Feature.CHECK_SHARED_NAMES, true);
        this.smileFactory.configure(SmileGenerator$Feature.CHECK_SHARED_STRING_VALUES, true);
        this.smileFactory.configure(SmileGenerator$Feature.ENCODE_BINARY_AS_7BIT, true);
        this.smileFactory.configure(SmileGenerator$Feature.WRITE_HEADER, true);
        this.smileFactory.configure(SmileGenerator$Feature.WRITE_END_MARKER, false);
        this.smileFactory.configure(SmileParser$Feature.REQUIRE_HEADER, false);
    }

    private void process(String[] stringArray) {
        String string = null;
        String string2 = null;
        if (stringArray.length == 2) {
            string = stringArray[0];
            string2 = stringArray[1];
        } else if (stringArray.length == 1) {
            string = stringArray[0];
        } else {
            this.showUsage();
        }
        if ("-e".equals(string)) {
            this.encode(this.inputStream(string2));
            return;
        }
        if ("-d".equals(string)) {
            this.decode(this.inputStream(string2));
            return;
        }
        if ("-v".equals(string)) {
            this.verify(this.inputStream(string2), this.inputStream(string2));
            return;
        }
        this.showUsage();
    }

    private InputStream inputStream(String string) {
        if (string == null) {
            return System.in;
        }
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("File '" + string + "' does not exist.");
            System.exit(1);
        }
        return new FileInputStream(file);
    }

    private void decode(InputStream closeable) {
        closeable = this.smileFactory.createParser((InputStream)closeable);
        JsonGenerator jsonGenerator = this.jsonFactory.createGenerator(System.out, JsonEncoding.UTF8);
        while (((JsonParser)closeable).nextToken() != null || ((JsonParser)closeable).nextToken() != null) {
            jsonGenerator.copyCurrentEvent((JsonParser)closeable);
        }
        ((JsonParser)closeable).close();
        jsonGenerator.close();
    }

    private void encode(InputStream closeable) {
        closeable = this.jsonFactory.createParser((InputStream)closeable);
        SmileGenerator smileGenerator = this.smileFactory.createGenerator(System.out, JsonEncoding.UTF8);
        while (((JsonParser)closeable).nextToken() != null) {
            smileGenerator.copyCurrentEvent((JsonParser)closeable);
        }
        ((JsonParser)closeable).close();
        ((JsonGenerator)smileGenerator).close();
    }

    private void verify(InputStream closeable, InputStream object) {
        closeable = this.jsonFactory.createParser((InputStream)closeable);
        Closeable closeable2 = new ByteArrayOutputStream(4000);
        Object object2 = this.smileFactory.createGenerator((OutputStream)closeable2, JsonEncoding.UTF8);
        while (((JsonParser)closeable).nextToken() != null) {
            ((JsonGenerator)object2).copyCurrentEvent((JsonParser)closeable);
        }
        ((JsonParser)closeable).close();
        ((JsonGenerator)object2).close();
        closeable = this.jsonFactory.createParser((InputStream)object);
        object = ((ByteArrayOutputStream)closeable2).toByteArray();
        closeable2 = this.smileFactory.createParser((byte[])object);
        int n2 = 0;
        while ((object2 = ((JsonParser)closeable).nextToken()) != null) {
            Object object3 = ((JsonParser)closeable2).nextToken();
            ++n2;
            if (object2 != object3) {
                throw new IOException("Input and encoded differ, token #" + n2 + "; expected " + object2 + ", got " + (Object)object3);
            }
            object2 = ((JsonParser)closeable).getText();
            if (((String)object2).equals(object3 = ((JsonParser)closeable2).getText())) continue;
            throw new IOException("Input and encoded differ, token #" + n2 + "; expected text '" + (String)object2 + "', got '" + (String)object3 + "'");
        }
        System.out.println("OK: verified " + n2 + " tokens (from " + ((Object)object).length + " bytes of Smile encoded data), input and encoded contents are identical");
    }

    protected void showUsage() {
        System.err.println("Usage: java " + this.getClass().getName() + " -e/-d [file]");
        System.err.println(" (if no file given, reads from stdin -- always writes to stdout)");
        System.err.println(" -d: decode Smile encoded input as JSON");
        System.err.println(" -e: encode JSON (text) input as Smile");
        System.err.println(" -v: encode JSON (text) input as Smile; read back, verify, do not write out");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        new Tool().process(stringArray);
    }
}

