/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.base;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonLocation;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser$NumberType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Version;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.DupDetector;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.JsonReadContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.PackageVersion;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.TextBuffer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class ParserBase
extends ParserMinimalBase {
    protected final IOContext _ioContext;
    protected boolean _closed;
    protected int _inputPtr = 0;
    protected int _inputEnd = 0;
    protected long _currInputProcessed = 0L;
    protected int _currInputRow = 1;
    protected int _currInputRowStart = 0;
    protected long _tokenInputTotal = 0L;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol = 0;
    protected JsonReadContext _parsingContext;
    protected JsonToken _nextToken;
    protected final TextBuffer _textBuffer;
    protected char[] _nameCopyBuffer = null;
    protected boolean _nameCopied = false;
    protected ByteArrayBuilder _byteArrayBuilder = null;
    protected byte[] _binaryValue;
    protected static final int NR_UNKNOWN = 0;
    protected static final int NR_INT = 1;
    protected static final int NR_LONG = 2;
    protected static final int NR_BIGINT = 4;
    protected static final int NR_DOUBLE = 8;
    protected static final int NR_BIGDECIMAL = 16;
    static final BigInteger BI_MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    static final BigInteger BI_MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    static final BigInteger BI_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    static final BigInteger BI_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    static final BigDecimal BD_MIN_LONG = new BigDecimal(BI_MIN_LONG);
    static final BigDecimal BD_MAX_LONG = new BigDecimal(BI_MAX_LONG);
    static final BigDecimal BD_MIN_INT = new BigDecimal(BI_MIN_INT);
    static final BigDecimal BD_MAX_INT = new BigDecimal(BI_MAX_INT);
    static final long MIN_INT_L = Integer.MIN_VALUE;
    static final long MAX_INT_L = Integer.MAX_VALUE;
    static final double MIN_LONG_D = -9.223372036854776E18;
    static final double MAX_LONG_D = 9.223372036854776E18;
    static final double MIN_INT_D = -2.147483648E9;
    static final double MAX_INT_D = 2.147483647E9;
    protected static final int INT_0 = 48;
    protected static final int INT_9 = 57;
    protected static final int INT_MINUS = 45;
    protected static final int INT_PLUS = 43;
    protected static final char CHAR_NULL = '\u0000';
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected long _numberLong;
    protected double _numberDouble;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;
    protected boolean _numberNegative;
    protected int _intLength;
    protected int _fractLength;
    protected int _expLength;

    protected ParserBase(IOContext object, int n2) {
        super(n2);
        this._ioContext = object;
        this._textBuffer = ((IOContext)object).constructTextBuffer();
        object = JsonParser$Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n2) ? DupDetector.rootDetector(this) : null;
        this._parsingContext = JsonReadContext.createRootContext((DupDetector)object);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public Object getCurrentValue() {
        return this._parsingContext.getCurrentValue();
    }

    @Override
    public void setCurrentValue(Object object) {
        this._parsingContext.setCurrentValue(object);
    }

    @Override
    public JsonParser enable(JsonParser$Feature jsonParser$Feature) {
        this._features |= jsonParser$Feature.getMask();
        if (jsonParser$Feature == JsonParser$Feature.STRICT_DUPLICATE_DETECTION && this._parsingContext.getDupDetector() == null) {
            this._parsingContext = this._parsingContext.withDupDetector(DupDetector.rootDetector(this));
        }
        return this;
    }

    @Override
    public JsonParser disable(JsonParser$Feature jsonParser$Feature) {
        this._features &= ~jsonParser$Feature.getMask();
        if (jsonParser$Feature == JsonParser$Feature.STRICT_DUPLICATE_DETECTION) {
            this._parsingContext = this._parsingContext.withDupDetector(null);
        }
        return this;
    }

    @Override
    public JsonParser setFeatureMask(int n2) {
        if ((this._features ^ n2) != 0) {
            this._features = n2;
            if (JsonParser$Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n2)) {
                if (this._parsingContext.getDupDetector() == null) {
                    this._parsingContext = this._parsingContext.withDupDetector(DupDetector.rootDetector(this));
                }
            } else {
                this._parsingContext = this._parsingContext.withDupDetector(null);
            }
        }
        return this;
    }

    @Override
    public String getCurrentName() {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            return this._parsingContext.getParent().getCurrentName();
        }
        return this._parsingContext.getCurrentName();
    }

    @Override
    public void overrideCurrentName(String string) {
        JsonReadContext jsonReadContext = this._parsingContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            jsonReadContext = jsonReadContext.getParent();
        }
        try {
            jsonReadContext.setCurrentName(string);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public void close() {
        if (!this._closed) {
            this._closed = true;
            try {
                this._closeInput();
                return;
            }
            finally {
                this._releaseBuffers();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public JsonReadContext getParsingContext() {
        return this._parsingContext;
    }

    @Override
    public JsonLocation getTokenLocation() {
        return new JsonLocation(this._ioContext.getSourceReference(), -1L, this.getTokenCharacterOffset(), this.getTokenLineNr(), this.getTokenColumnNr());
    }

    @Override
    public JsonLocation getCurrentLocation() {
        int n2 = this._inputPtr - this._currInputRowStart + 1;
        return new JsonLocation(this._ioContext.getSourceReference(), -1L, this._currInputProcessed + (long)this._inputPtr, this._currInputRow, n2);
    }

    @Override
    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return true;
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    @Override
    public Object getEmbeddedObject() {
        return null;
    }

    public long getTokenCharacterOffset() {
        return this._tokenInputTotal;
    }

    public int getTokenLineNr() {
        return this._tokenInputRow;
    }

    public int getTokenColumnNr() {
        int n2 = this._tokenInputCol;
        if (n2 < 0) {
            return n2;
        }
        return n2 + 1;
    }

    protected final void loadMoreGuaranteed() {
        if (!this.loadMore()) {
            this._reportInvalidEOF();
        }
    }

    protected abstract boolean loadMore();

    protected abstract void _finishString();

    protected abstract void _closeInput();

    protected void _releaseBuffers() {
        this._textBuffer.releaseBuffers();
        char[] cArray = this._nameCopyBuffer;
        if (this._nameCopyBuffer != null) {
            this._nameCopyBuffer = null;
            this._ioContext.releaseNameCopyBuffer(cArray);
        }
    }

    @Override
    protected void _handleEOF() {
        if (!this._parsingContext.inRoot()) {
            this._reportInvalidEOF(": expected close marker for " + this._parsingContext.getTypeDesc() + " (from " + this._parsingContext.getStartLocation(this._ioContext.getSourceReference()) + ")");
        }
    }

    protected final int _eofAsNextChar() {
        this._handleEOF();
        return -1;
    }

    protected void _reportMismatchedEndMarker(int n2, char c2) {
        String string = "" + this._parsingContext.getStartLocation(this._ioContext.getSourceReference());
        this._reportError("Unexpected close marker '" + (char)n2 + "': expected '" + c2 + "' (for " + this._parsingContext.getTypeDesc() + " starting at " + string + ")");
    }

    public ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected final JsonToken reset(boolean bl, int n2, int n3, int n4) {
        if (n3 <= 0 && n4 <= 0) {
            return this.resetInt(bl, n2);
        }
        return this.resetFloat(bl, n2, n3, n4);
    }

    protected final JsonToken resetInt(boolean bl, int n2) {
        this._numberNegative = bl;
        this._intLength = n2;
        this._fractLength = 0;
        this._expLength = 0;
        this._numTypesValid = 0;
        return JsonToken.VALUE_NUMBER_INT;
    }

    protected final JsonToken resetFloat(boolean bl, int n2, int n3, int n4) {
        this._numberNegative = bl;
        this._intLength = n2;
        this._fractLength = n3;
        this._expLength = n4;
        this._numTypesValid = 0;
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    protected final JsonToken resetAsNaN(String string, double d2) {
        this._textBuffer.resetWithString(string);
        this._numberDouble = d2;
        this._numTypesValid = 8;
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public Number getNumberValue() {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._numberBigInt;
            }
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._numberDouble;
    }

    @Override
    public JsonParser$NumberType getNumberType() {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return JsonParser$NumberType.INT;
            }
            if ((this._numTypesValid & 2) != 0) {
                return JsonParser$NumberType.LONG;
            }
            return JsonParser$NumberType.BIG_INTEGER;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return JsonParser$NumberType.BIG_DECIMAL;
        }
        return JsonParser$NumberType.DOUBLE;
    }

    @Override
    public int getIntValue() {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                return this._parseIntValue();
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    @Override
    public long getLongValue() {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    @Override
    public float getFloatValue() {
        return (float)this.getDoubleValue();
    }

    @Override
    public double getDoubleValue() {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(8);
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._numberDouble;
    }

    @Override
    public BigDecimal getDecimalValue() {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(16);
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._numberBigDecimal;
    }

    protected void _parseNumericValue(int n2) {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            char[] cArray = this._textBuffer.getTextBuffer();
            int n3 = this._textBuffer.getTextOffset();
            int n4 = this._intLength;
            if (this._numberNegative) {
                ++n3;
            }
            if (n4 <= 9) {
                int n5 = NumberInput.parseInt(cArray, n3, n4);
                this._numberInt = this._numberNegative ? -n5 : n5;
                this._numTypesValid = 1;
                return;
            }
            if (n4 <= 18) {
                long l2 = NumberInput.parseLong(cArray, n3, n4);
                if (this._numberNegative) {
                    l2 = -l2;
                }
                if (n4 == 10) {
                    if (this._numberNegative) {
                        if (l2 >= Integer.MIN_VALUE) {
                            this._numberInt = (int)l2;
                            this._numTypesValid = 1;
                            return;
                        }
                    } else if (l2 <= Integer.MAX_VALUE) {
                        this._numberInt = (int)l2;
                        this._numTypesValid = 1;
                        return;
                    }
                }
                this._numberLong = l2;
                this._numTypesValid = 2;
                return;
            }
            this._parseSlowInt(n2, cArray, n3, n4);
            return;
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            this._parseSlowFloat(n2);
            return;
        }
        this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not numeric, can not use numeric value accessors");
    }

    protected int _parseIntValue() {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            char[] cArray = this._textBuffer.getTextBuffer();
            int n2 = this._textBuffer.getTextOffset();
            int n3 = this._intLength;
            if (this._numberNegative) {
                ++n2;
            }
            if (n3 <= 9) {
                int n4 = NumberInput.parseInt(cArray, n2, n3);
                if (this._numberNegative) {
                    n4 = -n4;
                }
                this._numberInt = n4;
                this._numTypesValid = 1;
                return n4;
            }
        }
        this._parseNumericValue(1);
        if ((this._numTypesValid & 1) == 0) {
            this.convertNumberToInt();
        }
        return this._numberInt;
    }

    private void _parseSlowFloat(int n2) {
        try {
            if (n2 == 16) {
                this._numberBigDecimal = this._textBuffer.contentsAsDecimal();
                this._numTypesValid = 16;
                return;
            }
            this._numberDouble = this._textBuffer.contentsAsDouble();
            this._numTypesValid = 8;
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this._wrapError("Malformed numeric value '" + this._textBuffer.contentsAsString() + "'", numberFormatException);
            return;
        }
    }

    private void _parseSlowInt(int n2, char[] cArray, int n3, int n4) {
        String string = this._textBuffer.contentsAsString();
        try {
            if (NumberInput.inLongRange(cArray, n3, n4, this._numberNegative)) {
                this._numberLong = Long.parseLong(string);
                this._numTypesValid = 2;
                return;
            }
            this._numberBigInt = new BigInteger(string);
            this._numTypesValid = 4;
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this._wrapError("Malformed numeric value '" + string + "'", numberFormatException);
            return;
        }
    }

    protected void convertNumberToInt() {
        if ((this._numTypesValid & 2) != 0) {
            int n2 = (int)this._numberLong;
            if ((long)n2 != this._numberLong) {
                this._reportError("Numeric value (" + this.getText() + ") out of range of int");
            }
            this._numberInt = n2;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_INT.compareTo(this._numberBigInt) > 0 || BI_MAX_INT.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigInt.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -2.147483648E9 || this._numberDouble > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberDouble;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_INT.compareTo(this._numberBigDecimal) > 0 || BD_MAX_INT.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void convertNumberToLong() {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_LONG.compareTo(this._numberBigInt) > 0 || BI_MAX_LONG.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigInt.longValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -9.223372036854776E18 || this._numberDouble > 9.223372036854776E18) {
                this.reportOverflowLong();
            }
            this._numberLong = (long)this._numberDouble;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_LONG.compareTo(this._numberBigDecimal) > 0 || BD_MAX_LONG.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void convertNumberToBigInteger() {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberBigInt = this._numberBigDecimal.toBigInteger();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberDouble).toBigInteger();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected void convertNumberToDouble() {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberBigDecimal.doubleValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberBigInt.doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected void convertNumberToBigDecimal() {
        if ((this._numTypesValid & 8) != 0) {
            this._numberBigDecimal = NumberInput.parseBigDecimal(this.getText());
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberBigInt);
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    protected void reportUnexpectedNumberChar(int n2, String string) {
        String string2 = "Unexpected character (" + ParserBase._getCharDesc(n2) + ") in numeric value";
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        this._reportError(string2);
    }

    protected void reportInvalidNumber(String string) {
        this._reportError("Invalid numeric value: " + string);
    }

    protected void reportOverflowInt() {
        this._reportError("Numeric value (" + this.getText() + ") out of range of int (-2147483648 - 2147483647)");
    }

    protected void reportOverflowLong() {
        this._reportError("Numeric value (" + this.getText() + ") out of range of long (-9223372036854775808 - 9223372036854775807)");
    }

    protected char _decodeEscaped() {
        throw new UnsupportedOperationException();
    }

    protected final int _decodeBase64Escape(Base64Variant base64Variant, int n2, int n3) {
        if (n2 != 92) {
            throw this.reportInvalidBase64Char(base64Variant, n2, n3);
        }
        char c2 = this._decodeEscaped();
        n2 = c2;
        if (c2 <= ' ' && n3 == 0) {
            return -1;
        }
        int n4 = base64Variant.decodeBase64Char(n2);
        if (n4 < 0) {
            throw this.reportInvalidBase64Char(base64Variant, n2, n3);
        }
        return n4;
    }

    protected final int _decodeBase64Escape(Base64Variant base64Variant, char c2, int n2) {
        if (c2 != '\\') {
            throw this.reportInvalidBase64Char(base64Variant, c2, n2);
        }
        c2 = this._decodeEscaped();
        if (c2 <= ' ' && n2 == 0) {
            return -1;
        }
        int n3 = base64Variant.decodeBase64Char(c2);
        if (n3 < 0) {
            throw this.reportInvalidBase64Char(base64Variant, c2, n2);
        }
        return n3;
    }

    protected IllegalArgumentException reportInvalidBase64Char(Base64Variant base64Variant, int n2, int n3) {
        return this.reportInvalidBase64Char(base64Variant, n2, n3, null);
    }

    protected IllegalArgumentException reportInvalidBase64Char(Base64Variant object, int n2, int n3, String string) {
        object = n2 <= 32 ? "Illegal white space character (code 0x" + Integer.toHexString(n2) + ") as character #" + (n3 + 1) + " of 4-char base64 unit: can only used between units" : (((Base64Variant)object).usesPaddingChar(n2) ? "Unexpected padding character ('" + ((Base64Variant)object).getPaddingChar() + "') as character #" + (n3 + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(n2) || Character.isISOControl(n2) ? "Illegal character (code 0x" + Integer.toHexString(n2) + ") in base64 content" : "Illegal character '" + (char)n2 + "' (code 0x" + Integer.toHexString(n2) + ") in base64 content"));
        if (string != null) {
            object = (String)object + ": " + string;
        }
        return new IllegalArgumentException((String)object);
    }
}

