/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.BufferRecycler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;

public final class TextBuffer {
    static final char[] NO_CHARS = new char[0];
    static final int MIN_SEGMENT_LEN = 1000;
    static final int MAX_SEGMENT_LEN = 262144;
    private final BufferRecycler _allocator;
    private char[] _inputBuffer;
    private int _inputStart;
    private int _inputLen;
    private ArrayList<char[]> _segments;
    private boolean _hasSegments = false;
    private int _segmentSize;
    private char[] _currentSegment;
    private int _currentSize;
    private String _resultString;
    private char[] _resultArray;

    public TextBuffer(BufferRecycler bufferRecycler) {
        this._allocator = bufferRecycler;
    }

    public final void releaseBuffers() {
        if (this._allocator == null) {
            this.resetWithEmpty();
            return;
        }
        if (this._currentSegment != null) {
            this.resetWithEmpty();
            char[] cArray = this._currentSegment;
            this._currentSegment = null;
            this._allocator.releaseCharBuffer(2, cArray);
        }
    }

    public final void resetWithEmpty() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public final void resetWithShared(char[] cArray, int n, int n2) {
        this._resultString = null;
        this._resultArray = null;
        this._inputBuffer = cArray;
        this._inputStart = n;
        this._inputLen = n2;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public final void resetWithCopy(char[] cArray, int n, int n2) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        } else if (this._currentSegment == null) {
            this._currentSegment = this.buf(n2);
        }
        this._segmentSize = 0;
        this._currentSize = 0;
        this.append(cArray, n, n2);
    }

    public final void resetWithString(String string) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = string;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        this._currentSize = 0;
    }

    private char[] buf(int n) {
        if (this._allocator != null) {
            return this._allocator.allocCharBuffer(2, n);
        }
        return new char[Math.max(n, 1000)];
    }

    private void clearSegments() {
        this._hasSegments = false;
        this._segments.clear();
        this._segmentSize = 0;
        this._currentSize = 0;
    }

    public final int size() {
        if (this._inputStart >= 0) {
            return this._inputLen;
        }
        if (this._resultArray != null) {
            return this._resultArray.length;
        }
        if (this._resultString != null) {
            return this._resultString.length();
        }
        return this._segmentSize + this._currentSize;
    }

    public final int getTextOffset() {
        if (this._inputStart >= 0) {
            return this._inputStart;
        }
        return 0;
    }

    public final boolean hasTextAsCharacters() {
        if (this._inputStart >= 0 || this._resultArray != null) {
            return true;
        }
        return this._resultString == null;
    }

    public final char[] getTextBuffer() {
        if (this._inputStart >= 0) {
            return this._inputBuffer;
        }
        if (this._resultArray != null) {
            return this._resultArray;
        }
        if (this._resultString != null) {
            this._resultArray = this._resultString.toCharArray();
            return this._resultArray;
        }
        if (!this._hasSegments) {
            if (this._currentSegment == null) {
                return NO_CHARS;
            }
            return this._currentSegment;
        }
        return this.contentsAsArray();
    }

    public final String contentsAsString() {
        if (this._resultString == null) {
            if (this._resultArray != null) {
                this._resultString = new String(this._resultArray);
            } else if (this._inputStart >= 0) {
                if (this._inputLen <= 0) {
                    this._resultString = "";
                    return "";
                }
                this._resultString = new String(this._inputBuffer, this._inputStart, this._inputLen);
            } else {
                int n = this._segmentSize;
                int n2 = this._currentSize;
                if (n == 0) {
                    this._resultString = n2 == 0 ? "" : new String(this._currentSegment, 0, n2);
                } else {
                    StringBuilder stringBuilder = new StringBuilder(n + n2);
                    if (this._segments != null) {
                        int n3 = this._segments.size();
                        for (n2 = 0; n2 < n3; ++n2) {
                            char[] cArray = this._segments.get(n2);
                            stringBuilder.append(cArray, 0, cArray.length);
                        }
                    }
                    stringBuilder.append(this._currentSegment, 0, this._currentSize);
                    this._resultString = stringBuilder.toString();
                }
            }
        }
        return this._resultString;
    }

    public final char[] contentsAsArray() {
        char[] cArray = this._resultArray;
        if (this._resultArray == null) {
            this._resultArray = cArray = this.resultArray();
        }
        return cArray;
    }

    public final BigDecimal contentsAsDecimal() {
        if (this._resultArray != null) {
            return NumberInput.parseBigDecimal(this._resultArray);
        }
        if (this._inputStart >= 0 && this._inputBuffer != null) {
            return NumberInput.parseBigDecimal(this._inputBuffer, this._inputStart, this._inputLen);
        }
        if (this._segmentSize == 0 && this._currentSegment != null) {
            return NumberInput.parseBigDecimal(this._currentSegment, 0, this._currentSize);
        }
        return NumberInput.parseBigDecimal(this.contentsAsArray());
    }

    public final double contentsAsDouble() {
        return NumberInput.parseDouble(this.contentsAsString());
    }

    public final void ensureNotShared() {
        if (this._inputStart >= 0) {
            this.unshare(16);
        }
    }

    public final void append(char c2) {
        if (this._inputStart >= 0) {
            this.unshare(16);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        if (this._currentSize >= cArray.length) {
            this.expand(1);
            cArray = this._currentSegment;
        }
        cArray[this._currentSize++] = c2;
    }

    public final void append(char[] cArray, int n, int n2) {
        int n3;
        if (this._inputStart >= 0) {
            this.unshare(n2);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray2 = this._currentSegment;
        int n4 = this._currentSegment.length - this._currentSize;
        if (n4 >= n2) {
            System.arraycopy(cArray, n, cArray2, this._currentSize, n2);
            this._currentSize += n2;
            return;
        }
        if (n4 > 0) {
            System.arraycopy(cArray, n, cArray2, this._currentSize, n4);
            n += n4;
            n2 -= n4;
        }
        do {
            this.expand(n2);
            n3 = Math.min(this._currentSegment.length, n2);
            System.arraycopy(cArray, n, this._currentSegment, 0, n3);
            this._currentSize += n3;
            n += n3;
        } while ((n2 -= n3) > 0);
    }

    public final void append(String string, int n, int n2) {
        int n3;
        if (this._inputStart >= 0) {
            this.unshare(n2);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        int n4 = this._currentSegment.length - this._currentSize;
        if (n4 >= n2) {
            string.getChars(n, n + n2, cArray, this._currentSize);
            this._currentSize += n2;
            return;
        }
        if (n4 > 0) {
            string.getChars(n, n + n4, cArray, this._currentSize);
            n2 -= n4;
            n += n4;
        }
        do {
            this.expand(n2);
            n3 = Math.min(this._currentSegment.length, n2);
            string.getChars(n, n + n3, this._currentSegment, 0);
            this._currentSize += n3;
            n += n3;
        } while ((n2 -= n3) > 0);
    }

    public final char[] getCurrentSegment() {
        if (this._inputStart >= 0) {
            this.unshare(1);
        } else {
            char[] cArray = this._currentSegment;
            if (this._currentSegment == null) {
                this._currentSegment = this.buf(0);
            } else if (this._currentSize >= cArray.length) {
                this.expand(1);
            }
        }
        return this._currentSegment;
    }

    public final char[] emptyAndGetCurrentSegment() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        char[] cArray = this._currentSegment;
        if (this._currentSegment == null) {
            this._currentSegment = cArray = this.buf(0);
        }
        return cArray;
    }

    public final int getCurrentSegmentSize() {
        return this._currentSize;
    }

    public final void setCurrentLength(int n) {
        this._currentSize = n;
    }

    public final String setCurrentAndReturn(int n) {
        String string;
        this._currentSize = n;
        if (this._segmentSize > 0) {
            return this.contentsAsString();
        }
        n = this._currentSize;
        this._resultString = string = n == 0 ? "" : new String(this._currentSegment, 0, n);
        return string;
    }

    public final char[] finishCurrentSegment() {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        this._hasSegments = true;
        this._segments.add(this._currentSegment);
        int n = this._currentSegment.length;
        this._segmentSize += n;
        this._currentSize = 0;
        n += n >> 1;
        if (n < 1000) {
            n = 1000;
        } else if (n > 262144) {
            n = 262144;
        }
        char[] cArray = this.carr(n);
        this._currentSegment = cArray;
        return cArray;
    }

    public final char[] expandCurrentSegment() {
        char[] cArray = this._currentSegment;
        int n = this._currentSegment.length;
        int n2 = n + (n >> 1);
        if (n2 > 262144) {
            n2 = n + (n >> 2);
        }
        this._currentSegment = Arrays.copyOf(cArray, n2);
        return this._currentSegment;
    }

    public final char[] expandCurrentSegment(int n) {
        char[] cArray = this._currentSegment;
        if (this._currentSegment.length >= n) {
            return cArray;
        }
        this._currentSegment = cArray = Arrays.copyOf(cArray, n);
        return cArray;
    }

    public final String toString() {
        return this.contentsAsString();
    }

    private void unshare(int n) {
        int n2 = this._inputLen;
        this._inputLen = 0;
        char[] cArray = this._inputBuffer;
        this._inputBuffer = null;
        int n3 = this._inputStart;
        this._inputStart = -1;
        n = n2 + n;
        if (this._currentSegment == null || n > this._currentSegment.length) {
            this._currentSegment = this.buf(n);
        }
        if (n2 > 0) {
            System.arraycopy(cArray, n3, this._currentSegment, 0, n2);
        }
        this._segmentSize = 0;
        this._currentSize = n2;
    }

    private void expand(int n) {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        char[] cArray = this._currentSegment;
        this._hasSegments = true;
        this._segments.add(cArray);
        this._segmentSize += cArray.length;
        this._currentSize = 0;
        int n2 = cArray.length;
        int n3 = n2 + (n2 >> 1);
        if (n3 < 1000) {
            n3 = 1000;
        } else if (n3 > 262144) {
            n3 = 262144;
        }
        this._currentSegment = this.carr(n3);
    }

    private char[] resultArray() {
        if (this._resultString != null) {
            return this._resultString.toCharArray();
        }
        if (this._inputStart >= 0) {
            int n = this._inputLen;
            if (n <= 0) {
                return NO_CHARS;
            }
            int n2 = this._inputStart;
            if (n2 == 0) {
                return Arrays.copyOf(this._inputBuffer, n);
            }
            return Arrays.copyOfRange(this._inputBuffer, n2, n2 + n);
        }
        int n = this.size();
        if (n <= 0) {
            return NO_CHARS;
        }
        int n3 = 0;
        char[] cArray = this.carr(n);
        if (this._segments != null) {
            int n4 = this._segments.size();
            for (int k = 0; k < n4; ++k) {
                char[] cArray2 = this._segments.get(k);
                int n5 = cArray2.length;
                System.arraycopy(cArray2, 0, cArray, n3, n5);
                n3 += n5;
            }
        }
        System.arraycopy(this._currentSegment, 0, cArray, n3, this._currentSize);
        return cArray;
    }

    private char[] carr(int n) {
        return new char[n];
    }
}

