/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonLocation;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonStreamContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.CharTypes;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.DupDetector;

public final class JsonReadContext
extends JsonStreamContext {
    protected final JsonReadContext _parent;
    protected DupDetector _dups;
    protected JsonReadContext _child = null;
    protected String _currentName;
    protected Object _currentValue;
    protected int _lineNr;
    protected int _columnNr;

    public JsonReadContext(JsonReadContext jsonReadContext, DupDetector dupDetector, int n, int n2, int n3) {
        this._parent = jsonReadContext;
        this._dups = dupDetector;
        this._type = n;
        this._lineNr = n2;
        this._columnNr = n3;
        this._index = -1;
    }

    protected final void reset(int n, int n2, int n3) {
        this._type = n;
        this._index = -1;
        this._lineNr = n2;
        this._columnNr = n3;
        this._currentName = null;
        this._currentValue = null;
        if (this._dups != null) {
            this._dups.reset();
        }
    }

    public final JsonReadContext withDupDetector(DupDetector dupDetector) {
        this._dups = dupDetector;
        return this;
    }

    @Override
    public final Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public final void setCurrentValue(Object object) {
        this._currentValue = object;
    }

    @Deprecated
    public static JsonReadContext createRootContext(int n, int n2) {
        return JsonReadContext.createRootContext(n, n2, null);
    }

    public static JsonReadContext createRootContext(int n, int n2, DupDetector dupDetector) {
        return new JsonReadContext(null, dupDetector, 0, n, n2);
    }

    @Deprecated
    public static JsonReadContext createRootContext() {
        return JsonReadContext.createRootContext(null);
    }

    public static JsonReadContext createRootContext(DupDetector dupDetector) {
        return new JsonReadContext(null, dupDetector, 0, 1, 0);
    }

    public final JsonReadContext createChildArrayContext(int n, int n2) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            this._child = jsonReadContext = new JsonReadContext(this, this._dups == null ? null : this._dups.child(), 1, n, n2);
        } else {
            jsonReadContext.reset(1, n, n2);
        }
        return jsonReadContext;
    }

    public final JsonReadContext createChildObjectContext(int n, int n2) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            this._child = jsonReadContext = new JsonReadContext(this, this._dups == null ? null : this._dups.child(), 2, n, n2);
            return jsonReadContext;
        }
        jsonReadContext.reset(2, n, n2);
        return jsonReadContext;
    }

    @Override
    public final String getCurrentName() {
        return this._currentName;
    }

    @Override
    public final JsonReadContext getParent() {
        return this._parent;
    }

    public final JsonLocation getStartLocation(Object object) {
        return new JsonLocation(object, -1L, this._lineNr, this._columnNr);
    }

    public final DupDetector getDupDetector() {
        return this._dups;
    }

    public final boolean expectComma() {
        int n = ++this._index;
        return this._type != 0 && n > 0;
    }

    public final void setCurrentName(String string) {
        this._currentName = string;
        if (this._dups != null) {
            this._checkDup(this._dups, string);
        }
    }

    private void _checkDup(DupDetector dupDetector, String string) {
        if (dupDetector.isDup(string)) {
            throw new JsonParseException("Duplicate field '" + string + "'", dupDetector.findLocation());
        }
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                stringBuilder.append("/");
                break;
            }
            case 1: {
                stringBuilder.append('[');
                stringBuilder.append(this.getCurrentIndex());
                stringBuilder.append(']');
                break;
            }
            case 2: {
                stringBuilder.append('{');
                if (this._currentName != null) {
                    stringBuilder.append('\"');
                    CharTypes.appendQuoted(stringBuilder, this._currentName);
                    stringBuilder.append('\"');
                } else {
                    stringBuilder.append('?');
                }
                stringBuilder.append('}');
            }
        }
        return stringBuilder.toString();
    }
}

