/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.FormatFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.FormatSchema;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonEncoding;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonFactory$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Version;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Versioned;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.format.InputAccessor;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.format.MatchStrength;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.CharacterEscapes;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.InputDecorator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.OutputDecorator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.SerializedString;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.UTF8Writer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.ByteSourceJsonBootstrapper;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.JsonGeneratorImpl;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.PackageVersion;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.ReaderBasedJsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.UTF8JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.WriterBasedJsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym.BytesToNameCanonicalizer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.BufferRecycler;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.URL;

public class JsonFactory
implements Versioned,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_JSON = "JSON";
    protected static final int DEFAULT_FACTORY_FEATURE_FLAGS = JsonFactory$Feature.collectDefaults();
    protected static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser$Feature.collectDefaults();
    protected static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator$Feature.collectDefaults();
    private static final SerializableString DEFAULT_ROOT_VALUE_SEPARATOR = DefaultPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR;
    protected static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef = new ThreadLocal();
    protected final transient CharsToNameCanonicalizer _rootCharSymbols = CharsToNameCanonicalizer.createRoot();
    protected final transient ByteQuadsCanonicalizer _byteSymbolCanonicalizer = ByteQuadsCanonicalizer.createRoot();
    @Deprecated
    protected final transient BytesToNameCanonicalizer _rootByteSymbols = BytesToNameCanonicalizer.createRoot();
    protected ObjectCodec _objectCodec;
    protected int _factoryFeatures = DEFAULT_FACTORY_FEATURE_FLAGS;
    protected int _parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
    protected int _generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;
    protected CharacterEscapes _characterEscapes;
    protected InputDecorator _inputDecorator;
    protected OutputDecorator _outputDecorator;
    protected SerializableString _rootValueSeparator = DEFAULT_ROOT_VALUE_SEPARATOR;

    public JsonFactory() {
        this(null);
    }

    public JsonFactory(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    protected JsonFactory(JsonFactory jsonFactory, ObjectCodec objectCodec) {
        this._objectCodec = null;
        this._factoryFeatures = jsonFactory._factoryFeatures;
        this._parserFeatures = jsonFactory._parserFeatures;
        this._generatorFeatures = jsonFactory._generatorFeatures;
        this._characterEscapes = jsonFactory._characterEscapes;
        this._inputDecorator = jsonFactory._inputDecorator;
        this._outputDecorator = jsonFactory._outputDecorator;
        this._rootValueSeparator = jsonFactory._rootValueSeparator;
    }

    public JsonFactory copy() {
        this._checkInvalidCopy(JsonFactory.class);
        return new JsonFactory(this, null);
    }

    protected void _checkInvalidCopy(Class<?> clazz) {
        if (this.getClass() != clazz) {
            throw new IllegalStateException("Failed copy(): " + this.getClass().getName() + " (version: " + this.version() + ") does not override copy(); it has to");
        }
    }

    protected Object readResolve() {
        return new JsonFactory(this, this._objectCodec);
    }

    public boolean requiresPropertyOrdering() {
        return false;
    }

    public boolean canHandleBinaryNatively() {
        return false;
    }

    public boolean canUseCharArrays() {
        return true;
    }

    public Class<? extends FormatFeature> getFormatReadFeatureType() {
        return null;
    }

    public Class<? extends FormatFeature> getFormatWriteFeatureType() {
        return null;
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        String string = this.getFormatName();
        return string != null && string.equals(formatSchema.getSchemaType());
    }

    public String getFormatName() {
        if (this.getClass() == JsonFactory.class) {
            return FORMAT_NAME_JSON;
        }
        return null;
    }

    public MatchStrength hasFormat(InputAccessor inputAccessor) {
        if (this.getClass() == JsonFactory.class) {
            return this.hasJSONFormat(inputAccessor);
        }
        return null;
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    protected MatchStrength hasJSONFormat(InputAccessor inputAccessor) {
        return ByteSourceJsonBootstrapper.hasJSONFormat(inputAccessor);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public final JsonFactory configure(JsonFactory$Feature jsonFactory$Feature, boolean bl) {
        if (bl) {
            return this.enable(jsonFactory$Feature);
        }
        return this.disable(jsonFactory$Feature);
    }

    public JsonFactory enable(JsonFactory$Feature jsonFactory$Feature) {
        this._factoryFeatures |= jsonFactory$Feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonFactory$Feature jsonFactory$Feature) {
        this._factoryFeatures &= ~jsonFactory$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonFactory$Feature jsonFactory$Feature) {
        return (this._factoryFeatures & jsonFactory$Feature.getMask()) != 0;
    }

    public final JsonFactory configure(JsonParser$Feature jsonParser$Feature, boolean bl) {
        if (bl) {
            return this.enable(jsonParser$Feature);
        }
        return this.disable(jsonParser$Feature);
    }

    public JsonFactory enable(JsonParser$Feature jsonParser$Feature) {
        this._parserFeatures |= jsonParser$Feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonParser$Feature jsonParser$Feature) {
        this._parserFeatures &= ~jsonParser$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonParser$Feature jsonParser$Feature) {
        return (this._parserFeatures & jsonParser$Feature.getMask()) != 0;
    }

    public InputDecorator getInputDecorator() {
        return this._inputDecorator;
    }

    public JsonFactory setInputDecorator(InputDecorator inputDecorator) {
        this._inputDecorator = inputDecorator;
        return this;
    }

    public final JsonFactory configure(JsonGenerator$Feature jsonGenerator$Feature, boolean bl) {
        if (bl) {
            return this.enable(jsonGenerator$Feature);
        }
        return this.disable(jsonGenerator$Feature);
    }

    public JsonFactory enable(JsonGenerator$Feature jsonGenerator$Feature) {
        this._generatorFeatures |= jsonGenerator$Feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonGenerator$Feature jsonGenerator$Feature) {
        this._generatorFeatures &= ~jsonGenerator$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonGenerator$Feature jsonGenerator$Feature) {
        return (this._generatorFeatures & jsonGenerator$Feature.getMask()) != 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    public JsonFactory setCharacterEscapes(CharacterEscapes characterEscapes) {
        this._characterEscapes = characterEscapes;
        return this;
    }

    public OutputDecorator getOutputDecorator() {
        return this._outputDecorator;
    }

    public JsonFactory setOutputDecorator(OutputDecorator outputDecorator) {
        this._outputDecorator = outputDecorator;
        return this;
    }

    public JsonFactory setRootValueSeparator(String string) {
        this._rootValueSeparator = string == null ? null : new SerializedString(string);
        return this;
    }

    public String getRootValueSeparator() {
        if (this._rootValueSeparator == null) {
            return null;
        }
        return this._rootValueSeparator.getValue();
    }

    public JsonFactory setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public JsonParser createParser(File object) {
        IOContext iOContext = this._createContext(object, true);
        object = new FileInputStream((File)object);
        return this._createParser(this._decorate((InputStream)object, iOContext), iOContext);
    }

    public JsonParser createParser(URL object) {
        IOContext iOContext = this._createContext(object, true);
        object = this._optimizedStreamFromURL((URL)object);
        return this._createParser(this._decorate((InputStream)object, iOContext), iOContext);
    }

    public JsonParser createParser(InputStream inputStream) {
        IOContext iOContext = this._createContext(inputStream, false);
        return this._createParser(this._decorate(inputStream, iOContext), iOContext);
    }

    public JsonParser createParser(Reader reader) {
        IOContext iOContext = this._createContext(reader, false);
        return this._createParser(this._decorate(reader, iOContext), iOContext);
    }

    public JsonParser createParser(byte[] byArray) {
        InputStream inputStream;
        IOContext iOContext = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, 0, byArray.length)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, 0, byArray.length, iOContext);
    }

    public JsonParser createParser(byte[] byArray, int n, int n2) {
        InputStream inputStream;
        IOContext iOContext = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, n, n2)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, n, n2, iOContext);
    }

    public JsonParser createParser(String string) {
        int n = string.length();
        if (this._inputDecorator != null || n > 32768 || !this.canUseCharArrays()) {
            return this.createParser(new StringReader(string));
        }
        IOContext iOContext = this._createContext(string, true);
        char[] cArray = iOContext.allocTokenBuffer(n);
        string.getChars(0, n, cArray, 0);
        return this._createParser(cArray, 0, n, iOContext, true);
    }

    public JsonParser createParser(char[] cArray) {
        return this.createParser(cArray, 0, cArray.length);
    }

    public JsonParser createParser(char[] cArray, int n, int n2) {
        if (this._inputDecorator != null) {
            return this.createParser(new CharArrayReader(cArray, n, n2));
        }
        return this._createParser(cArray, n, n2, this._createContext(cArray, true), false);
    }

    @Deprecated
    public JsonParser createJsonParser(File file) {
        return this.createParser(file);
    }

    @Deprecated
    public JsonParser createJsonParser(URL uRL) {
        return this.createParser(uRL);
    }

    @Deprecated
    public JsonParser createJsonParser(InputStream inputStream) {
        return this.createParser(inputStream);
    }

    @Deprecated
    public JsonParser createJsonParser(Reader reader) {
        return this.createParser(reader);
    }

    @Deprecated
    public JsonParser createJsonParser(byte[] byArray) {
        return this.createParser(byArray);
    }

    @Deprecated
    public JsonParser createJsonParser(byte[] byArray, int n, int n2) {
        return this.createParser(byArray, n, n2);
    }

    @Deprecated
    public JsonParser createJsonParser(String string) {
        return this.createParser(string);
    }

    public JsonGenerator createGenerator(OutputStream closeable, JsonEncoding jsonEncoding) {
        IOContext iOContext = this._createContext(closeable, false);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            return this._createUTF8Generator(this._decorate((OutputStream)closeable, iOContext), iOContext);
        }
        closeable = this._createWriter((OutputStream)closeable, jsonEncoding, iOContext);
        return this._createGenerator(this._decorate((Writer)closeable, iOContext), iOContext);
    }

    public JsonGenerator createGenerator(OutputStream outputStream) {
        return this.createGenerator(outputStream, JsonEncoding.UTF8);
    }

    public JsonGenerator createGenerator(Writer writer) {
        IOContext iOContext = this._createContext(writer, false);
        return this._createGenerator(this._decorate(writer, iOContext), iOContext);
    }

    public JsonGenerator createGenerator(File object, JsonEncoding jsonEncoding) {
        object = new FileOutputStream((File)object);
        IOContext iOContext = this._createContext(object, true);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            return this._createUTF8Generator(this._decorate((OutputStream)object, iOContext), iOContext);
        }
        object = this._createWriter((OutputStream)object, jsonEncoding, iOContext);
        return this._createGenerator(this._decorate((Writer)object, iOContext), iOContext);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) {
        return this.createGenerator(outputStream, jsonEncoding);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(Writer writer) {
        return this.createGenerator(writer);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(OutputStream outputStream) {
        return this.createGenerator(outputStream, JsonEncoding.UTF8);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(File file, JsonEncoding jsonEncoding) {
        return this.createGenerator(file, jsonEncoding);
    }

    protected JsonParser _createParser(InputStream inputStream, IOContext iOContext) {
        return new ByteSourceJsonBootstrapper(iOContext, inputStream).constructParser(this._parserFeatures, this._objectCodec, this._byteSymbolCanonicalizer, this._rootCharSymbols, this._factoryFeatures);
    }

    protected JsonParser _createParser(Reader reader, IOContext iOContext) {
        return new ReaderBasedJsonParser(iOContext, this._parserFeatures, reader, this._objectCodec, this._rootCharSymbols.makeChild(this._factoryFeatures));
    }

    protected JsonParser _createParser(char[] cArray, int n, int n2, IOContext iOContext, boolean bl) {
        return new ReaderBasedJsonParser(iOContext, this._parserFeatures, null, this._objectCodec, this._rootCharSymbols.makeChild(this._factoryFeatures), cArray, n, n + n2, bl);
    }

    protected JsonParser _createParser(byte[] byArray, int n, int n2, IOContext iOContext) {
        return new ByteSourceJsonBootstrapper(iOContext, byArray, n, n2).constructParser(this._parserFeatures, this._objectCodec, this._byteSymbolCanonicalizer, this._rootCharSymbols, this._factoryFeatures);
    }

    protected JsonGenerator _createGenerator(Writer closeable, IOContext object) {
        closeable = new WriterBasedJsonGenerator((IOContext)object, this._generatorFeatures, this._objectCodec, (Writer)closeable);
        if (this._characterEscapes != null) {
            ((JsonGeneratorImpl)closeable).setCharacterEscapes(this._characterEscapes);
        }
        if ((object = this._rootValueSeparator) != DEFAULT_ROOT_VALUE_SEPARATOR) {
            ((JsonGeneratorImpl)closeable).setRootValueSeparator((SerializableString)object);
        }
        return closeable;
    }

    protected JsonGenerator _createUTF8Generator(OutputStream closeable, IOContext object) {
        closeable = new UTF8JsonGenerator((IOContext)object, this._generatorFeatures, this._objectCodec, (OutputStream)closeable);
        if (this._characterEscapes != null) {
            ((JsonGeneratorImpl)closeable).setCharacterEscapes(this._characterEscapes);
        }
        if ((object = this._rootValueSeparator) != DEFAULT_ROOT_VALUE_SEPARATOR) {
            ((JsonGeneratorImpl)closeable).setRootValueSeparator((SerializableString)object);
        }
        return closeable;
    }

    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) {
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Writer(iOContext, outputStream);
        }
        return new OutputStreamWriter(outputStream, jsonEncoding.getJavaName());
    }

    protected final InputStream _decorate(InputStream inputStream, IOContext object) {
        if (this._inputDecorator != null && (object = this._inputDecorator.decorate((IOContext)object, inputStream)) != null) {
            return object;
        }
        return inputStream;
    }

    protected final Reader _decorate(Reader reader, IOContext object) {
        if (this._inputDecorator != null && (object = this._inputDecorator.decorate((IOContext)object, reader)) != null) {
            return object;
        }
        return reader;
    }

    protected final OutputStream _decorate(OutputStream outputStream, IOContext object) {
        if (this._outputDecorator != null && (object = this._outputDecorator.decorate((IOContext)object, outputStream)) != null) {
            return object;
        }
        return outputStream;
    }

    protected final Writer _decorate(Writer writer, IOContext object) {
        if (this._outputDecorator != null && (object = this._outputDecorator.decorate((IOContext)object, writer)) != null) {
            return object;
        }
        return writer;
    }

    public BufferRecycler _getBufferRecycler() {
        SoftReference<BufferRecycler> softReference;
        if (this.isEnabled(JsonFactory$Feature.USE_THREAD_LOCAL_FOR_BUFFER_RECYCLING)) {
            softReference = _recyclerRef.get();
            softReference = softReference == null ? null : (BufferRecycler)softReference.get();
            if (softReference == null) {
                softReference = new BufferRecycler();
                _recyclerRef.set(new SoftReference<Object>(softReference));
            }
        } else {
            softReference = new BufferRecycler();
        }
        return softReference;
    }

    protected IOContext _createContext(Object object, boolean bl) {
        return new IOContext(this._getBufferRecycler(), object, bl);
    }

    protected InputStream _optimizedStreamFromURL(URL uRL) {
        String string;
        if ("file".equals(uRL.getProtocol()) && ((string = uRL.getHost()) == null || string.length() == 0) && uRL.getPath().indexOf(37) < 0) {
            return new FileInputStream(uRL.getPath());
        }
        return uRL.openStream();
    }
}

