/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.CharTypes;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.UTF8Writer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.TextBuffer;
import java.lang.ref.SoftReference;

public final class JsonStringEncoder {
    private static final char[] HC = CharTypes.copyHexChars();
    private static final byte[] HB = CharTypes.copyHexBytes();
    private static final int SURR1_FIRST = 55296;
    private static final int SURR1_LAST = 56319;
    private static final int SURR2_FIRST = 56320;
    private static final int SURR2_LAST = 57343;
    protected static final ThreadLocal<SoftReference<JsonStringEncoder>> _threadEncoder = new ThreadLocal();
    protected TextBuffer _text;
    protected ByteArrayBuilder _bytes;
    protected final char[] _qbuf = new char[6];

    public JsonStringEncoder() {
        this._qbuf[0] = 92;
        this._qbuf[2] = 48;
        this._qbuf[3] = 48;
    }

    public static JsonStringEncoder getInstance() {
        SoftReference<JsonStringEncoder> softReference = _threadEncoder.get();
        softReference = softReference == null ? null : softReference.get();
        if (softReference == null) {
            softReference = new JsonStringEncoder();
            _threadEncoder.set(new SoftReference<Object>(softReference));
        }
        return softReference;
    }

    public final char[] quoteAsString(String string) {
        TextBuffer textBuffer = this._text;
        if (textBuffer == null) {
            this._text = textBuffer = new TextBuffer(null);
        }
        char[] cArray = textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = CharTypes.get7BitOutputEscapes();
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        block0: while (n3 < n4) {
            int n6;
            int n7;
            while ((n7 = string.charAt(n3)) >= n2 || nArray[n7] == 0) {
                if (n5 >= cArray.length) {
                    cArray = textBuffer.finishCurrentSegment();
                    n5 = 0;
                }
                cArray[n5++] = n7;
                if (++n3 >= n4) break block0;
            }
            int n8 = n7 = (n6 = nArray[n7 = string.charAt(n3++)]) < 0 ? this._appendNumeric(n7, this._qbuf) : this._appendNamed(n6, this._qbuf);
            if (n5 + n7 > cArray.length) {
                n6 = cArray.length - n5;
                if (n6 > 0) {
                    System.arraycopy(this._qbuf, 0, cArray, n5, n6);
                }
                cArray = textBuffer.finishCurrentSegment();
                n5 = n7 - n6;
                System.arraycopy(this._qbuf, n6, cArray, 0, n5);
                continue;
            }
            System.arraycopy(this._qbuf, 0, cArray, n5, n7);
            n5 += n7;
        }
        textBuffer.setCurrentLength(n5);
        return textBuffer.contentsAsArray();
    }

    public final byte[] quoteAsUTF8(String string) {
        ByteArrayBuilder byteArrayBuilder = this._bytes;
        if (byteArrayBuilder == null) {
            this._bytes = byteArrayBuilder = new ByteArrayBuilder(null);
        }
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        byte[] byArray = byteArrayBuilder.resetAndGetFirstSegment();
        block0: while (n2 < n3) {
            int n5;
            int[] nArray = CharTypes.get7BitOutputEscapes();
            while ((n5 = string.charAt(n2)) <= 127 && nArray[n5] == 0) {
                if (n4 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = 0;
                }
                byArray[n4++] = (byte)n5;
                if (++n2 >= n3) break block0;
            }
            if (n4 >= byArray.length) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = 0;
            }
            if ((n5 = string.charAt(n2++)) <= 127) {
                int n6 = nArray[n5];
                n4 = this._appendByte(n5, n6, byteArrayBuilder, n4);
                byArray = byteArrayBuilder.getCurrentSegment();
                continue;
            }
            if (n5 <= 2047) {
                byArray[n4++] = (byte)(0xC0 | n5 >> 6);
                n5 = 0x80 | n5 & 0x3F;
            } else if (n5 < 55296 || n5 > 57343) {
                byArray[n4++] = (byte)(0xE0 | n5 >> 12);
                if (n4 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                n5 = 0x80 | n5 & 0x3F;
            } else {
                if (n5 > 56319) {
                    JsonStringEncoder._illegal(n5);
                }
                if (n2 >= n3) {
                    JsonStringEncoder._illegal(n5);
                }
                if ((n5 = JsonStringEncoder._convert(n5, string.charAt(n2++))) > 0x10FFFF) {
                    JsonStringEncoder._illegal(n5);
                }
                byArray[n4++] = (byte)(0xF0 | n5 >> 18);
                if (n4 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                if (n4 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                n5 = 0x80 | n5 & 0x3F;
            }
            if (n4 >= byArray.length) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = 0;
            }
            byArray[n4++] = (byte)n5;
        }
        return this._bytes.completeAndCoalesce(n4);
    }

    public final byte[] encodeAsUTF8(String string) {
        ByteArrayBuilder byteArrayBuilder = this._bytes;
        if (byteArrayBuilder == null) {
            this._bytes = byteArrayBuilder = new ByteArrayBuilder(null);
        }
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        byte[] byArray = byteArrayBuilder.resetAndGetFirstSegment();
        int n5 = byArray.length;
        block0: while (n2 < n3) {
            int n6 = string.charAt(n2++);
            while (n6 <= 127) {
                if (n4 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n4 = 0;
                }
                byArray[n4++] = (byte)n6;
                if (n2 >= n3) break block0;
                n6 = string.charAt(n2++);
            }
            if (n4 >= n5) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n5 = byArray.length;
                n4 = 0;
            }
            if (n6 < 2048) {
                byArray[n4++] = (byte)(0xC0 | n6 >> 6);
            } else if (n6 < 55296 || n6 > 57343) {
                byArray[n4++] = (byte)(0xE0 | n6 >> 12);
                if (n4 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n6 >> 6 & 0x3F);
            } else {
                if (n6 > 56319) {
                    JsonStringEncoder._illegal(n6);
                }
                if (n2 >= n3) {
                    JsonStringEncoder._illegal(n6);
                }
                if ((n6 = JsonStringEncoder._convert(n6, string.charAt(n2++))) > 0x10FFFF) {
                    JsonStringEncoder._illegal(n6);
                }
                byArray[n4++] = (byte)(0xF0 | n6 >> 18);
                if (n4 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                if (n4 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n6 >> 6 & 0x3F);
            }
            if (n4 >= n5) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n5 = byArray.length;
                n4 = 0;
            }
            byArray[n4++] = (byte)(0x80 | n6 & 0x3F);
        }
        return this._bytes.completeAndCoalesce(n4);
    }

    private int _appendNumeric(int n2, char[] cArray) {
        cArray[1] = 117;
        cArray[4] = HC[n2 >> 4];
        cArray[5] = HC[n2 & 0xF];
        return 6;
    }

    private int _appendNamed(int n2, char[] cArray) {
        cArray[1] = (char)n2;
        return 2;
    }

    private int _appendByte(int n2, int n3, ByteArrayBuilder byteArrayBuilder, int n4) {
        byteArrayBuilder.setCurrentSegmentLength(n4);
        byteArrayBuilder.append(92);
        if (n3 < 0) {
            byteArrayBuilder.append(117);
            if (n2 > 255) {
                n3 = n2 >> 8;
                byteArrayBuilder.append(HB[n3 >> 4]);
                byteArrayBuilder.append(HB[n3 & 0xF]);
                n2 &= 0xFF;
            } else {
                byteArrayBuilder.append(48);
                byteArrayBuilder.append(48);
            }
            byteArrayBuilder.append(HB[n2 >> 4]);
            byteArrayBuilder.append(HB[n2 & 0xF]);
        } else {
            byteArrayBuilder.append((byte)n3);
        }
        return byteArrayBuilder.getCurrentSegmentLength();
    }

    private static int _convert(int n2, int n3) {
        if (n3 < 56320 || n3 > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(n2) + ", second 0x" + Integer.toHexString(n3) + "; illegal combination");
        }
        return 65536 + (n2 - 55296 << 10) + (n3 - 56320);
    }

    private static void _illegal(int n2) {
        throw new IllegalArgumentException(UTF8Writer.illegalSurrogateDesc(n2));
    }
}

