/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium.utils;

import co.libly.resourceloader.SharedLibraryLoader;
import com.goterl.lazycode.lazysodium.utils.LibraryLoadingException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.util.ArrayList;
import java.util.List;

public final class LibraryLoader {
    private List<Class> classes = new ArrayList<Class>();

    public LibraryLoader(List<Class> classesToRegister) {
        this.classes.addAll(classesToRegister);
    }

    public void loadLibrary(Mode mode, String systemFallBack) {
        switch (mode) {
            case PREFER_SYSTEM: {
                try {
                    this.loadSystemLibrary(systemFallBack);
                }
                catch (LibraryLoadingException suppressed) {
                    this.loadBundledLibrary();
                }
                break;
            }
            case BUNDLED_ONLY: {
                this.loadBundledLibrary();
                break;
            }
            case SYSTEM_ONLY: {
                this.loadSystemLibrary(systemFallBack);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported mode: " + (Object)((Object)mode));
            }
        }
    }

    public void loadSystemLibrary(String library) {
        SharedLibraryLoader.get().loadSystemLibrary(library, this.classes);
    }

    public void loadAbsolutePath(String absPath) {
        SharedLibraryLoader.get().loadSystemLibrary(absPath, this.classes);
    }

    private void loadBundledLibrary() {
        String pathInJar = LibraryLoader.getSodiumPathInResources();
        SharedLibraryLoader.get().load(pathInJar, this.classes);
    }

    private static String getSodiumPathInResources() {
        boolean is64Bit;
        boolean bl = is64Bit = Native.POINTER_SIZE == 8;
        if (Platform.isWindows()) {
            if (is64Bit) {
                return LibraryLoader.getPath("windows64", "libsodium.dll");
            }
            return LibraryLoader.getPath("windows", "libsodium.dll");
        }
        if (Platform.isARM()) {
            return LibraryLoader.getPath("armv6", "libsodium.so");
        }
        if (Platform.isLinux()) {
            if (is64Bit) {
                return LibraryLoader.getPath("linux64", "libsodium.so");
            }
            return LibraryLoader.getPath("linux", "libsodium.so");
        }
        if (Platform.isMac()) {
            return LibraryLoader.getPath("mac", "libsodium.dylib");
        }
        String message = String.format("Unsupported platform: %s/%s", System.getProperty("os.name"), System.getProperty("os.arch"));
        throw new LibraryLoadingException(message);
    }

    private static String getPath(String folder, String name) {
        String separator = "/";
        return folder + separator + name;
    }

    public static enum Mode {
        PREFER_SYSTEM,
        BUNDLED_ONLY,
        SYSTEM_ONLY;

    }
}

