/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium;

import com.goterl.lazycode.lazysodium.Sodium;
import com.goterl.lazycode.lazysodium.exceptions.SodiumException;
import com.goterl.lazycode.lazysodium.interfaces.AEAD;
import com.goterl.lazycode.lazysodium.interfaces.Auth;
import com.goterl.lazycode.lazysodium.interfaces.Base;
import com.goterl.lazycode.lazysodium.interfaces.Box;
import com.goterl.lazycode.lazysodium.interfaces.DiffieHellman;
import com.goterl.lazycode.lazysodium.interfaces.GenericHash;
import com.goterl.lazycode.lazysodium.interfaces.Hash;
import com.goterl.lazycode.lazysodium.interfaces.Helpers;
import com.goterl.lazycode.lazysodium.interfaces.KeyDerivation;
import com.goterl.lazycode.lazysodium.interfaces.KeyExchange;
import com.goterl.lazycode.lazysodium.interfaces.Padding;
import com.goterl.lazycode.lazysodium.interfaces.PwHash;
import com.goterl.lazycode.lazysodium.interfaces.Random;
import com.goterl.lazycode.lazysodium.interfaces.SecretBox;
import com.goterl.lazycode.lazysodium.interfaces.SecretStream;
import com.goterl.lazycode.lazysodium.interfaces.SecureMemory;
import com.goterl.lazycode.lazysodium.interfaces.ShortHash;
import com.goterl.lazycode.lazysodium.interfaces.Sign;
import com.goterl.lazycode.lazysodium.interfaces.Stream;
import com.goterl.lazycode.lazysodium.utils.DetachedDecrypt;
import com.goterl.lazycode.lazysodium.utils.DetachedEncrypt;
import com.goterl.lazycode.lazysodium.utils.Key;
import com.goterl.lazycode.lazysodium.utils.KeyPair;
import com.goterl.lazycode.lazysodium.utils.SessionPair;
import com.sun.jna.Pointer;
import java.nio.charset.Charset;

public abstract class LazySodium
implements Base,
Random,
AEAD.Native,
AEAD.Lazy,
GenericHash.Native,
GenericHash.Lazy,
ShortHash.Native,
ShortHash.Lazy,
SecureMemory.Native,
SecureMemory.Lazy,
Auth.Native,
Auth.Lazy,
SecretStream.Native,
SecretStream.Lazy,
Stream.Native,
Stream.Lazy,
Padding.Native,
Padding.Lazy,
Helpers.Native,
Helpers.Lazy,
PwHash.Native,
PwHash.Lazy,
Hash.Native,
Hash.Lazy,
Sign.Native,
Sign.Lazy,
Box.Native,
Box.Lazy,
SecretBox.Native,
SecretBox.Lazy,
KeyExchange.Native,
KeyExchange.Lazy,
KeyDerivation.Native,
KeyDerivation.Lazy,
DiffieHellman.Native,
DiffieHellman.Lazy {
    protected Charset charset = Charset.forName("UTF-8");
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public LazySodium() {
    }

    public LazySodium(Charset charset) {
        this.charset = charset;
    }

    public static Integer longToInt(long lng) {
        if (lng > Integer.MAX_VALUE) {
            return 0x7FFFFF37;
        }
        if (lng < 0L) {
            return 0;
        }
        return (int)lng;
    }

    @Override
    public int sodiumInit() {
        return this.getSodium().sodium_init();
    }

    @Override
    public String sodiumBin2Hex(byte[] bin) {
        return LazySodium.bytesToHex(bin);
    }

    @Override
    public byte[] sodiumHex2Bin(String hex) {
        return LazySodium.hexToBytes(hex);
    }

    public String toHexStr(byte[] bs) {
        return LazySodium.bytesToHex(bs);
    }

    public byte[] toBinary(String hex) {
        return LazySodium.hexToBytes(hex);
    }

    public static String toHex(byte[] bin) {
        return LazySodium.bytesToHex(bin);
    }

    public static byte[] toBin(String hex) {
        return LazySodium.hexToBytes(hex);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static byte[] hexToBytes(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    @Override
    public byte randomBytesRandom() {
        return this.getSodium().randombytes_random();
    }

    @Override
    public byte[] randomBytesBuf(int size) {
        byte[] bs = new byte[size];
        this.getSodium().randombytes_buf(bs, size);
        return bs;
    }

    @Override
    public byte[] nonce(int size) {
        return this.randomBytesBuf(size);
    }

    @Override
    public byte randomBytesUniform(int upperBound) {
        return this.getSodium().randombytes_uniform(upperBound);
    }

    @Override
    public byte[] randomBytesDeterministic(int size, byte[] seed) {
        byte[] bs = new byte[size];
        this.getSodium().randombytes_buf_deterministic(bs, size, seed);
        return bs;
    }

    @Override
    public boolean sodiumPad(int paddedBuffLen, char[] buf, int unpaddedBufLen, int blockSize, int maxBufLen) {
        return this.successful(this.getSodium().sodium_pad(paddedBuffLen, buf, unpaddedBufLen, blockSize, maxBufLen));
    }

    @Override
    public boolean sodiumUnpad(int unPaddedBuffLen, char[] buf, int paddedBufLen, int blockSize) {
        return this.successful(this.getSodium().sodium_unpad(unPaddedBuffLen, buf, paddedBufLen, blockSize));
    }

    @Override
    public boolean sodiumMemZero(byte[] pnt, int len) {
        return this.successful(this.getSodium().sodium_memzero(pnt, len));
    }

    @Override
    public boolean sodiumMLock(byte[] array, int len) {
        return this.successful(this.getSodium().sodium_mlock(array, len));
    }

    @Override
    public boolean sodiumMUnlock(byte[] array, int len) {
        return this.successful(this.getSodium().sodium_munlock(array, len));
    }

    @Override
    public Pointer sodiumMalloc(int size) {
        return this.getSodium().sodium_malloc(size);
    }

    @Override
    public Pointer sodiumAllocArray(int count, int size) {
        return this.getSodium().sodium_allocarray(count, size);
    }

    @Override
    public void sodiumFree(Pointer p) {
        this.getSodium().sodium_free(p);
    }

    @Override
    public boolean sodiumMProtectNoAccess(Pointer ptr) {
        return this.successful(this.getSodium().sodium_mprotect_noaccess(ptr));
    }

    @Override
    public boolean sodiumMProtectReadOnly(Pointer ptr) {
        return this.successful(this.getSodium().sodium_mprotect_readonly(ptr));
    }

    @Override
    public boolean sodiumMProtectReadWrite(Pointer ptr) {
        return this.successful(this.getSodium().sodium_mprotect_readwrite(ptr));
    }

    @Override
    public void cryptoKdfKeygen(byte[] masterKey) {
        this.getSodium().crypto_kdf_keygen(masterKey);
    }

    @Override
    public int cryptoKdfDeriveFromKey(byte[] subKey, int subKeyLen, long subKeyId, byte[] context, byte[] masterKey) {
        return this.getSodium().crypto_kdf_derive_from_key(subKey, subKeyLen, subKeyId, context, masterKey);
    }

    @Override
    public Key cryptoKdfKeygen() {
        byte[] masterKey = new byte[32];
        this.getSodium().crypto_kdf_keygen(masterKey);
        return Key.fromBytes(masterKey);
    }

    @Override
    public Key cryptoKdfDeriveFromKey(int lengthOfSubKey, long subKeyId, String context, Key masterKey) throws SodiumException {
        if (!KeyDerivation.Checker.subKeyIsCorrect(lengthOfSubKey)) {
            throw new SodiumException("Subkey is not between the correct lengths.");
        }
        if (!KeyDerivation.Checker.masterKeyIsCorrect(masterKey.getAsBytes().length)) {
            throw new SodiumException("Master key is not the correct length.");
        }
        if (!KeyDerivation.Checker.contextIsCorrect(this.bytes(context).length)) {
            throw new SodiumException("Context is not the correct length.");
        }
        byte[] subKey = new byte[lengthOfSubKey];
        byte[] contextAsBytes = this.bytes(context);
        byte[] masterKeyAsBytes = masterKey.getAsBytes();
        int res = this.getSodium().crypto_kdf_derive_from_key(subKey, lengthOfSubKey, subKeyId, contextAsBytes, masterKeyAsBytes);
        if (!this.successful(res)) {
            throw new SodiumException("Failed kdfDeriveFromKey.");
        }
        return Key.fromBytes(subKey);
    }

    @Override
    public boolean cryptoKxKeypair(byte[] publicKey, byte[] secretKey) {
        return this.successful(this.getSodium().crypto_kx_keypair(publicKey, secretKey));
    }

    @Override
    public boolean cryptoKxSeedKeypair(byte[] publicKey, byte[] secretKey, byte[] seed) {
        return this.successful(this.getSodium().crypto_kx_seed_keypair(publicKey, secretKey, seed));
    }

    @Override
    public boolean cryptoKxClientSessionKeys(byte[] rx, byte[] tx, byte[] clientPk, byte[] clientSk, byte[] serverPk) {
        return this.successful(this.getSodium().crypto_kx_client_session_keys(rx, tx, clientPk, clientSk, serverPk));
    }

    @Override
    public boolean cryptoKxServerSessionKeys(byte[] rx, byte[] tx, byte[] serverPk, byte[] serverSk, byte[] clientPk) {
        return this.successful(this.getSodium().crypto_kx_server_session_keys(rx, tx, serverPk, serverSk, clientPk));
    }

    @Override
    public KeyPair cryptoKxKeypair() {
        byte[] secretKey = this.randomBytesBuf(32);
        byte[] publicKey = this.randomBytesBuf(32);
        this.getSodium().crypto_kx_keypair(publicKey, secretKey);
        return new KeyPair(Key.fromBytes(publicKey), Key.fromBytes(secretKey));
    }

    @Override
    public KeyPair cryptoKxKeypair(byte[] seed) {
        byte[] secretKey = this.randomBytesBuf(32);
        byte[] publicKey = this.randomBytesBuf(32);
        this.getSodium().crypto_kx_seed_keypair(publicKey, secretKey, seed);
        return new KeyPair(Key.fromBytes(publicKey), Key.fromBytes(secretKey));
    }

    @Override
    public SessionPair cryptoKxClientSessionKeys(KeyPair clientKeyPair, KeyPair serverKeyPair) throws SodiumException {
        return this.cryptoKxClientSessionKeys(clientKeyPair.getPublicKey(), clientKeyPair.getSecretKey(), serverKeyPair.getPublicKey());
    }

    @Override
    public SessionPair cryptoKxServerSessionKeys(Key serverPk, Key serverSk, Key clientPk) throws SodiumException {
        byte[] rx = new byte[32];
        byte[] tx = new byte[32];
        if (!this.cryptoKxServerSessionKeys(rx, tx, serverPk.getAsBytes(), serverSk.getAsBytes(), clientPk.getAsBytes())) {
            throw new SodiumException("Failed creating server session keys.");
        }
        return new SessionPair(rx, tx);
    }

    @Override
    public SessionPair cryptoKxClientSessionKeys(Key clientPk, Key clientSk, Key serverPk) throws SodiumException {
        byte[] rx = new byte[32];
        byte[] tx = new byte[32];
        if (!this.cryptoKxClientSessionKeys(rx, tx, clientPk.getAsBytes(), clientSk.getAsBytes(), serverPk.getAsBytes())) {
            throw new SodiumException("Failed creating client session keys.");
        }
        return new SessionPair(rx, tx);
    }

    @Override
    public SessionPair cryptoKxServerSessionKeys(KeyPair serverKeyPair, KeyPair clientKeyPair) throws SodiumException {
        return this.cryptoKxServerSessionKeys(serverKeyPair.getPublicKey(), serverKeyPair.getSecretKey(), clientKeyPair.getPublicKey());
    }

    @Override
    public boolean cryptoPwHash(byte[] outputHash, int outputHashLen, byte[] password, int passwordLen, byte[] salt, long opsLimit, int memLimit, PwHash.Alg alg) {
        int res = this.getSodium().crypto_pwhash(outputHash, outputHashLen, password, passwordLen, salt, opsLimit, memLimit, alg.getValue());
        return this.successful(res);
    }

    @Override
    public boolean cryptoPwHashStr(byte[] outputStr, byte[] password, int passwordLen, long opsLimit, int memLimit) {
        int res = this.getSodium().crypto_pwhash_str(outputStr, password, passwordLen, opsLimit, memLimit);
        return this.successful(res);
    }

    @Override
    public boolean cryptoPwHashStrVerify(byte[] hash, byte[] password, int passwordLen) {
        return this.successful(this.getSodium().crypto_pwhash_str_verify(hash, password, passwordLen));
    }

    @Override
    public boolean cryptoPwHashStrNeedsRehash(byte[] hash, long opsLimit, int memLimit) {
        return this.successful(this.getSodium().crypto_pwhash_str_needs_rehash(hash, opsLimit, memLimit));
    }

    @Override
    public String cryptoPwHash(String password, int lengthOfHash, byte[] salt, long opsLimit, int memLimit, PwHash.Alg alg) throws SodiumException {
        byte[] passwordBytes = this.bytes(password);
        PwHash.Checker.checkAll(passwordBytes.length, salt.length, opsLimit, memLimit);
        byte[] hash = new byte[lengthOfHash];
        int res = this.getSodium().crypto_pwhash(hash, hash.length, passwordBytes, passwordBytes.length, salt, opsLimit, memLimit, alg.getValue());
        if (res != 0) {
            throw new SodiumException("Could not hash your string. This may be due to insufficient memory or your CPU does not support Argon2's instruction set.");
        }
        return LazySodium.toHex(hash);
    }

    @Override
    public String cryptoPwHashStr(String password, long opsLimit, int memLimit) throws SodiumException {
        byte[] hash = new byte[128];
        byte[] passwordBytes = this.bytes(password);
        boolean res = this.cryptoPwHashStr(hash, passwordBytes, passwordBytes.length, opsLimit, memLimit);
        if (!res) {
            throw new SodiumException("Password hashing failed.");
        }
        return LazySodium.toHex(hash);
    }

    @Override
    public String cryptoPwHashStrRemoveNulls(String password, long opsLimit, int memLimit) throws SodiumException {
        byte[] hash = new byte[128];
        byte[] passwordBytes = this.bytes(password);
        boolean res = this.cryptoPwHashStr(hash, passwordBytes, passwordBytes.length, opsLimit, memLimit);
        if (!res) {
            throw new SodiumException("Password hashing failed.");
        }
        byte[] hashNoNulls = this.removeNulls(hash);
        return LazySodium.toHex(hashNoNulls);
    }

    @Override
    public boolean cryptoPwHashStrVerify(String hash, String password) {
        byte[] hashBytes = LazySodium.toBin(hash);
        byte[] passwordBytes = this.bytes(password);
        byte endOfHash = hashBytes[hashBytes.length - 1];
        if (endOfHash != 0) {
            byte[] hashWithNullByte = new byte[hashBytes.length + 1];
            System.arraycopy(hashBytes, 0, hashWithNullByte, 0, hashBytes.length);
            hashBytes = hashWithNullByte;
        }
        return this.cryptoPwHashStrVerify(hashBytes, passwordBytes, passwordBytes.length);
    }

    @Override
    public boolean cryptoHashSha256(byte[] out, byte[] in, long inLen) {
        return this.successful(this.getSodium().crypto_hash_sha256(out, in, inLen));
    }

    @Override
    public boolean cryptoHashSha256Init(Hash.State256 state) {
        return this.successful(this.getSodium().crypto_hash_sha256_init(state));
    }

    @Override
    public boolean cryptoHashSha256Update(Hash.State256 state, byte[] in, long inLen) {
        return this.successful(this.getSodium().crypto_hash_sha256_update(state, in, inLen));
    }

    @Override
    public boolean cryptoHashSha256Final(Hash.State256 state, byte[] out) {
        return this.successful(this.getSodium().crypto_hash_sha256_final(state, out));
    }

    @Override
    public boolean cryptoHashSha512(byte[] out, byte[] in, long inLen) {
        return this.successful(this.getSodium().crypto_hash_sha512(out, in, inLen));
    }

    @Override
    public boolean cryptoHashSha512Init(Hash.State512 state) {
        return this.successful(this.getSodium().crypto_hash_sha512_init(state));
    }

    @Override
    public boolean cryptoHashSha512Update(Hash.State512 state, byte[] in, long inLen) {
        return this.successful(this.getSodium().crypto_hash_sha512_update(state, in, inLen));
    }

    @Override
    public boolean cryptoHashSha512Final(Hash.State512 state, byte[] out) {
        return this.successful(this.getSodium().crypto_hash_sha512_final(state, out));
    }

    @Override
    public String cryptoHashSha256(String message) throws SodiumException {
        byte[] hashedBytes = new byte[32];
        byte[] msgBytes = this.bytes(message);
        if (!this.cryptoHashSha256(hashedBytes, msgBytes, msgBytes.length)) {
            throw new SodiumException("Unsuccessful sha-256 hash.");
        }
        return LazySodium.toHex(hashedBytes);
    }

    @Override
    public String cryptoHashSha512(String message) throws SodiumException {
        byte[] hashedBytes = new byte[64];
        byte[] msgBytes = this.bytes(message);
        if (!this.cryptoHashSha512(hashedBytes, msgBytes, msgBytes.length)) {
            throw new SodiumException("Unsuccessful sha-512 hash.");
        }
        return LazySodium.toHex(hashedBytes);
    }

    @Override
    public boolean cryptoHashSha256Update(Hash.State256 state, String messagePart) {
        byte[] msgBytes = this.bytes(messagePart);
        return this.cryptoHashSha256Update(state, msgBytes, msgBytes.length);
    }

    @Override
    public String cryptoHashSha256Final(Hash.State256 state) throws SodiumException {
        byte[] finalHash = new byte[32];
        if (!this.cryptoHashSha256Final(state, finalHash)) {
            throw new SodiumException("Could not finalise sha-256.");
        }
        return LazySodium.toHex(finalHash);
    }

    @Override
    public boolean cryptoHashSha512Update(Hash.State512 state, String messagePart) {
        byte[] msgBytes = this.bytes(messagePart);
        return this.cryptoHashSha512Update(state, msgBytes, msgBytes.length);
    }

    @Override
    public String cryptoHashSha512Final(Hash.State512 state) throws SodiumException {
        byte[] finalHash = new byte[64];
        if (!this.cryptoHashSha512Final(state, finalHash)) {
            throw new SodiumException("Could not finalise sha-512.");
        }
        return LazySodium.toHex(finalHash);
    }

    @Override
    public void cryptoSecretBoxKeygen(byte[] key) {
        this.getSodium().crypto_secretbox_keygen(key);
    }

    @Override
    public boolean cryptoSecretBoxEasy(byte[] cipherText, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_secretbox_easy(cipherText, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoSecretBoxOpenEasy(byte[] message, byte[] cipherText, long cipherTextLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_secretbox_open_easy(message, cipherText, cipherTextLen, nonce, key));
    }

    @Override
    public boolean cryptoSecretBoxDetached(byte[] cipherText, byte[] mac, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_secretbox_detached(cipherText, mac, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoSecretBoxOpenDetached(byte[] message, byte[] cipherText, byte[] mac, long cipherTextLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_secretbox_open_detached(message, cipherText, mac, cipherTextLen, nonce, key));
    }

    @Override
    public Key cryptoSecretBoxKeygen() {
        byte[] key = new byte[32];
        this.cryptoSecretBoxKeygen(key);
        return Key.fromBytes(key);
    }

    @Override
    public String cryptoSecretBoxEasy(String message, byte[] nonce, Key key) throws SodiumException {
        byte[] keyBytes = key.getAsBytes();
        byte[] messageBytes = this.bytes(message);
        byte[] cipherTextBytes = new byte[16 + messageBytes.length];
        if (!this.cryptoSecretBoxEasy(cipherTextBytes, messageBytes, messageBytes.length, nonce, keyBytes)) {
            throw new SodiumException("Could not encrypt message.");
        }
        return LazySodium.toHex(cipherTextBytes);
    }

    @Override
    public String cryptoSecretBoxOpenEasy(String cipher, byte[] nonce, Key key) throws SodiumException {
        byte[] keyBytes = key.getAsBytes();
        byte[] cipherBytes = LazySodium.toBin(cipher);
        byte[] messageBytes = new byte[cipherBytes.length - 16];
        if (!this.cryptoSecretBoxOpenEasy(messageBytes, cipherBytes, cipherBytes.length, nonce, keyBytes)) {
            throw new SodiumException("Could not decrypt message.");
        }
        return this.str(messageBytes);
    }

    @Override
    public DetachedEncrypt cryptoSecretBoxDetached(String message, byte[] nonce, Key key) throws SodiumException {
        byte[] macBytes;
        byte[] keyBytes = key.getAsBytes();
        byte[] messageBytes = this.bytes(message);
        byte[] cipherTextBytes = new byte[messageBytes.length];
        if (!this.cryptoSecretBoxDetached(cipherTextBytes, macBytes = new byte[16], messageBytes, messageBytes.length, nonce, keyBytes)) {
            throw new SodiumException("Could not encrypt detached message.");
        }
        return new DetachedEncrypt(cipherTextBytes, macBytes);
    }

    @Override
    public String cryptoSecretBoxOpenDetached(DetachedEncrypt cipherAndMac, byte[] nonce, Key key) throws SodiumException {
        byte[] macBytes;
        byte[] keyBytes = key.getAsBytes();
        byte[] cipherBytes = cipherAndMac.getCipher();
        byte[] messageBytes = new byte[cipherBytes.length];
        if (!this.cryptoSecretBoxOpenDetached(messageBytes, cipherBytes, macBytes = cipherAndMac.getMac(), cipherBytes.length, nonce, keyBytes)) {
            throw new SodiumException("Could not decrypt detached message.");
        }
        return this.str(messageBytes);
    }

    @Override
    public boolean cryptoScalarMultBase(byte[] publicKey, byte[] secretKey) {
        return this.successful(this.getSodium().crypto_scalarmult_base(publicKey, secretKey));
    }

    @Override
    public Key cryptoScalarMultBase(Key secretKey) {
        byte[] publicKey = new byte[32];
        this.cryptoScalarMultBase(publicKey, secretKey.getAsBytes());
        return Key.fromBytes(publicKey);
    }

    @Override
    public boolean cryptoScalarMult(byte[] shared, byte[] secretKey, byte[] publicKey) {
        return this.successful(this.getSodium().crypto_scalarmult(shared, secretKey, publicKey));
    }

    @Override
    public Key cryptoScalarMult(Key secretKey, Key publicKey) {
        byte[] sharedKey = new byte[32];
        this.cryptoScalarMult(sharedKey, secretKey.getAsBytes(), publicKey.getAsBytes());
        return Key.fromBytes(sharedKey);
    }

    @Override
    public boolean cryptoBoxKeypair(byte[] publicKey, byte[] secretKey) {
        return this.successful(this.getSodium().crypto_box_keypair(publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxSeedKeypair(byte[] publicKey, byte[] secretKey, byte[] seed) {
        return this.successful(this.getSodium().crypto_box_seed_keypair(publicKey, secretKey, seed));
    }

    @Override
    public boolean cryptoBoxEasy(byte[] cipherText, byte[] message, long messageLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        return this.successful(this.getSodium().crypto_box_easy(cipherText, message, messageLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxOpenEasy(byte[] message, byte[] cipherText, long cipherTextLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        return this.successful(this.getSodium().crypto_box_open_easy(message, cipherText, cipherTextLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxDetached(byte[] cipherText, byte[] mac, byte[] message, long messageLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        return this.successful(this.getSodium().crypto_box_detached(cipherText, mac, message, messageLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxOpenDetached(byte[] message, byte[] cipherText, byte[] mac, byte[] cipherTextLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        return this.successful(this.getSodium().crypto_box_open_detached(message, cipherText, mac, cipherTextLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxBeforeNm(byte[] k, byte[] publicKey, byte[] secretKey) {
        return this.successful(this.getSodium().crypto_box_beforenm(k, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxEasyAfterNm(byte[] cipherText, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_box_easy_afternm(cipherText, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxOpenEasyAfterNm(byte[] message, byte[] cipher, long cLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_box_open_easy_afternm(message, cipher, cLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxDetachedAfterNm(byte[] cipherText, byte[] mac, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_box_detached_afternm(cipherText, mac, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxOpenDetachedAfterNm(byte[] message, byte[] cipherText, byte[] mac, long cipherTextLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_box_open_detached_afternm(message, cipherText, mac, cipherTextLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxSeal(byte[] cipher, byte[] message, long messageLen, byte[] publicKey) {
        return this.successful(this.getSodium().crypto_box_seal(cipher, message, messageLen, publicKey));
    }

    @Override
    public boolean cryptoBoxSealOpen(byte[] m, byte[] cipher, long cipherLen, byte[] publicKey, byte[] secretKey) {
        return this.successful(this.getSodium().crypto_box_seal_open(m, cipher, cipherLen, publicKey, secretKey));
    }

    @Override
    public KeyPair cryptoBoxKeypair() throws SodiumException {
        byte[] secretKey;
        byte[] publicKey = this.randomBytesBuf(32);
        if (!this.cryptoBoxKeypair(publicKey, secretKey = this.randomBytesBuf(32))) {
            throw new SodiumException("Unable to create a public and private key.");
        }
        return new KeyPair(Key.fromBytes(publicKey), Key.fromBytes(secretKey));
    }

    @Override
    public KeyPair cryptoBoxSeedKeypair(byte[] seed) throws SodiumException {
        byte[] publicKey = this.randomBytesBuf(32);
        byte[] secretKey = this.randomBytesBuf(32);
        if (!Box.Checker.checkSeed(seed.length)) {
            throw new SodiumException("Seed is incorrect size.");
        }
        if (!this.cryptoBoxSeedKeypair(publicKey, secretKey, seed)) {
            throw new SodiumException("Unable to create a public and private key.");
        }
        return new KeyPair(Key.fromBytes(publicKey), Key.fromBytes(secretKey));
    }

    @Override
    public String cryptoBoxEasy(String message, byte[] nonce, KeyPair keyPair) throws SodiumException {
        byte[] messageBytes = this.bytes(message);
        byte[] cipherBytes = new byte[16 + messageBytes.length];
        boolean res = this.cryptoBoxEasy(cipherBytes, messageBytes, messageBytes.length, nonce, keyPair.getPublicKey().getAsBytes(), keyPair.getSecretKey().getAsBytes());
        if (!res) {
            throw new SodiumException("Could not encrypt your message.");
        }
        return LazySodium.toHex(cipherBytes);
    }

    @Override
    public String cryptoBoxOpenEasy(String cipherText, byte[] nonce, KeyPair keyPair) throws SodiumException {
        byte[] cipher = LazySodium.toBin(cipherText);
        byte[] message = new byte[cipher.length - 16];
        boolean res = this.cryptoBoxOpenEasy(message, cipher, cipher.length, nonce, keyPair.getPublicKey().getAsBytes(), keyPair.getSecretKey().getAsBytes());
        if (!res) {
            throw new SodiumException("Could not decrypt your message.");
        }
        return this.str(message);
    }

    @Override
    public String cryptoBoxBeforeNm(byte[] publicKey, byte[] secretKey) throws SodiumException {
        byte[] sharedKey = new byte[32];
        if (!Box.Checker.checkPublicKey(publicKey.length)) {
            throw new SodiumException("Public key length is incorrect.");
        }
        if (!Box.Checker.checkSecretKey(secretKey.length)) {
            throw new SodiumException("Secret key length is incorrect.");
        }
        boolean res = this.cryptoBoxBeforeNm(sharedKey, publicKey, secretKey);
        if (!res) {
            throw new SodiumException("Unable to encrypt using shared secret key.");
        }
        return LazySodium.toHex(sharedKey);
    }

    @Override
    public String cryptoBoxBeforeNm(KeyPair keyPair) throws SodiumException {
        return this.cryptoBoxBeforeNm(keyPair.getPublicKey().getAsBytes(), keyPair.getSecretKey().getAsBytes());
    }

    @Override
    public String cryptoBoxEasyAfterNm(String message, byte[] nonce, String sharedSecretKey) throws SodiumException {
        if (!Box.Checker.checkNonce(nonce.length)) {
            throw new SodiumException("Incorrect nonce length.");
        }
        byte[] sharedKey = LazySodium.toBin(sharedSecretKey);
        if (!Box.Checker.checkBeforeNmBytes(sharedKey.length)) {
            throw new SodiumException("Incorrect shared secret key length.");
        }
        byte[] messageBytes = this.bytes(message);
        byte[] cipher = new byte[messageBytes.length + 16];
        boolean res = this.cryptoBoxEasyAfterNm(cipher, messageBytes, messageBytes.length, nonce, sharedKey);
        if (!res) {
            throw new SodiumException("Could not fully complete shared secret key encryption.");
        }
        return LazySodium.toHex(cipher);
    }

    @Override
    public String cryptoBoxOpenEasyAfterNm(String cipher, byte[] nonce, String sharedSecretKey) throws SodiumException {
        if (!Box.Checker.checkNonce(nonce.length)) {
            throw new SodiumException("Incorrect nonce length.");
        }
        byte[] sharedKey = LazySodium.toBin(sharedSecretKey);
        if (!Box.Checker.checkBeforeNmBytes(sharedKey.length)) {
            throw new SodiumException("Incorrect shared secret key length.");
        }
        byte[] cipherBytes = LazySodium.toBin(cipher);
        byte[] message = new byte[cipherBytes.length - 16];
        boolean res = this.cryptoBoxOpenEasyAfterNm(message, cipherBytes, cipherBytes.length, nonce, sharedKey);
        if (!res) {
            throw new SodiumException("Could not fully complete shared secret key decryption.");
        }
        return this.str(message);
    }

    @Override
    public DetachedEncrypt cryptoBoxDetachedAfterNm(String message, byte[] nonce, String sharedSecretKey) throws SodiumException {
        byte[] mac;
        if (!Box.Checker.checkNonce(nonce.length)) {
            throw new SodiumException("Incorrect nonce length.");
        }
        byte[] sharedKey = LazySodium.toBin(sharedSecretKey);
        if (!Box.Checker.checkBeforeNmBytes(sharedKey.length)) {
            throw new SodiumException("Incorrect shared secret key length.");
        }
        byte[] messageBytes = this.bytes(message);
        byte[] cipher = new byte[messageBytes.length];
        boolean res = this.cryptoBoxDetachedAfterNm(cipher, mac = new byte[16], messageBytes, messageBytes.length, nonce, sharedKey);
        if (!res) {
            throw new SodiumException("Could not fully complete shared secret key detached encryption.");
        }
        return new DetachedEncrypt(cipher, mac);
    }

    @Override
    public DetachedDecrypt cryptoBoxOpenDetachedAfterNm(DetachedEncrypt detachedEncrypt, byte[] nonce, String sharedSecretKey) throws SodiumException {
        byte[] mac;
        if (!Box.Checker.checkNonce(nonce.length)) {
            throw new SodiumException("Incorrect nonce length.");
        }
        byte[] sharedKey = LazySodium.toBin(sharedSecretKey);
        if (!Box.Checker.checkBeforeNmBytes(sharedKey.length)) {
            throw new SodiumException("Incorrect shared secret key length.");
        }
        byte[] cipherBytes = detachedEncrypt.getCipher();
        byte[] message = new byte[cipherBytes.length];
        boolean res = this.cryptoBoxOpenDetachedAfterNm(message, cipherBytes, mac = detachedEncrypt.getMac(), cipherBytes.length, nonce, sharedKey);
        if (!res) {
            throw new SodiumException("Could not fully complete shared secret key detached decryption.");
        }
        return new DetachedDecrypt(message, mac);
    }

    @Override
    public boolean cryptoSignKeypair(byte[] publicKey, byte[] secretKey) {
        return this.successful(this.getSodium().crypto_sign_keypair(publicKey, secretKey));
    }

    @Override
    public boolean cryptoSignSeedKeypair(byte[] publicKey, byte[] secretKey, byte[] seed) {
        return this.successful(this.getSodium().crypto_sign_seed_keypair(publicKey, secretKey, seed));
    }

    @Override
    public boolean cryptoSign(byte[] signedMessage, long[] signedMessageLen, byte[] message, long messageLen, byte[] secretKey) {
        return this.successful(this.getSodium().crypto_sign(signedMessage, signedMessageLen, message, messageLen, secretKey));
    }

    @Override
    public boolean cryptoSignOpen(byte[] message, long[] messageLen, byte[] signedMessage, long signedMessageLen, byte[] publicKey) {
        return this.successful(this.getSodium().crypto_sign_open(message, messageLen, signedMessage, signedMessageLen, publicKey));
    }

    @Override
    public boolean cryptoSignDetached(byte[] signature, long[] sigLength, byte[] message, long messageLen, byte[] secretKey) {
        return this.successful(this.getSodium().crypto_sign_detached(signature, sigLength, message, messageLen, secretKey));
    }

    @Override
    public boolean cryptoSignVerifyDetached(byte[] signature, byte[] message, long messageLen, byte[] publicKey) {
        return this.successful(this.getSodium().crypto_sign_verify_detached(signature, message, messageLen, publicKey));
    }

    @Override
    public boolean convertPublicKeyEd25519ToCurve25519(byte[] curve, byte[] ed) {
        return this.successful(this.getSodium().crypto_sign_ed25519_pk_to_curve25519(curve, ed));
    }

    @Override
    public boolean convertSecretKeyEd25519ToCurve25519(byte[] curve, byte[] ed) {
        return this.successful(this.getSodium().crypto_sign_ed25519_sk_to_curve25519(curve, ed));
    }

    @Override
    public boolean cryptoSignEd25519SkToSeed(byte[] seed, byte[] ed) {
        return this.successful(this.getSodium().crypto_sign_ed25519_sk_to_seed(seed, ed));
    }

    @Override
    public boolean cryptoSignEd25519SkToPk(byte[] publicKey, byte[] ed) {
        return this.successful(this.getSodium().crypto_sign_ed25519_sk_to_pk(publicKey, ed));
    }

    @Override
    public KeyPair cryptoSignKeypair() throws SodiumException {
        byte[] secretKey;
        byte[] publicKey = this.randomBytesBuf(32);
        if (!this.cryptoSignKeypair(publicKey, secretKey = this.randomBytesBuf(64))) {
            throw new SodiumException("Could not generate a signing keypair.");
        }
        return new KeyPair(Key.fromBytes(publicKey), Key.fromBytes(secretKey));
    }

    @Override
    public KeyPair cryptoSignSeedKeypair(byte[] seed) throws SodiumException {
        byte[] secretKey;
        byte[] publicKey = this.randomBytesBuf(32);
        if (!this.cryptoSignSeedKeypair(publicKey, secretKey = this.randomBytesBuf(64), seed)) {
            throw new SodiumException("Could not generate a signing keypair with a seed.");
        }
        return new KeyPair(Key.fromBytes(publicKey), Key.fromBytes(secretKey));
    }

    @Override
    public KeyPair cryptoSignSecretKeyPair(Key secretKey) throws SodiumException {
        byte[] publicKey = new byte[32];
        byte[] secKeyBytes = secretKey.getAsBytes();
        if (!this.cryptoSignEd25519SkToPk(publicKey, secKeyBytes)) {
            throw new SodiumException("Could not extract public key.");
        }
        return new KeyPair(Key.fromBytes(publicKey), Key.fromBytes(secKeyBytes));
    }

    @Override
    public String cryptoSign(String message, String secretKey) throws SodiumException {
        byte[] messageBytes = this.bytes(message);
        byte[] secretKeyBytes = LazySodium.toBin(secretKey);
        byte[] signedMessage = this.randomBytesBuf(64 + messageBytes.length);
        boolean res = this.cryptoSign(signedMessage, null, messageBytes, messageBytes.length, secretKeyBytes);
        if (!res) {
            throw new SodiumException("Could not sign your message.");
        }
        return LazySodium.toHex(signedMessage);
    }

    @Override
    public String cryptoSignOpen(String signedMessage, Key publicKey) {
        byte[] signedMessageBytes = LazySodium.toBin(signedMessage);
        byte[] publicKeyBytes = publicKey.getAsBytes();
        byte[] messageBytes = this.randomBytesBuf(signedMessageBytes.length - 64);
        boolean res = this.cryptoSignOpen(messageBytes, null, signedMessageBytes, signedMessageBytes.length, publicKeyBytes);
        if (!res) {
            return null;
        }
        return this.str(messageBytes);
    }

    @Override
    public String cryptoSignDetached(String message, Key secretKey) throws SodiumException {
        byte[] skBytes;
        byte[] signatureBytes = new byte[64];
        byte[] messageBytes = this.bytes(message);
        if (!this.cryptoSignDetached(signatureBytes, new long[1], messageBytes, messageBytes.length, skBytes = secretKey.getAsBytes())) {
            throw new SodiumException("Could not create a signature for your message in detached mode.");
        }
        return LazySodium.toHex(signatureBytes);
    }

    @Override
    public boolean cryptoSignVerifyDetached(String signature, String message, Key publicKey) {
        byte[] messageBytes = this.bytes(message);
        byte[] pkBytes = publicKey.getAsBytes();
        byte[] signatureBytes = LazySodium.toBin(signature);
        return this.cryptoSignVerifyDetached(signatureBytes, messageBytes, messageBytes.length, pkBytes);
    }

    @Override
    public KeyPair convertKeyPairEd25519ToCurve25519(KeyPair ed25519KeyPair) throws SodiumException {
        byte[] edPkBytes = ed25519KeyPair.getPublicKey().getAsBytes();
        byte[] edSkBytes = ed25519KeyPair.getSecretKey().getAsBytes();
        byte[] curvePkBytes = new byte[32];
        byte[] curveSkBytes = new byte[32];
        boolean pkSuccess = this.convertPublicKeyEd25519ToCurve25519(curvePkBytes, edPkBytes);
        boolean skSuccess = this.convertSecretKeyEd25519ToCurve25519(curveSkBytes, edSkBytes);
        if (!pkSuccess || !skSuccess) {
            throw new SodiumException("Could not convert this key pair.");
        }
        return new KeyPair(Key.fromBytes(curvePkBytes), Key.fromBytes(curveSkBytes));
    }

    @Override
    public void cryptoSecretStreamKeygen(byte[] key) {
        this.getSodium().crypto_secretstream_xchacha20poly1305_keygen(key);
    }

    @Override
    public boolean cryptoSecretStreamInitPush(SecretStream.State state, byte[] header, byte[] key) {
        return this.successful(this.getSodium().crypto_secretstream_xchacha20poly1305_init_push(state, header, key));
    }

    @Override
    public boolean cryptoSecretStreamPush(SecretStream.State state, byte[] cipher, long[] cipherAddr, byte[] message, long messageLen, byte tag) {
        return this.successful(this.getSodium().crypto_secretstream_xchacha20poly1305_push(state, cipher, cipherAddr, message, messageLen, new byte[0], 0L, tag));
    }

    @Override
    public boolean cryptoSecretStreamPush(SecretStream.State state, byte[] cipher, byte[] message, long messageLen, byte tag) {
        return this.successful(this.getSodium().crypto_secretstream_xchacha20poly1305_push(state, cipher, null, message, messageLen, new byte[0], 0L, tag));
    }

    @Override
    public boolean cryptoSecretStreamPush(SecretStream.State state, byte[] cipher, long[] cipherAddr, byte[] message, long messageLen, byte[] additionalData, long additionalDataLen, byte tag) {
        return this.successful(this.getSodium().crypto_secretstream_xchacha20poly1305_push(state, cipher, cipherAddr, message, messageLen, additionalData, additionalDataLen, tag));
    }

    @Override
    public boolean cryptoSecretStreamInitPull(SecretStream.State state, byte[] header, byte[] key) {
        return this.successful(this.getSodium().crypto_secretstream_xchacha20poly1305_init_pull(state, header, key));
    }

    @Override
    public boolean cryptoSecretStreamPull(SecretStream.State state, byte[] message, long[] messageAddress, byte[] tag, byte[] cipher, long cipherLen, byte[] additionalData, long additionalDataLen) {
        return this.successful(this.getSodium().crypto_secretstream_xchacha20poly1305_pull(state, message, messageAddress, tag, cipher, cipherLen, additionalData, additionalDataLen));
    }

    @Override
    public boolean cryptoSecretStreamPull(SecretStream.State state, byte[] message, byte[] tag, byte[] cipher, long cipherLen) {
        return this.successful(this.getSodium().crypto_secretstream_xchacha20poly1305_pull(state, message, new long[1], tag, cipher, cipherLen, new byte[0], 0L));
    }

    @Override
    public Key cryptoSecretStreamKeygen() {
        byte[] key = this.randomBytesBuf(32);
        this.getSodium().crypto_secretstream_xchacha20poly1305_keygen(key);
        return Key.fromBytes(key);
    }

    @Override
    public SecretStream.State cryptoSecretStreamInitPush(byte[] header, Key key) throws SodiumException {
        SecretStream.State.ByReference state = new SecretStream.State.ByReference();
        if (!SecretStream.Checker.headerCheck(header.length)) {
            throw new SodiumException("Header of secret stream incorrect length.");
        }
        this.getSodium().crypto_secretstream_xchacha20poly1305_init_push(state, header, key.getAsBytes());
        return state;
    }

    @Override
    public String cryptoSecretStreamPush(SecretStream.State state, String message, byte tag) throws SodiumException {
        byte[] messageBytes = this.bytes(message);
        byte[] cipher = new byte[17 + messageBytes.length];
        int res = this.getSodium().crypto_secretstream_xchacha20poly1305_push(state, cipher, null, messageBytes, messageBytes.length, new byte[0], 0L, tag);
        if (res != 0) {
            throw new SodiumException("Error when encrypting a message using secret stream.");
        }
        return LazySodium.toHex(cipher);
    }

    @Override
    public SecretStream.State cryptoSecretStreamInitPull(byte[] header, Key key) throws SodiumException {
        SecretStream.State.ByReference state = new SecretStream.State.ByReference();
        if (!SecretStream.Checker.headerCheck(header.length)) {
            throw new SodiumException("Header of secret stream incorrect length.");
        }
        int res = this.getSodium().crypto_secretstream_xchacha20poly1305_init_pull(state, header, key.getAsBytes());
        if (res != 0) {
            throw new SodiumException("Could not initialise a decryption state.");
        }
        return state;
    }

    @Override
    public String cryptoSecretStreamPull(SecretStream.State state, String cipher, byte[] tag) throws SodiumException {
        byte[] cipherBytes = LazySodium.toBin(cipher);
        byte[] message = new byte[cipherBytes.length - 17];
        int res = this.getSodium().crypto_secretstream_xchacha20poly1305_pull(state, message, null, tag, cipherBytes, cipherBytes.length, new byte[0], 0L);
        if (res != 0) {
            throw new SodiumException("Error when decrypting a message using secret stream.");
        }
        return this.str(message);
    }

    @Override
    public void cryptoSecretStreamRekey(SecretStream.State state) {
        this.getSodium().crypto_secretstream_xchacha20poly1305_rekey(state);
    }

    @Override
    public void cryptoStreamChaCha20Keygen(byte[] key) {
        this.getSodium().crypto_stream_chacha20_keygen(key);
    }

    @Override
    public boolean cryptoStreamChaCha20(byte[] c, long cLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_chacha20(c, cLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamChaCha20Xor(byte[] cipher, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_chacha20_xor(cipher, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamChacha20XorIc(byte[] cipher, byte[] message, long messageLen, byte[] nonce, long ic, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_chacha20_xor_ic(cipher, message, messageLen, nonce, ic, key));
    }

    @Override
    public void cryptoStreamChaCha20IetfKeygen(byte[] key) {
        this.getSodium().crypto_stream_chacha20_ietf_keygen(key);
    }

    @Override
    public boolean cryptoStreamChaCha20Ietf(byte[] c, long cLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_chacha20_ietf(c, cLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamChaCha20IetfXor(byte[] cipher, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_chacha20_ietf_xor(cipher, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamChacha20IetfXorIc(byte[] cipher, byte[] message, long messageLen, byte[] nonce, long ic, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_chacha20_ietf_xor_ic(cipher, message, messageLen, nonce, ic, key));
    }

    @Override
    public void cryptoStreamSalsa20Keygen(byte[] key) {
        this.getSodium().crypto_stream_salsa20_keygen(key);
    }

    @Override
    public boolean cryptoStreamSalsa20(byte[] c, long cLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_salsa20(c, cLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamSalsa20Xor(byte[] cipher, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_salsa20_xor(cipher, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamSalsa20XorIc(byte[] cipher, byte[] message, long messageLen, byte[] nonce, long ic, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_salsa20_xor_ic(cipher, message, messageLen, nonce, ic, key));
    }

    @Override
    public void cryptoStreamXSalsa20Keygen(byte[] key) {
        this.getSodium().crypto_stream_keygen(key);
    }

    @Override
    public boolean cryptoStreamXSalsa20(byte[] c, long cLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_stream(c, cLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamXSalsa20Xor(byte[] cipher, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_xor(cipher, message, messageLen, nonce, key));
    }

    @Override
    public Key cryptoStreamKeygen(Stream.Method method) {
        if (method.equals((Object)Stream.Method.CHACHA20)) {
            byte[] k = this.randomBytesBuf(32);
            this.cryptoStreamChaCha20Keygen(k);
            return Key.fromBytes(k);
        }
        if (method.equals((Object)Stream.Method.CHACHA20_IETF)) {
            byte[] k = this.randomBytesBuf(32);
            this.cryptoStreamChaCha20Keygen(k);
            return Key.fromBytes(k);
        }
        if (method.equals((Object)Stream.Method.SALSA20)) {
            byte[] k = this.randomBytesBuf(32);
            this.cryptoStreamSalsa20Keygen(k);
            return Key.fromBytes(k);
        }
        byte[] k = this.randomBytesBuf(32);
        this.cryptoStreamXSalsa20Keygen(k);
        return Key.fromBytes(k);
    }

    @Override
    public byte[] cryptoStream(byte[] nonce, Key key, Stream.Method method) {
        byte[] c = new byte[20];
        int cLen = c.length;
        if (method.equals((Object)Stream.Method.CHACHA20)) {
            this.cryptoStreamChaCha20(c, cLen, nonce, key.getAsBytes());
        } else if (method.equals((Object)Stream.Method.CHACHA20_IETF)) {
            this.cryptoStreamChaCha20Ietf(c, cLen, nonce, key.getAsBytes());
        } else if (method.equals((Object)Stream.Method.SALSA20)) {
            this.cryptoStreamSalsa20(c, cLen, nonce, key.getAsBytes());
        } else {
            this.cryptoStreamXSalsa20(c, cLen, nonce, key.getAsBytes());
        }
        return c;
    }

    @Override
    public String cryptoStreamXor(String message, byte[] nonce, Key key, Stream.Method method) {
        byte[] mBytes = this.bytes(message);
        return LazySodium.toHex(this.cryptoStreamDefaultXor(mBytes, nonce, key, method));
    }

    @Override
    public String cryptoStreamXorDecrypt(String cipher, byte[] nonce, Key key, Stream.Method method) {
        return this.str(this.cryptoStreamDefaultXor(LazySodium.toBin(cipher), nonce, key, method));
    }

    @Override
    public String cryptoStreamXorIc(String message, byte[] nonce, long ic, Key key, Stream.Method method) {
        byte[] mBytes = this.bytes(message);
        return LazySodium.toHex(this.cryptoStreamDefaultXorIc(mBytes, nonce, ic, key, method));
    }

    @Override
    public String cryptoStreamXorIcDecrypt(String cipher, byte[] nonce, long ic, Key key, Stream.Method method) {
        byte[] cipherBytes = LazySodium.toBin(cipher);
        return this.str(this.cryptoStreamDefaultXorIc(cipherBytes, nonce, ic, key, method));
    }

    private byte[] cryptoStreamDefaultXor(byte[] messageBytes, byte[] nonce, Key key, Stream.Method method) {
        int mLen = messageBytes.length;
        byte[] cipher = new byte[mLen];
        if (method.equals((Object)Stream.Method.CHACHA20)) {
            this.cryptoStreamChaCha20Xor(cipher, messageBytes, mLen, nonce, key.getAsBytes());
        } else if (method.equals((Object)Stream.Method.CHACHA20_IETF)) {
            this.cryptoStreamChaCha20IetfXor(cipher, messageBytes, mLen, nonce, key.getAsBytes());
        } else if (method.equals((Object)Stream.Method.SALSA20)) {
            this.cryptoStreamSalsa20Xor(cipher, messageBytes, mLen, nonce, key.getAsBytes());
        } else {
            this.cryptoStreamXSalsa20Xor(cipher, messageBytes, mLen, nonce, key.getAsBytes());
        }
        return cipher;
    }

    protected byte[] cryptoStreamDefaultXorIc(byte[] messageBytes, byte[] nonce, long ic, Key key, Stream.Method method) {
        int mLen = messageBytes.length;
        byte[] cipher = new byte[mLen];
        if (method.equals((Object)Stream.Method.CHACHA20)) {
            this.cryptoStreamChacha20XorIc(cipher, messageBytes, mLen, nonce, ic, key.getAsBytes());
        } else if (method.equals((Object)Stream.Method.CHACHA20_IETF)) {
            this.cryptoStreamChacha20IetfXorIc(cipher, messageBytes, mLen, nonce, ic, key.getAsBytes());
        } else if (method.equals((Object)Stream.Method.SALSA20)) {
            this.cryptoStreamSalsa20XorIc(cipher, messageBytes, mLen, nonce, ic, key.getAsBytes());
        } else {
            this.cryptoStreamXSalsa20Xor(cipher, messageBytes, mLen, nonce, key.getAsBytes());
        }
        return cipher;
    }

    @Override
    public boolean cryptoAuth(byte[] tag, byte[] in, long inLen, byte[] key) {
        return this.successful(this.getSodium().crypto_auth(tag, in, inLen, key));
    }

    @Override
    public boolean cryptoAuthVerify(byte[] tag, byte[] in, long inLen, byte[] key) {
        return this.successful(this.getSodium().crypto_auth_verify(tag, in, inLen, key));
    }

    @Override
    public void cryptoAuthKeygen(byte[] k) {
        this.getSodium().crypto_auth_keygen(k);
    }

    @Override
    public Key cryptoAuthKeygen() {
        byte[] key = this.randomBytesBuf(32);
        this.cryptoAuthKeygen(key);
        return Key.fromBytes(key);
    }

    @Override
    public String cryptoAuth(String message, Key key) throws SodiumException {
        byte[] keyBytes;
        byte[] messageBytes;
        byte[] tag = this.randomBytesBuf(32);
        boolean res = this.cryptoAuth(tag, messageBytes = this.bytes(message), messageBytes.length, keyBytes = key.getAsBytes());
        if (!res) {
            throw new SodiumException("Could not apply auth tag to your message.");
        }
        return LazySodium.toHex(tag);
    }

    @Override
    public boolean cryptoAuthVerify(String tag, String message, Key key) {
        byte[] tagToBytes = LazySodium.toBin(tag);
        byte[] messageBytes = this.bytes(message);
        byte[] keyBytes = key.getAsBytes();
        return this.cryptoAuthVerify(tagToBytes, messageBytes, messageBytes.length, keyBytes);
    }

    @Override
    public void cryptoAuthHMACSha256Keygen(byte[] key) {
        this.getSodium().crypto_auth_hmacsha256_keygen(key);
    }

    @Override
    public boolean cryptoAuthHMACSha256(byte[] out, byte[] in, int inLen, byte[] k) {
        return this.successful(this.getSodium().crypto_auth_hmacsha256(out, in, inLen, k));
    }

    @Override
    public boolean cryptoAuthHMACSha256Verify(byte[] h, byte[] in, int inLen, byte[] k) {
        return this.successful(this.getSodium().crypto_auth_hmacsha256_verify(h, in, inLen, k));
    }

    @Override
    public boolean cryptoAuthHMACSha256Init(Auth.StateHMAC256 state, byte[] key, int keyLen) {
        return this.successful(this.getSodium().crypto_auth_hmacsha256_init(state, key, keyLen));
    }

    @Override
    public boolean cryptoAuthHMACSha256Update(Auth.StateHMAC256 state, byte[] in, long inLen) {
        return this.successful(this.getSodium().crypto_auth_hmacsha256_update(state, in, inLen));
    }

    @Override
    public boolean cryptoAuthHMACSha256Final(Auth.StateHMAC256 state, byte[] out) {
        return this.successful(this.getSodium().crypto_auth_hmacsha256_final(state, out));
    }

    @Override
    public void cryptoAuthHMACSha512Keygen(byte[] key) {
        this.getSodium().crypto_auth_hmacsha512_keygen(key);
    }

    @Override
    public boolean cryptoAuthHMACSha512(byte[] out, byte[] in, int inLen, byte[] k) {
        return this.successful(this.getSodium().crypto_auth_hmacsha512(out, in, inLen, k));
    }

    @Override
    public boolean cryptoAuthHMACSha512Verify(byte[] h, byte[] in, int inLen, byte[] k) {
        return this.successful(this.getSodium().crypto_auth_hmacsha512_verify(h, in, inLen, k));
    }

    @Override
    public boolean cryptoAuthHMACSha512Init(Auth.StateHMAC512 state, byte[] key, int keyLen) {
        return this.successful(this.getSodium().crypto_auth_hmacsha512_init(state, key, keyLen));
    }

    @Override
    public boolean cryptoAuthHMACSha512Update(Auth.StateHMAC512 state, byte[] in, long inLen) {
        return this.successful(this.getSodium().crypto_auth_hmacsha512_update(state, in, inLen));
    }

    @Override
    public boolean cryptoAuthHMACSha512Final(Auth.StateHMAC512 state, byte[] out) {
        return this.successful(this.getSodium().crypto_auth_hmacsha512_final(state, out));
    }

    @Override
    public void cryptoAuthHMACSha512256Keygen(byte[] key) {
        this.getSodium().crypto_auth_hmacsha512256_keygen(key);
    }

    @Override
    public boolean cryptoAuthHMACSha512256(byte[] out, byte[] in, int inLen, byte[] k) {
        return this.successful(this.getSodium().crypto_auth_hmacsha512256(out, in, inLen, k));
    }

    @Override
    public boolean cryptoAuthHMACSha512256Verify(byte[] h, byte[] in, int inLen, byte[] k) {
        return this.successful(this.getSodium().crypto_auth_hmacsha512256_verify(h, in, inLen, k));
    }

    @Override
    public boolean cryptoAuthHMACSha512256Init(Auth.StateHMAC512256 state, byte[] key, int keyLen) {
        return this.successful(this.getSodium().crypto_auth_hmacsha512256_init(state, key, keyLen));
    }

    @Override
    public boolean cryptoAuthHMACSha512256Update(Auth.StateHMAC512256 state, byte[] in, long inLen) {
        return this.successful(this.getSodium().crypto_auth_hmacsha512256_update(state, in, inLen));
    }

    @Override
    public boolean cryptoAuthHMACSha512256Final(Auth.StateHMAC512256 state, byte[] out) {
        return this.successful(this.getSodium().crypto_auth_hmacsha512256_final(state, out));
    }

    @Override
    public Key cryptoAuthHMACShaKeygen(Auth.Type type) {
        if (type.equals((Object)Auth.Type.SHA256)) {
            byte[] k = new byte[32];
            this.cryptoAuthHMACSha256Keygen(k);
            return Key.fromBytes(k);
        }
        if (type.equals((Object)Auth.Type.SHA512)) {
            byte[] k = new byte[32];
            this.cryptoAuthHMACSha512Keygen(k);
            return Key.fromBytes(k);
        }
        byte[] k = new byte[32];
        this.cryptoAuthHMACSha512256Keygen(k);
        return Key.fromBytes(k);
    }

    @Override
    public String cryptoAuthHMACSha(Auth.Type type, String in, Key key) {
        byte[] inBytes = this.bytes(in);
        byte[] keyBytes = key.getAsBytes();
        if (type.equals((Object)Auth.Type.SHA256)) {
            byte[] out = new byte[32];
            this.cryptoAuthHMACSha256(out, inBytes, inBytes.length, keyBytes);
            return LazySodium.toHex(out);
        }
        if (type.equals((Object)Auth.Type.SHA512)) {
            byte[] out = new byte[64];
            this.cryptoAuthHMACSha512(out, inBytes, inBytes.length, keyBytes);
            return LazySodium.toHex(out);
        }
        byte[] out = new byte[32];
        this.cryptoAuthHMACSha512256(out, inBytes, inBytes.length, keyBytes);
        return LazySodium.toHex(out);
    }

    @Override
    public boolean cryptoAuthHMACShaVerify(Auth.Type type, String h, String in, Key key) {
        byte[] authBytes = LazySodium.toBin(h);
        byte[] inBytes = this.bytes(in);
        byte[] keyBytes = key.getAsBytes();
        if (type.equals((Object)Auth.Type.SHA256)) {
            return this.cryptoAuthHMACSha256Verify(authBytes, inBytes, inBytes.length, keyBytes);
        }
        if (type.equals((Object)Auth.Type.SHA512)) {
            return this.cryptoAuthHMACSha512Verify(authBytes, inBytes, inBytes.length, keyBytes);
        }
        return this.cryptoAuthHMACSha512256Verify(authBytes, inBytes, inBytes.length, keyBytes);
    }

    @Override
    public boolean cryptoAuthHMACShaInit(Auth.StateHMAC256 state, Key key) {
        byte[] keyBytes = key.getAsBytes();
        return this.cryptoAuthHMACSha256Init(state, keyBytes, keyBytes.length);
    }

    @Override
    public boolean cryptoAuthHMACShaUpdate(Auth.StateHMAC256 state, String in) {
        byte[] inBytes = this.bytes(in);
        return this.cryptoAuthHMACSha256Update(state, inBytes, inBytes.length);
    }

    @Override
    public String cryptoAuthHMACShaFinal(Auth.StateHMAC256 state) throws SodiumException {
        byte[] out = new byte[32];
        boolean res = this.cryptoAuthHMACSha256Final(state, out);
        if (!res) {
            throw new SodiumException("Could not finalise SHA Hash.");
        }
        return LazySodium.toHex(out);
    }

    @Override
    public boolean cryptoAuthHMACShaInit(Auth.StateHMAC512 state, Key key) {
        byte[] keyBytes = key.getAsBytes();
        return this.cryptoAuthHMACSha512Init(state, keyBytes, keyBytes.length);
    }

    @Override
    public boolean cryptoAuthHMACShaUpdate(Auth.StateHMAC512 state, String in) {
        byte[] inBytes = this.bytes(in);
        return this.cryptoAuthHMACSha512Update(state, inBytes, inBytes.length);
    }

    @Override
    public String cryptoAuthHMACShaFinal(Auth.StateHMAC512 state) throws SodiumException {
        byte[] out = new byte[64];
        boolean res = this.cryptoAuthHMACSha512Final(state, out);
        if (!res) {
            throw new SodiumException("Could not finalise HMAC Sha 512.");
        }
        return LazySodium.toHex(out);
    }

    @Override
    public boolean cryptoAuthHMACShaInit(Auth.StateHMAC512256 state, Key key) {
        byte[] keyBytes = key.getAsBytes();
        return this.cryptoAuthHMACSha512256Init(state, keyBytes, keyBytes.length);
    }

    @Override
    public boolean cryptoAuthHMACShaUpdate(Auth.StateHMAC512256 state, String in) {
        byte[] inBytes = this.bytes(in);
        return this.cryptoAuthHMACSha512256Update(state, inBytes, inBytes.length);
    }

    @Override
    public String cryptoAuthHMACShaFinal(Auth.StateHMAC512256 state) throws SodiumException {
        byte[] out = new byte[32];
        boolean res = this.cryptoAuthHMACSha512256Final(state, out);
        if (!res) {
            throw new SodiumException("Could not finalise HMAC Sha 512256.");
        }
        return LazySodium.toHex(out);
    }

    @Override
    public boolean cryptoShortHash(byte[] out, byte[] in, long inLen, byte[] key) {
        return this.successful(this.getSodium().crypto_shorthash(out, in, inLen, key));
    }

    @Override
    public void cryptoShortHashKeygen(byte[] k) {
        this.getSodium().crypto_shorthash_keygen(k);
    }

    @Override
    public String cryptoShortHash(String in, Key key) throws SodiumException {
        byte[] inBytes = LazySodium.hexToBytes(in);
        byte[] keyBytes = key.getAsBytes();
        byte[] out = this.randomBytesBuf(8);
        if (this.getSodium().crypto_shorthash(out, inBytes, inBytes.length, keyBytes) != 0) {
            throw new SodiumException("Failed short-input hashing.");
        }
        return this.sodiumBin2Hex(out);
    }

    @Override
    public Key cryptoShortHashKeygen() {
        byte[] key = this.randomBytesBuf(16);
        this.getSodium().crypto_shorthash_keygen(key);
        return Key.fromBytes(key);
    }

    @Override
    public boolean cryptoGenericHash(byte[] out, int outLen, byte[] in, long inLen, byte[] key, int keyLen) {
        return this.successful(this.getSodium().crypto_generichash(out, outLen, in, inLen, key, keyLen));
    }

    @Override
    public boolean cryptoGenericHash(byte[] out, int outLen, byte[] in, long inLen) {
        return this.successful(this.getSodium().crypto_generichash(out, outLen, in, inLen, null, 0));
    }

    @Override
    public boolean cryptoGenericHashInit(byte[] state, byte[] key, int keyLength, int outLen) {
        return this.successful(this.getSodium().crypto_generichash_init(state, key, keyLength, outLen));
    }

    @Override
    public boolean cryptoGenericHashInit(byte[] state, int outLen) {
        return this.successful(this.getSodium().crypto_generichash_init(state, null, 0, outLen));
    }

    @Override
    public boolean cryptoGenericHashUpdate(byte[] state, byte[] in, long inLen) {
        return this.successful(this.getSodium().crypto_generichash_update(state, in, inLen));
    }

    @Override
    public boolean cryptoGenericHashFinal(byte[] state, byte[] out, int outLen) {
        return this.successful(this.getSodium().crypto_generichash_final(state, out, outLen));
    }

    @Override
    public int cryptoGenericHashStateBytes() {
        return this.getSodium().crypto_generichash_statebytes();
    }

    @Override
    public void cryptoGenericHashKeygen(byte[] k) {
        this.getSodium().crypto_generichash_keygen(k);
    }

    @Override
    public Key cryptoGenericHashKeygen() {
        byte[] key = this.randomBytesBuf(32);
        this.cryptoGenericHashKeygen(key);
        return Key.fromBytes(key);
    }

    @Override
    public Key cryptoGenericHashKeygen(int size) throws SodiumException {
        byte[] key = this.randomBytesBuf(size);
        this.cryptoGenericHashKeygen(key);
        return Key.fromBytes(key);
    }

    @Override
    public String cryptoGenericHash(String in, Key key) throws SodiumException {
        byte[] message = this.bytes(in);
        byte[] keyBytes = key.getAsBytes();
        byte[] hash = this.randomBytesBuf(32);
        boolean res = this.cryptoGenericHash(hash, hash.length, message, message.length, keyBytes, keyBytes.length);
        if (!res) {
            throw new SodiumException("Could not hash the message.");
        }
        return LazySodium.toHex(hash);
    }

    @Override
    public String cryptoGenericHash(String in) throws SodiumException {
        byte[] message = this.bytes(in);
        byte[] hash = this.randomBytesBuf(32);
        boolean res = this.cryptoGenericHash(hash, hash.length, message, message.length, null, 0);
        if (!res) {
            throw new SodiumException("Could not hash the message.");
        }
        return LazySodium.toHex(hash);
    }

    @Override
    public boolean cryptoGenericHashInit(byte[] state, Key key, int outLen) {
        byte[] keyBytes = key.getAsBytes();
        return this.getSodium().crypto_generichash_init(state, keyBytes, keyBytes.length, outLen) == 0;
    }

    @Override
    public boolean cryptoGenericHashUpdate(byte[] state, String in) {
        byte[] inBytes = this.bytes(in);
        return this.getSodium().crypto_generichash_update(state, inBytes, inBytes.length) == 0;
    }

    @Override
    public String cryptoGenericHashFinal(byte[] state, int outLen) throws SodiumException {
        boolean res;
        byte[] hash = new byte[outLen];
        boolean bl = res = this.getSodium().crypto_generichash_final(state, hash, hash.length) == 0;
        if (!res) {
            throw new SodiumException("Could not finalise the hashing process.");
        }
        return LazySodium.toHex(hash);
    }

    @Override
    public void cryptoAeadChaCha20Poly1305Keygen(byte[] key) {
        this.getSodium().crypto_aead_chacha20poly1305_keygen(key);
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305Encrypt(byte[] c, long[] cLen, byte[] m, long mLen, byte[] ad, long adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_encrypt(c, cLen, m, mLen, ad, adLen, nSec, nPub, k));
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305Decrypt(byte[] m, long[] mLen, byte[] nSec, byte[] c, long cLen, byte[] ad, long adLen, byte[] nPub, byte[] k) {
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_decrypt(m, mLen, nSec, c, cLen, ad, adLen, nPub, k));
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305EncryptDetached(byte[] c, byte[] mac, long[] macLenAddress, byte[] m, long mLen, byte[] ad, long adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_encrypt_detached(c, mac, macLenAddress, m, mLen, ad, adLen, nSec, nPub, k));
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305DecryptDetached(byte[] m, byte[] nSec, byte[] c, long cLen, byte[] mac, byte[] ad, long adLen, byte[] nPub, byte[] k) {
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_decrypt_detached(m, nSec, c, cLen, mac, ad, adLen, nPub, k));
    }

    @Override
    public void cryptoAeadChaCha20Poly1305IetfKeygen(byte[] key) {
        this.getSodium().crypto_aead_chacha20poly1305_ietf_keygen(key);
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305IetfEncrypt(byte[] c, long[] cLen, byte[] m, long mLen, byte[] ad, long adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_ietf_encrypt(c, cLen, m, mLen, ad, adLen, nSec, nPub, k));
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305IetfDecrypt(byte[] m, long[] mLen, byte[] nSec, byte[] c, long cLen, byte[] ad, long adLen, byte[] nPub, byte[] k) {
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_ietf_decrypt(m, mLen, nSec, c, cLen, ad, adLen, nPub, k));
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305IetfEncryptDetached(byte[] c, byte[] mac, long[] macLenAddress, byte[] m, long mLen, byte[] ad, long adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_ietf_encrypt_detached(c, mac, macLenAddress, m, mLen, ad, adLen, nSec, nPub, k));
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305IetfDecryptDetached(byte[] m, byte[] nSec, byte[] c, long cLen, byte[] mac, byte[] ad, long adLen, byte[] nPub, byte[] k) {
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_ietf_decrypt_detached(m, nSec, c, cLen, mac, ad, adLen, nPub, k));
    }

    @Override
    public void cryptoAeadXChaCha20Poly1305IetfKeygen(byte[] k) {
        this.getSodium().crypto_aead_xchacha20poly1305_ietf_keygen(k);
    }

    @Override
    public boolean cryptoAeadXChaCha20Poly1305IetfEncrypt(byte[] c, long[] cLen, byte[] m, long mLen, byte[] ad, long adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.successful(this.getSodium().crypto_aead_xchacha20poly1305_ietf_encrypt(c, cLen, m, mLen, ad, adLen, nSec, nPub, k));
    }

    @Override
    public boolean cryptoAeadXChaCha20Poly1305IetfDecrypt(byte[] m, long[] mLen, byte[] nSec, byte[] c, long cLen, byte[] ad, long adLen, byte[] nPub, byte[] k) {
        return this.successful(this.getSodium().crypto_aead_xchacha20poly1305_ietf_decrypt(m, mLen, nSec, c, cLen, ad, adLen, nPub, k));
    }

    @Override
    public boolean cryptoAeadXChaCha20Poly1305IetfEncryptDetached(byte[] c, byte[] mac, long[] macLenAddress, byte[] m, long mLen, byte[] ad, long adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.successful(this.getSodium().crypto_aead_xchacha20poly1305_ietf_encrypt_detached(c, mac, macLenAddress, m, mLen, ad, adLen, nSec, nPub, k));
    }

    @Override
    public boolean cryptoAeadXChaCha20Poly1305IetfDecryptDetached(byte[] m, byte[] nSec, byte[] c, long cLen, byte[] mac, byte[] ad, long adLen, byte[] nPub, byte[] k) {
        return this.successful(this.getSodium().crypto_aead_xchacha20poly1305_ietf_decrypt_detached(m, nSec, c, cLen, mac, ad, adLen, nPub, k));
    }

    @Override
    public void cryptoAeadAES256GCMKeygen(byte[] key) {
        this.getSodium().crypto_aead_aes256gcm_keygen(key);
    }

    @Override
    public boolean cryptoAeadAES256GCMEncrypt(byte[] cipher, long[] cipherLen, byte[] message, long messageLen, byte[] additionalData, long additionalDataLen, byte[] nSec, byte[] nPub, byte[] key) {
        return this.successful(this.getSodium().crypto_aead_aes256gcm_encrypt(cipher, cipherLen, message, messageLen, additionalData, additionalDataLen, nSec, nPub, key));
    }

    @Override
    public boolean cryptoAeadAES256GCMDecrypt(byte[] message, long[] messageLen, byte[] nSec, byte[] cipher, long cipherLen, byte[] additionalData, long additionalDataLen, byte[] nPub, byte[] key) {
        return this.successful(this.getSodium().crypto_aead_aes256gcm_decrypt(message, messageLen, nSec, cipher, cipherLen, additionalData, additionalDataLen, nPub, key));
    }

    @Override
    public boolean cryptoAeadAES256GCMEncryptDetached(byte[] cipher, byte[] mac, long[] macLenAddress, byte[] message, long messageLen, byte[] additionalData, long additionalDataLen, byte[] nSec, byte[] nPub, byte[] key) {
        return this.successful(this.getSodium().crypto_aead_aes256gcm_encrypt_detached(cipher, mac, macLenAddress, message, messageLen, additionalData, additionalDataLen, nSec, nPub, key));
    }

    @Override
    public boolean cryptoAeadAES256GCMDecryptDetached(byte[] message, byte[] nSec, byte[] cipher, long cipherLen, byte[] mac, byte[] additionalData, long additionalDataLen, byte[] nPub, byte[] key) {
        return this.successful(this.getSodium().crypto_aead_aes256gcm_decrypt_detached(message, nSec, cipher, cipherLen, mac, additionalData, additionalDataLen, nPub, key));
    }

    @Override
    public boolean cryptoAeadAES256GCMIsAvailable() {
        return this.getSodium().crypto_aead_aes256gcm_is_available() == 1;
    }

    @Override
    public Key keygen(AEAD.Method method) {
        switch (method) {
            case CHACHA20_POLY1305: {
                byte[] key = this.randomBytesBuf(32);
                this.cryptoAeadChaCha20Poly1305Keygen(key);
                return Key.fromBytes(key);
            }
            case CHACHA20_POLY1305_IETF: {
                byte[] key2 = this.randomBytesBuf(32);
                this.cryptoAeadChaCha20Poly1305IetfKeygen(key2);
                return Key.fromBytes(key2);
            }
            case XCHACHA20_POLY1305_IETF: {
                byte[] key3 = this.randomBytesBuf(32);
                this.cryptoAeadChaCha20Poly1305IetfKeygen(key3);
                return Key.fromBytes(key3);
            }
            case AES256GCM: {
                byte[] key4 = this.randomBytesBuf(32);
                this.cryptoAeadAES256GCMKeygen(key4);
                return Key.fromBytes(key4);
            }
        }
        return null;
    }

    @Override
    public String encrypt(String m, String additionalData, byte[] nPub, Key k, AEAD.Method method) {
        return this.encrypt(m, additionalData, null, nPub, k, method);
    }

    @Override
    public String encrypt(String m, String additionalData, byte[] nSec, byte[] nPub, Key k, AEAD.Method method) {
        byte[] messageBytes = this.bytes(m);
        byte[] additionalDataBytes = additionalData == null ? new byte[]{} : this.bytes(additionalData);
        long additionalBytesLen = additionalData == null ? 0L : (long)additionalDataBytes.length;
        byte[] keyBytes = k.getAsBytes();
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305)) {
            byte[] cipherBytes = new byte[messageBytes.length + 16];
            this.cryptoAeadChaCha20Poly1305Encrypt(cipherBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nSec, nPub, keyBytes);
            return LazySodium.toHex(cipherBytes);
        }
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305_IETF)) {
            byte[] cipherBytes = new byte[messageBytes.length + 16];
            this.cryptoAeadChaCha20Poly1305IetfEncrypt(cipherBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nSec, nPub, keyBytes);
            return LazySodium.toHex(cipherBytes);
        }
        if (method.equals((Object)AEAD.Method.XCHACHA20_POLY1305_IETF)) {
            byte[] cipherBytes3 = new byte[messageBytes.length + 16];
            this.cryptoAeadXChaCha20Poly1305IetfEncrypt(cipherBytes3, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nSec, nPub, keyBytes);
            return LazySodium.toHex(cipherBytes3);
        }
        byte[] cipherBytes = new byte[messageBytes.length + 16];
        this.cryptoAeadAES256GCMEncrypt(cipherBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nSec, nPub, keyBytes);
        return LazySodium.toHex(cipherBytes);
    }

    @Override
    public String decrypt(String cipher, String additionalData, byte[] nPub, Key k, AEAD.Method method) {
        return this.decrypt(cipher, additionalData, null, nPub, k, method);
    }

    @Override
    public String decrypt(String cipher, String additionalData, byte[] nSec, byte[] nPub, Key k, AEAD.Method method) {
        byte[] cipherBytes = LazySodium.toBin(cipher);
        byte[] additionalDataBytes = additionalData == null ? new byte[]{} : this.bytes(additionalData);
        long additionalBytesLen = additionalData == null ? 0L : (long)additionalDataBytes.length;
        byte[] keyBytes = k.getAsBytes();
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305)) {
            byte[] messageBytes = new byte[cipherBytes.length - 16];
            this.cryptoAeadChaCha20Poly1305Decrypt(messageBytes, null, nSec, cipherBytes, cipherBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
            return this.str(messageBytes);
        }
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305_IETF)) {
            byte[] messageBytes = new byte[cipherBytes.length - 16];
            this.cryptoAeadChaCha20Poly1305IetfDecrypt(messageBytes, null, nSec, cipherBytes, cipherBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
            return this.str(messageBytes);
        }
        if (method.equals((Object)AEAD.Method.XCHACHA20_POLY1305_IETF)) {
            byte[] messageBytes = new byte[cipherBytes.length - 16];
            this.cryptoAeadXChaCha20Poly1305IetfDecrypt(messageBytes, null, nSec, cipherBytes, cipherBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
            return this.str(messageBytes);
        }
        byte[] messageBytes = new byte[cipherBytes.length - 16];
        this.cryptoAeadAES256GCMDecrypt(messageBytes, null, nSec, cipherBytes, cipherBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
        return this.str(messageBytes);
    }

    @Override
    public DetachedEncrypt encryptDetached(String m, String additionalData, byte[] nSec, byte[] nPub, Key k, AEAD.Method method) {
        byte[] messageBytes = this.bytes(m);
        byte[] additionalDataBytes = additionalData == null ? new byte[]{} : this.bytes(additionalData);
        long additionalBytesLen = additionalData == null ? 0L : (long)additionalDataBytes.length;
        byte[] keyBytes = k.getAsBytes();
        byte[] cipherBytes = new byte[messageBytes.length];
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305)) {
            byte[] macBytes = new byte[16];
            this.cryptoAeadChaCha20Poly1305EncryptDetached(cipherBytes, macBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nSec, nPub, keyBytes);
            return new DetachedEncrypt(cipherBytes, macBytes);
        }
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305_IETF)) {
            byte[] macBytes = new byte[16];
            this.cryptoAeadChaCha20Poly1305IetfEncryptDetached(cipherBytes, macBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nSec, nPub, keyBytes);
            return new DetachedEncrypt(cipherBytes, macBytes);
        }
        if (method.equals((Object)AEAD.Method.XCHACHA20_POLY1305_IETF)) {
            byte[] macBytes = new byte[16];
            this.cryptoAeadXChaCha20Poly1305IetfEncryptDetached(cipherBytes, macBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nSec, nPub, keyBytes);
            return new DetachedEncrypt(cipherBytes, macBytes);
        }
        byte[] macBytes = new byte[16];
        this.cryptoAeadAES256GCMEncryptDetached(cipherBytes, macBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nSec, nPub, keyBytes);
        return new DetachedEncrypt(cipherBytes, macBytes);
    }

    @Override
    public DetachedDecrypt decryptDetached(DetachedEncrypt detachedEncrypt, String additionalData, byte[] nSec, byte[] nPub, Key k, AEAD.Method method) {
        byte[] cipherBytes = detachedEncrypt.getCipher();
        byte[] additionalDataBytes = additionalData == null ? new byte[]{} : this.bytes(additionalData);
        long additionalBytesLen = additionalData == null ? 0L : (long)additionalDataBytes.length;
        byte[] keyBytes = k.getAsBytes();
        byte[] messageBytes = new byte[cipherBytes.length];
        byte[] macBytes = detachedEncrypt.getMac();
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305)) {
            this.cryptoAeadChaCha20Poly1305DecryptDetached(messageBytes, nSec, cipherBytes, cipherBytes.length, macBytes, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
            return new DetachedDecrypt(messageBytes, macBytes, this.charset);
        }
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305_IETF)) {
            this.cryptoAeadChaCha20Poly1305IetfDecryptDetached(messageBytes, nSec, cipherBytes, cipherBytes.length, macBytes, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
            return new DetachedDecrypt(messageBytes, macBytes, this.charset);
        }
        if (method.equals((Object)AEAD.Method.XCHACHA20_POLY1305_IETF)) {
            this.cryptoAeadXChaCha20Poly1305IetfDecryptDetached(messageBytes, nSec, cipherBytes, cipherBytes.length, macBytes, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
            return new DetachedDecrypt(messageBytes, macBytes, this.charset);
        }
        this.cryptoAeadAES256GCMDecryptDetached(messageBytes, nSec, cipherBytes, cipherBytes.length, macBytes, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
        return new DetachedDecrypt(messageBytes, macBytes, this.charset);
    }

    @Override
    public <T> T res(int res, T object) {
        return res != 0 ? null : (T)object;
    }

    @Override
    public boolean successful(int res) {
        return res == 0;
    }

    @Override
    public String str(byte[] bs) {
        return new String(bs, this.charset);
    }

    @Override
    public String str(byte[] bs, Charset charset) {
        if (charset == null) {
            return new String(bs, this.charset);
        }
        return new String(bs, charset);
    }

    @Override
    public byte[] bytes(String s) {
        return s.getBytes(this.charset);
    }

    @Override
    public boolean wrongLen(byte[] bs, int shouldBe) {
        return bs.length != shouldBe;
    }

    @Override
    public boolean wrongLen(int byteLength, int shouldBe) {
        return byteLength != shouldBe;
    }

    @Override
    public boolean wrongLen(int byteLength, long shouldBe) {
        return (long)byteLength != shouldBe;
    }

    @Override
    public byte[] removeNulls(byte[] bs) {
        int totalBytesToCut = 0;
        for (int i = bs.length - 1; i >= 0; --i) {
            byte b = bs[i];
            if (b != 0) continue;
            ++totalBytesToCut;
        }
        int newLengthOfBs = bs.length - totalBytesToCut;
        byte[] trimmed = new byte[newLengthOfBs];
        System.arraycopy(bs, 0, trimmed, 0, newLengthOfBs);
        return trimmed;
    }

    public abstract Sodium getSodium();

    public static void main(String[] args) {
    }
}

