/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium;

import com.goterl.lazycode.lazysodium.Sodium;
import com.goterl.lazycode.lazysodium.utils.NativeUtils;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.IOException;

public class SodiumJava
extends Sodium {
    public SodiumJava() {
        this.registerFromResources();
        this.onRegistered();
    }

    public SodiumJava(String path) {
        Native.register(SodiumJava.class, (String)path);
        this.onRegistered();
    }

    public native int crypto_pwhash_scryptsalsa208sha256(byte[] var1, long var2, byte[] var4, long var5, byte[] var7, long var8, long var10);

    public native int crypto_pwhash_scryptsalsa208sha256_str(byte[] var1, byte[] var2, long var3, long var5, long var7);

    public native int crypto_pwhash_scryptsalsa208sha256_str_verify(byte[] var1, byte[] var2, long var3);

    public native int crypto_pwhash_scryptsalsa208sha256_ll(byte[] var1, int var2, byte[] var3, int var4, long var5, long var7, long var9, byte[] var11, int var12);

    public native int crypto_pwhash_scryptsalsa208sha256_str_needs_rehash(byte[] var1, long var2, long var4);

    public native int crypto_stream_xchacha20(byte[] var1, long var2, byte[] var4, byte[] var5);

    public native int crypto_stream_xchacha20_xor(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6);

    public native int crypto_stream_xchacha20_xor_ic(byte[] var1, byte[] var2, long var3, byte[] var5, long var6, byte[] var8);

    public native void crypto_stream_xchacha20_keygen(byte[] var1);

    private void registerFromResources() {
        String path = this.getLibSodiumFromResources();
        try {
            NativeUtils.loadLibraryFromJar(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getLibSodiumFromResources() {
        String path = this.getPath("windows", "libsodium.dll");
        if (Platform.isLinux() || Platform.isAndroid()) {
            path = this.getPath("linux", "libsodium.so");
        } else if (Platform.isMac()) {
            path = this.getPath("mac", "libsodium.dylib");
        }
        return path;
    }

    private String getPath(String folder, String name) {
        String separator = "/";
        String resourcePath = folder + separator + name;
        if (!resourcePath.startsWith(separator)) {
            resourcePath = separator + resourcePath;
        }
        return resourcePath;
    }
}

