/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium.interfaces;

import com.goterl.lazycode.lazysodium.exceptions.SodiumException;
import com.goterl.lazycode.lazysodium.utils.BaseChecker;
import java.nio.charset.Charset;

public interface SecretBox {
    public static final int XSALSA20POLY1305_KEYBYTES = 32;
    public static final int XSALSA20POLY1305_NONCEBYTES = 24;
    public static final int XSALSA20POLY1305_MACBYTES = 16;
    public static final int KEYBYTES = 32;
    public static final int MACBYTES = 16;
    public static final int NONCEBYTES = 24;

    public static interface Lazy {
        public String cryptoSecretBoxKeygen();

        public String cryptoSecretBoxEasy(String var1, byte[] var2, String var3) throws SodiumException;

        public String cryptoSecretBoxOpenEasy(String var1, byte[] var2, String var3, Charset var4) throws SodiumException;
    }

    public static interface Native {
        public void cryptoSecretBoxKeygen(byte[] var1);

        public boolean cryptoSecretBoxEasy(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6);

        public boolean cryptoSecretBoxOpenEasy(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6);

        public boolean cryptoSecretBoxDetached(byte[] var1, byte[] var2, byte[] var3, long var4, byte[] var6, byte[] var7);

        public boolean cryptoSecretBoxOpenDetached(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6);
    }

    public static class Checker
    extends BaseChecker {
        public static boolean checkKeyLen(int len) {
            return 32 == len;
        }

        public static boolean checkMacLen(int len) {
            return 16 == len;
        }

        public static boolean checkNonceLen(int len) {
            return 24 == len;
        }
    }
}

