/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium;

import com.goterl.lazycode.lazysodium.structs.crypto_secretstream_xchacha20poly1305_state;
import com.goterl.lazycode.lazysodium.utils.NativeUtils;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;

public class Sodium {
    private Sodium() {
        this.registerFromResources();
    }

    private Sodium(String path) {
        this.registerFromPath(path);
    }

    private Sodium(String path, boolean isAndroid) {
        if (isAndroid) {
            Native.register(Sodium.class, (String)path);
        } else {
            this.registerFromPath(path);
        }
    }

    public static Sodium loadJava() {
        return new Sodium();
    }

    public static Sodium loadJava(String libSodiumNativeLibPath) {
        return new Sodium(libSodiumNativeLibPath);
    }

    public static Sodium loadAndroid() {
        return new Sodium("sodium", true);
    }

    public static Sodium loadAndroid(String libSodiumNativeLibPath) {
        return new Sodium(libSodiumNativeLibPath, true);
    }

    private void registerFromResources() {
        String path = this.getLibSodiumFromResources();
        try {
            NativeUtils.loadLibraryFromJar(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void registerFromPath(String path) {
        Native.register(Sodium.class, (String)path);
    }

    private String getLibSodiumFromResources() {
        String path = this.getPath("windows", "libsodium.dll");
        if (Platform.isLinux() || Platform.isAndroid()) {
            path = this.getPath("linux", "libsodium.so");
        } else if (Platform.isMac()) {
            path = this.getPath("mac", "libsodium.dylib");
        }
        return path;
    }

    private String getPath(String folder, String name) {
        String resourcePath = folder + File.separator + name;
        if (!resourcePath.startsWith(File.separator)) {
            resourcePath = File.separator + resourcePath;
        }
        return resourcePath;
    }

    native int sodium_pad(int var1, char[] var2, int var3, int var4, int var5);

    native int sodium_unpad(int var1, char[] var2, int var3, int var4);

    native byte randombytes_random();

    native byte randombytes_uniform(int var1);

    native void randombytes_buf(byte[] var1, int var2);

    native void randombytes_buf_deterministic(byte[] var1, int var2, byte[] var3);

    native int crypto_pwhash(byte[] var1, long var2, byte[] var4, long var5, byte[] var7, long var8, long var10, int var12);

    native int crypto_pwhash_str(byte[] var1, byte[] var2, long var3, long var5, long var7);

    native int crypto_pwhash_str_verify(byte[] var1, byte[] var2, long var3);

    native int crypto_pwhash_str_needs_rehash(byte[] var1, long var2, long var4);

    native void crypto_kdf_keygen(byte[] var1);

    native int crypto_kdf_derive_from_key(byte[] var1, int var2, long var3, byte[] var5, byte[] var6);

    native void crypto_secretbox_keygen(byte[] var1);

    native int crypto_secretbox_easy(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6);

    native int crypto_secretbox_open_easy(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6);

    native int crypto_secretbox_detached(byte[] var1, byte[] var2, byte[] var3, long var4, byte[] var6, byte[] var7);

    native int crypto_secretbox_open_detached(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6);

    native void crypto_secretstream_xchacha20poly1305_keygen(byte[] var1);

    native int crypto_secretstream_xchacha20poly1305_init_push(crypto_secretstream_xchacha20poly1305_state var1, byte[] var2, byte[] var3);

    native int crypto_secretstream_xchacha20poly1305_push(crypto_secretstream_xchacha20poly1305_state var1, byte[] var2, Long var3, byte[] var4, long var5, byte[] var7, long var8, byte var10);

    native int crypto_secretstream_xchacha20poly1305_init_pull(crypto_secretstream_xchacha20poly1305_state var1, byte[] var2, byte[] var3);

    native int crypto_secretstream_xchacha20poly1305_pull(crypto_secretstream_xchacha20poly1305_state var1, byte[] var2, Long var3, byte var4, byte[] var5, long var6, byte[] var8, long var9);

    native int crypto_auth(byte[] var1, byte[] var2, long var3, byte[] var5);

    native int crypto_auth_verify(byte[] var1, byte[] var2, long var3, byte[] var5);

    native void crypto_auth_keygen(byte[] var1);

    native int crypto_shorthash(byte[] var1, byte[] var2, long var3, byte[] var5);

    native int crypto_shorthash_keygen(byte[] var1);

    native int crypto_shorthash_siphashx24(byte[] var1, byte[] var2, long var3, byte[] var5);

    native int crypto_generichash(byte[] var1, int var2, byte[] var3, long var4, byte[] var6, int var7);

    native void crypto_generichash_keygen(byte[] var1);

    native int crypto_kx_keypair(byte[] var1, byte[] var2);

    native int crypto_kx_seed_keypair(byte[] var1, byte[] var2, byte[] var3);

    native int crypto_kx_client_session_keys(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    native int crypto_kx_server_session_keys(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    native int crypto_aead_chacha20poly1305_keygen(byte[] var1);

    native int crypto_aead_chacha20poly1305_encrypt(byte[] var1, long var2, byte[] var4, long var5, byte[] var7, long var8, byte[] var10, byte[] var11, byte[] var12);

    native int crypto_aead_chacha20poly1305_decrypt(byte[] var1, long var2, byte[] var4, byte[] var5, long var6, byte[] var8, long var9, byte[] var11, byte[] var12);

    native int crypto_aead_chacha20poly1305_encrypt_detached(byte[] var1, byte[] var2, Long var3, byte[] var4, long var5, byte[] var7, long var8, byte[] var10, byte[] var11, byte[] var12);

    native int crypto_aead_chacha20poly1305_decrypt_detached(byte[] var1, byte[] var2, byte[] var3, long var4, byte[] var6, byte[] var7, long var8, byte[] var10, byte[] var11);
}

