/*
 * Decompiled with CFR 0.152.
 */
package gradlegitproperties.org.eclipse.jgit.treewalk.filter;

import gradlegitproperties.org.eclipse.jgit.dircache.DirCacheEntry;
import gradlegitproperties.org.eclipse.jgit.dircache.DirCacheIterator;
import gradlegitproperties.org.eclipse.jgit.treewalk.TreeWalk;
import gradlegitproperties.org.eclipse.jgit.treewalk.filter.TreeFilter;

public class SkipWorkTreeFilter
extends TreeFilter {
    private final int treeIdx;

    public SkipWorkTreeFilter(int treeIdx) {
        this.treeIdx = treeIdx;
    }

    @Override
    public boolean include(TreeWalk walker) {
        DirCacheIterator i = walker.getTree(this.treeIdx, DirCacheIterator.class);
        if (i == null) {
            return true;
        }
        DirCacheEntry e = i.getDirCacheEntry();
        return e == null || !e.isSkipWorkTree();
    }

    @Override
    public boolean shouldBeRecursive() {
        return false;
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "SkipWorkTree(" + this.treeIdx + ")";
    }
}

