/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mavenfilesync;

import com.googlecode.mavenfilesync.FileSyncMapping;
import com.googlecode.mavenfilesync.FileSyncSetupMojo;
import java.util.Collection;

public class SettingsBuilder {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final StringBuilder settings = new StringBuilder("WARNING=DO NOT MODIFY THIS FILE IF YOU DON'T UNDERSTAND").append(NEW_LINE);
    private boolean defaultDestinationGiven = false;
    private int mappingsCount = 0;

    public SettingsBuilder with(FileSyncSetupMojo.Param name, boolean value) {
        return this.with(name, String.valueOf(value));
    }

    public SettingsBuilder with(FileSyncSetupMojo.Param name, String value) {
        if (FileSyncSetupMojo.Param.DEFAULT_DESTINATION.equals((Object)name) && value.length() > 0) {
            this.defaultDestinationGiven = true;
        }
        this.settings.append((Object)name).append("=").append(value).append(NEW_LINE);
        return this;
    }

    public SettingsBuilder withMapping(FileSyncMapping mapping) {
        if ((mapping.getDestinationFolder() == null || mapping.getDestinationFolder().length() == 0 || ",".equals(mapping.getDestinationFolder())) && !this.defaultDestinationGiven) {
            throw new IllegalArgumentException("Mapping destination folder has to be given if no default destination has been specified.");
        }
        if (mapping.getSourceFolder().length() == 0) {
            throw new IllegalArgumentException("The source folder has to be given for every mapping.");
        }
        this.settings.append(new MappingBuilder(this.mappingsCount).withMapping(mapping).build());
        ++this.mappingsCount;
        return this;
    }

    public String build() {
        return this.settings.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MappingBuilder {
        final StringBuilder mappingBuilder;

        public MappingBuilder(int index) {
            this.mappingBuilder = new StringBuilder("map|").append(index).append("=");
        }

        public MappingBuilder withMapping(FileSyncMapping mapping) {
            this.mappingBuilder.append(mapping.getSourceFolder()).append("|");
            this.mappingBuilder.append(mapping.getDestinationFolder()).append("|");
            this.mappingBuilder.append((CharSequence)this.semicolonSeparatedCollection(mapping.getInclPatternList())).append("|");
            this.mappingBuilder.append((CharSequence)this.semicolonSeparatedCollection(mapping.getExclPatternList())).append("|");
            this.mappingBuilder.append(mapping.getVariablesFile()).append(NEW_LINE);
            return this;
        }

        private StringBuilder semicolonSeparatedCollection(Collection<String> collection) {
            StringBuilder builder = new StringBuilder();
            for (String element : collection) {
                builder.append(element).append(";");
            }
            builder.deleteCharAt(builder.length() - 1);
            return builder;
        }

        public String build() {
            return this.mappingBuilder.toString();
        }
    }
}

