/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.exoplayer;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import com.google.android.exoplayer.DefaultLoadControl;
import com.google.android.exoplayer.LoadControl;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.hls.DefaultHlsTrackSelector;
import com.google.android.exoplayer.hls.HlsChunkSource;
import com.google.android.exoplayer.hls.HlsMasterPlaylist;
import com.google.android.exoplayer.hls.HlsPlaylist;
import com.google.android.exoplayer.hls.HlsPlaylistParser;
import com.google.android.exoplayer.hls.HlsSampleSource;
import com.google.android.exoplayer.hls.HlsTrackSelector;
import com.google.android.exoplayer.hls.PtsTimestampAdjusterProvider;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DefaultAllocator;
import com.google.android.exoplayer.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer.upstream.DefaultUriDataSource;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import com.google.android.exoplayer.upstream.UriLoadable;
import com.google.android.exoplayer.util.ManifestFetcher;
import com.google.vr.sdk.widgets.video.exoplayer.RendererBuilder;
import java.io.IOException;

public class HlsRendererBuilder
implements RendererBuilder,
ManifestFetcher.ManifestCallback<HlsPlaylist> {
    private static final int MAIN_BUFFER_SEGMENTS = 254;
    private static final int AUDIO_BUFFER_SEGMENTS = 54;
    private final Context context;
    private RendererBuilder.Listener listener;
    private ManifestFetcher<HlsPlaylist> playlistFetcher;
    private final Handler handler;
    private final Uri uri;

    public HlsRendererBuilder(Context context, Uri uri) {
        this.context = context;
        this.uri = uri;
        this.handler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void buildRenderers(RendererBuilder.Listener listener) {
        this.listener = listener;
        HlsPlaylistParser parser = new HlsPlaylistParser();
        this.playlistFetcher = new ManifestFetcher(this.uri.toString(), (UriDataSource)new DefaultUriDataSource(this.context, "Video Player Widget"), (UriLoadable.Parser)parser);
        this.playlistFetcher.singleLoad(this.handler.getLooper(), (ManifestFetcher.ManifestCallback)this);
    }

    public void onSingleManifest(HlsPlaylist manifest) {
        MediaCodecAudioTrackRenderer audioRenderer;
        DefaultLoadControl loadControl = new DefaultLoadControl((Allocator)new DefaultAllocator(65536));
        DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
        PtsTimestampAdjusterProvider timestampAdjusterProvider = new PtsTimestampAdjusterProvider();
        boolean haveAudios = false;
        if (manifest instanceof HlsMasterPlaylist) {
            HlsMasterPlaylist masterPlaylist = (HlsMasterPlaylist)manifest;
            haveAudios = !masterPlaylist.audios.isEmpty();
        }
        DefaultUriDataSource dataSource = new DefaultUriDataSource(this.context, (TransferListener)bandwidthMeter, "Video Player Widget");
        HlsChunkSource chunkSource = new HlsChunkSource(true, (DataSource)dataSource, manifest, (HlsTrackSelector)DefaultHlsTrackSelector.newDefaultInstance((Context)this.context), (BandwidthMeter)bandwidthMeter, timestampAdjusterProvider);
        HlsSampleSource sampleSource = new HlsSampleSource(chunkSource, (LoadControl)loadControl, 0xFE0000);
        MediaCodecVideoTrackRenderer videoRenderer = new MediaCodecVideoTrackRenderer(this.context, (SampleSource)sampleSource, MediaCodecSelector.DEFAULT, 1);
        if (haveAudios) {
            DefaultUriDataSource audioDataSource = new DefaultUriDataSource(this.context, (TransferListener)bandwidthMeter, "Video Player Widget");
            HlsChunkSource audioChunkSource = new HlsChunkSource(false, (DataSource)audioDataSource, manifest, (HlsTrackSelector)DefaultHlsTrackSelector.newAudioInstance(), (BandwidthMeter)bandwidthMeter, timestampAdjusterProvider);
            HlsSampleSource audioSampleSource = new HlsSampleSource(audioChunkSource, (LoadControl)loadControl, 0x360000);
            audioRenderer = new MediaCodecAudioTrackRenderer(new SampleSource[]{sampleSource, audioSampleSource}, MediaCodecSelector.DEFAULT, null, true, null, null, AudioCapabilities.getCapabilities((Context)this.context), 3);
        } else {
            audioRenderer = new MediaCodecAudioTrackRenderer((SampleSource)sampleSource, MediaCodecSelector.DEFAULT);
        }
        this.listener.onRenderersReady(audioRenderer, new TrackRenderer[]{videoRenderer});
    }

    public void onSingleManifestError(IOException e) {
        String string = String.valueOf(e);
        this.listener.onRenderersError(new StringBuilder(30 + String.valueOf(string).length()).append("Error fetching video manifest ").append(string).toString());
    }
}

