/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.exoplayer;

import android.content.Context;
import android.net.Uri;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorSampleSource;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DefaultAllocator;
import com.google.android.exoplayer.upstream.DefaultUriDataSource;
import com.google.vr.sdk.widgets.video.exoplayer.RendererBuilder;

public class ExtractorRendererBuilder
implements RendererBuilder {
    private static final int MAX_DROPPED_FRAME_COUNT_TO_NOTIFY = 1;
    private final Uri[] uris;
    private final Context context;

    public ExtractorRendererBuilder(Context context, Uri[] uris) {
        this.uris = uris;
        this.context = context;
    }

    @Override
    public void buildRenderers(RendererBuilder.Listener listener) {
        MediaCodecAudioTrackRenderer audioRenderer = null;
        TrackRenderer[] videoRenderers = new TrackRenderer[this.uris.length];
        for (int i = 0; i < this.uris.length; ++i) {
            DefaultUriDataSource dataSource = new DefaultUriDataSource(this.context, "Video Player Widget");
            ExtractorSampleSource sampleSource = new ExtractorSampleSource(this.uris[i], (DataSource)dataSource, (Allocator)new DefaultAllocator(65536), 0x800000, new Extractor[0]);
            videoRenderers[i] = new MediaCodecVideoTrackRenderer(this.context, (SampleSource)sampleSource, MediaCodecSelector.DEFAULT, 1, 0L, null, null, 1);
            if (i != 0) continue;
            audioRenderer = new MediaCodecAudioTrackRenderer((SampleSource)sampleSource, MediaCodecSelector.DEFAULT);
        }
        listener.onRenderersReady(audioRenderer, videoRenderers);
    }
}

