/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import com.google.android.exoplayer.DummyTrackRenderer;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayer;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.TrackRenderer;
import com.google.protobuf.nano.MessageNano;
import com.google.vr.jump.preview.model.SphericalMetadataMP4;
import com.google.vr.sdk.widgets.video.SphericalMetadataParser;
import com.google.vr.sdk.widgets.video.VideoTexture;
import com.google.vr.sdk.widgets.video.VrVideoEventListener;
import com.google.vr.sdk.widgets.video.VrVideoView;
import com.google.vr.sdk.widgets.video.exoplayer.ExtractorRendererBuilder;
import com.google.vr.sdk.widgets.video.exoplayer.HlsRendererBuilder;
import com.google.vr.sdk.widgets.video.exoplayer.RendererBuilder;
import com.google.vr.sdk.widgets.video.nano.SphericalMetadataOuterClass;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class VrVideoPlayerInternal
implements RendererBuilder.Listener {
    private static final String TAG = VrVideoPlayerInternal.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final int MAX_NUM_RENDERERS = 3;
    private TrackRenderer[] videoRenderers = new TrackRenderer[0];
    private MediaCodecAudioTrackRenderer audioRenderer;
    private VideoTexture[] videoTextures = new VideoTexture[0];
    protected ExoPlayer player;
    protected boolean isLooping;
    private boolean isPreparing = false;
    private Context context;
    private VrVideoEventListener eventListener;
    private SphericalMetadataOuterClass.SphericalMetadata metadata;
    private VideoTexturesListener videoTexturesListener;
    private float volume = 1.0f;

    public VrVideoPlayerInternal(Context context) {
        this.init(context);
    }

    protected VrVideoPlayerInternal() {
    }

    protected void init(Context context) {
        this.context = context;
        this.player = ExoPlayer.Factory.newInstance((int)3, (int)0, (int)0);
        this.player.addListener((ExoPlayer.Listener)new VideoLooperListener());
        this.player.setPlayWhenReady(true);
    }

    private void loadVideoIntoPlayer(Uri[] uris, VrVideoView.Options options) {
        if (options == null) {
            options = new VrVideoView.Options();
        } else {
            options.validate();
        }
        if (uris.length > 2) {
            Log.e((String)TAG, (String)"Try to load more streams than we support. Maximum is 2");
            return;
        }
        RendererBuilder builder = null;
        if (options.inputFormat == 2) {
            if (uris.length > 1) {
                Log.w((String)TAG, (String)"Only first Uri will be used with HLS format.");
            }
            builder = new HlsRendererBuilder(this.context, uris[0]);
        } else {
            builder = new ExtractorRendererBuilder(this.context, uris);
        }
        builder.buildRenderers(this);
    }

    @Override
    public synchronized void onRenderersReady(MediaCodecAudioTrackRenderer audioRenderer, TrackRenderer[] videoRenderers) {
        int i;
        this.audioRenderer = audioRenderer;
        this.videoRenderers = new TrackRenderer[videoRenderers.length];
        System.arraycopy(videoRenderers, 0, this.videoRenderers, 0, videoRenderers.length);
        TrackRenderer[] allRenderers = new TrackRenderer[3];
        allRenderers[0] = audioRenderer;
        System.arraycopy(videoRenderers, 0, allRenderers, 1, videoRenderers.length);
        for (i = 1 + videoRenderers.length; i < 3; ++i) {
            allRenderers[i] = new DummyTrackRenderer();
        }
        this.player.prepare(allRenderers);
        this.videoTextures = new VideoTexture[videoRenderers.length];
        for (i = 0; i < videoRenderers.length; ++i) {
            this.videoTextures[i] = new VideoTexture();
        }
        this.videoTextures[0].setFrameNotifier(new NewFrameNotifier());
        if (this.videoTexturesListener != null) {
            this.videoTexturesListener.onVideoTexturesReady();
        }
        this.applyVolumeToAudioRenderer();
    }

    @Override
    public void onRenderersError(String errorMessage) {
        int n = this.hashCode();
        Log.e((String)TAG, (String)new StringBuilder(29 + String.valueOf(errorMessage).length()).append(n).append(".onRenderersError ").append(errorMessage).toString());
        if (this.eventListener != null) {
            this.eventListener.onLoadError(errorMessage);
        }
    }

    public void setEventListener(VrVideoEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void openAsset(String[] filenames, VrVideoView.Options options) throws IOException {
        this.metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        this.metadata = options != null ? VrVideoPlayerInternal.createMetadataFromOptions(options) : VrVideoPlayerInternal.parseMetadataFromVideoInputStream(this.context.getAssets().open(filenames[0]));
        Uri[] videoUris = new Uri[filenames.length];
        for (int i = 0; i < filenames.length; ++i) {
            String string = String.valueOf(filenames[i]);
            videoUris[i] = Uri.parse((String)(string.length() != 0 ? "file:///android_asset/".concat(string) : new String("file:///android_asset/")));
        }
        this.loadVideoIntoPlayer(videoUris, options);
    }

    public void openUri(Uri[] uris, VrVideoView.Options options) throws IOException {
        this.metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        if (options != null) {
            this.metadata = VrVideoPlayerInternal.createMetadataFromOptions(options);
        } else {
            String scheme = uris[0].getScheme();
            if (scheme == null || !scheme.startsWith("http")) {
                this.metadata = VrVideoPlayerInternal.parseMetadataFromVideoInputStream(new FileInputStream(uris[0].getPath()));
            }
        }
        this.loadVideoIntoPlayer(uris, options);
    }

    public SphericalMetadataOuterClass.SphericalMetadata getMetadata() {
        return this.metadata;
    }

    public byte[] getMetadataBytes() {
        return SphericalMetadataOuterClass.SphericalMetadata.toByteArray((MessageNano)this.metadata);
    }

    public synchronized int[] bindTexture() {
        if (this.videoTextures.length == 0) {
            throw new IllegalStateException("openXXX() should be called successfully first.");
        }
        int[] textureIds = new int[this.videoTextures.length];
        for (int i = 0; i < this.videoTextures.length; ++i) {
            VideoTexture videoTexture = this.videoTextures[i];
            if (!videoTexture.getIsTextureSet()) {
                videoTexture.init();
            }
            this.player.sendMessage((ExoPlayer.ExoPlayerComponent)this.videoRenderers[i], 1, (Object)new Surface(videoTexture.getSurfaceTexture()));
            this.player.seekTo(this.player.getCurrentPosition() + 1L);
            textureIds[i] = videoTexture.getTextureId();
        }
        return textureIds;
    }

    public synchronized boolean prepareFrame() {
        boolean isReady = this.videoTextures.length > 0;
        for (VideoTexture videoTexture : this.videoTextures) {
            if (videoTexture.getIsTextureSet()) {
                videoTexture.updateTexture();
                continue;
            }
            isReady = false;
        }
        return isReady;
    }

    public synchronized void onViewDetach() {
        for (int i = 0; i < this.videoRenderers.length; ++i) {
            this.player.blockingSendMessage((ExoPlayer.ExoPlayerComponent)this.videoRenderers[i], 1, null);
            this.videoTextures[i].release();
        }
    }

    public synchronized void shutdown() {
        this.player.stop();
        this.player.release();
        for (VideoTexture videoTexture : this.videoTextures) {
            videoTexture.release();
        }
    }

    public synchronized long getCurrentPositionMs() {
        return this.player.getCurrentPosition();
    }

    public ExoPlayer getExoPlayer() {
        return this.player;
    }

    public void setVideoTexturesListener(VideoTexturesListener videoTexturesListener) {
        this.videoTexturesListener = videoTexturesListener;
    }

    public synchronized void setVolume(float volume) {
        this.volume = volume;
        this.applyVolumeToAudioRenderer();
    }

    private void applyVolumeToAudioRenderer() {
        if (this.audioRenderer != null) {
            this.player.sendMessage((ExoPlayer.ExoPlayerComponent)this.audioRenderer, 1, (Object)Float.valueOf(this.volume));
        }
    }

    private static SphericalMetadataOuterClass.SphericalMetadata createMetadataFromOptions(VrVideoView.Options options) {
        SphericalMetadataOuterClass.SphericalMetadata metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        switch (options.inputType) {
            case 1: {
                metadata.frameLayoutMode = 1;
                break;
            }
            case 2: {
                metadata.frameLayoutMode = 2;
                break;
            }
            default: {
                int n = options.inputType;
                throw new IllegalArgumentException(new StringBuilder(40).append("Unexpected options.inputType ").append(n).toString());
            }
        }
        return metadata;
    }

    private static SphericalMetadataOuterClass.SphericalMetadata parseMetadataFromVideoInputStream(InputStream videoInputStream) throws IOException {
        SphericalMetadataOuterClass.SphericalMetadata metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        String metadataString = SphericalMetadataMP4.extract(videoInputStream);
        metadata = SphericalMetadataParser.parse(metadataString);
        videoInputStream.close();
        return metadata;
    }

    class NewFrameNotifier
    implements Runnable {
        private Handler mainHandler = new Handler(Looper.getMainLooper());

        NewFrameNotifier() {
        }

        public void onNewFrame() {
            this.mainHandler.post((Runnable)this);
        }

        @Override
        public void run() {
            if (VrVideoPlayerInternal.this.eventListener != null) {
                VrVideoPlayerInternal.this.eventListener.onNewFrame();
            }
        }
    }

    private class VideoLooperListener
    implements ExoPlayer.Listener {
        private VideoLooperListener() {
        }

        public void onPlayerError(ExoPlaybackException error) {
            int n = this.hashCode();
            Log.e((String)TAG, (String)new StringBuilder(25).append(n).append(".onPlayerError").toString(), (Throwable)error);
            if (VrVideoPlayerInternal.this.eventListener != null) {
                VrVideoPlayerInternal.this.eventListener.onLoadError(error.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            if (playbackState == 2) {
                VrVideoPlayerInternal.this.isPreparing = true;
            } else if (playbackState == 4) {
                if (VrVideoPlayerInternal.this.isPreparing && VrVideoPlayerInternal.this.eventListener != null) {
                    VrVideoPlayerInternal.this.isPreparing = false;
                    VrVideoPlayerInternal.this.eventListener.onLoadSuccess();
                }
            } else if (playWhenReady && playbackState == 5) {
                if (VrVideoPlayerInternal.this.eventListener != null) {
                    VrVideoPlayerInternal.this.eventListener.onCompletion();
                }
                if (VrVideoPlayerInternal.this.isLooping) {
                    VrVideoPlayerInternal vrVideoPlayerInternal = VrVideoPlayerInternal.this;
                    synchronized (vrVideoPlayerInternal) {
                        VrVideoPlayerInternal.this.player.seekTo(0L);
                    }
                }
            }
        }

        public void onPlayWhenReadyCommitted() {
        }
    }

    public static interface VideoTexturesListener {
        public void onVideoTexturesReady();
    }
}

