/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.controller;

import android.graphics.PointF;
import com.google.vr.sdk.controller.ControllerManager;
import com.google.vr.sdk.controller.Orientation;

public class Controller {
    static final int MIN_VRCORE_API_WITH_RECENTERING = 8;
    private static final int DURATION_REQUIRED_TO_RECENTER_NS = 600000000;
    private static final float RECENTER_PITCH_BOUNDS_RADIANS = (float)Math.toRadians(30.0);
    public long timestamp = 0L;
    public final Orientation orientation = new Orientation();
    public final float[] position = new float[3];
    public boolean isTouching;
    public final PointF touch = new PointF();
    public boolean clickButtonState;
    public boolean appButtonState;
    public boolean homeButtonState;
    public boolean volumeUpButtonState;
    public boolean volumeDownButtonState;
    public int batteryLevelBucket;
    public boolean isCharging;
    private final ControllerManager manager;
    private final int controllerId;
    private EventListener controllerEventListener = new EventListener();
    boolean enableRecenterShim;
    private final Orientation controllerPoseInSensorSpace = new Orientation();
    private Orientation startFromSensorTransformation = new Orientation();
    private long homeButtonDownTimestamp;

    Controller(ControllerManager manager, int controllerId) {
        this.manager = manager;
        this.controllerId = controllerId;
    }

    public int getControllerId() {
        return this.controllerId;
    }

    public void setEventListener(EventListener listener) {
        this.controllerEventListener = listener;
    }

    public void update() {
        this.manager.updateController(this.controllerId);
    }

    void notifyConnectionStateChange(int state) {
        this.controllerEventListener.onConnectionStateChanged(state);
    }

    void notifyUpdate() {
        this.controllerEventListener.onUpdate();
    }

    void setPublicState(Controller newValues) {
        this.timestamp = newValues.timestamp;
        this.orientation.w = newValues.orientation.w;
        this.orientation.x = newValues.orientation.x;
        this.orientation.y = newValues.orientation.y;
        this.orientation.z = newValues.orientation.z;
        this.isTouching = newValues.isTouching;
        this.touch.x = newValues.touch.x;
        this.touch.y = newValues.touch.y;
        System.arraycopy(newValues.position, 0, this.position, 0, this.position.length);
        this.appButtonState = newValues.appButtonState;
        this.homeButtonState = newValues.homeButtonState;
        this.clickButtonState = newValues.clickButtonState;
        this.volumeDownButtonState = newValues.volumeDownButtonState;
        this.volumeUpButtonState = newValues.volumeUpButtonState;
        this.isCharging = newValues.isCharging;
        this.batteryLevelBucket = newValues.batteryLevelBucket;
    }

    boolean setHomeButtonState(boolean down) {
        this.homeButtonState = down;
        if (!this.enableRecenterShim) {
            return false;
        }
        if (this.homeButtonState) {
            this.homeButtonDownTimestamp = this.timestamp;
        } else {
            float[] angles;
            long downtime = this.timestamp - this.homeButtonDownTimestamp;
            if (downtime > 600000000L && Math.abs((angles = this.controllerPoseInSensorSpace.toYawPitchRollDegrees(new float[3]))[1]) < RECENTER_PITCH_BOUNDS_RADIANS) {
                this.setStartFromSensorTransformation();
                return true;
            }
        }
        return false;
    }

    void setOrientationInSensorSpace(float x, float y, float z, float w) {
        this.controllerPoseInSensorSpace.set(x, y, z, w);
        this.orientation.set(this.startFromSensorTransformation);
        this.orientation.multiply(this.controllerPoseInSensorSpace);
    }

    private void setStartFromSensorTransformation() {
        float[] angles = this.controllerPoseInSensorSpace.toYawPitchRollDegrees(new float[3]);
        this.startFromSensorTransformation = new Orientation(0.0f, (float)Math.sin(-angles[0] / 2.0f), 0.0f, (float)Math.cos(angles[0] / 2.0f));
    }

    public static class BatteryLevels {
        public static final int UNKNOWN = 0;
        public static final int CRITICAL_LOW = 1;
        public static final int LOW = 2;
        public static final int MEDIUM = 3;
        public static final int ALMOST_FULL = 4;
        public static final int FULL = 5;

        public static final String toString(int level) {
            switch (level) {
                case 0: {
                    return "UNKNOWN";
                }
                case 1: {
                    return "CRITICAL_LOW";
                }
                case 2: {
                    return "LOW";
                }
                case 3: {
                    return "MEDIUM";
                }
                case 4: {
                    return "ALMOST_FULL";
                }
                case 5: {
                    return "FULL";
                }
            }
            return new StringBuilder(36).append("[UNKNOWN BATTERY LEVEL: ").append(level).append("]").toString();
        }
    }

    public static class ConnectionStates {
        public static final int DISCONNECTED = 0;
        public static final int SCANNING = 1;
        public static final int CONNECTING = 2;
        public static final int CONNECTED = 3;

        private ConnectionStates() {
        }

        public static final String toString(int state) {
            switch (state) {
                case 0: {
                    return "DISCONNECTED";
                }
                case 1: {
                    return "SCANNING";
                }
                case 2: {
                    return "CONNECTING";
                }
                case 3: {
                    return "CONNECTED";
                }
            }
            return new StringBuilder(39).append("[UNKNOWN CONTROLLER STATE: ").append(state).append("]").toString();
        }
    }

    public static class EventListener {
        public void onConnectionStateChanged(int state) {
        }

        public void onUpdate() {
        }
    }
}

