/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.controller;

import android.graphics.PointF;
import android.opengl.Matrix;
import android.util.Log;
import com.google.vr.sdk.controller.Orientation;
import com.google.vr.vrcore.controller.api.ControllerBatteryEvent;
import com.google.vr.vrcore.controller.api.ControllerButtonEvent;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;
import com.google.vr.vrcore.controller.api.ControllerPositionEvent;
import com.google.vr.vrcore.controller.api.ControllerTouchEvent;
import com.google.vr.vrcore.controller.api.ControllerTrackingStatusEvent;

public class Controller {
    private static final String TAG = "Controller";
    private static final boolean DEBUG = false;
    public long timestamp = 0L;
    public final Orientation orientation = new Orientation();
    public final float[] position = new float[3];
    public int trackingStatusFlags = 0;
    public boolean isTouching;
    public final PointF touch = new PointF();
    public boolean clickButtonState;
    public boolean appButtonState;
    public boolean homeButtonState;
    public boolean triggerButtonState;
    public boolean gripButtonState;
    public boolean volumeUpButtonState;
    public boolean volumeDownButtonState;
    public int batteryLevelBucket;
    public boolean isCharging;
    private final int controllerId;
    private final Object controllerStateLock = new Object();
    private final Controller currentControllerState;
    private EventListener controllerEventListener = new EventListener();
    private final Orientation controllerPoseInSensorSpace = new Orientation();
    private Orientation startFromSensorTransformation = new Orientation();

    Controller(int controllerId) {
        this(controllerId, new Controller(-1, null));
    }

    private Controller(int controllerId, Controller currentControllerState) {
        this.controllerId = controllerId;
        this.currentControllerState = currentControllerState;
    }

    public int getControllerId() {
        return this.controllerId;
    }

    public void setEventListener(EventListener listener) {
        this.controllerEventListener = listener;
    }

    public float[] getTransform(float[] output) {
        this.orientation.toAxisAngle(output);
        float x = output[0];
        float y = output[1];
        float z = output[2];
        float degrees = output[3];
        Matrix.setIdentityM((float[])output, (int)0);
        Matrix.translateM((float[])output, (int)0, (float)this.position[0], (float)this.position[1], (float)this.position[2]);
        Matrix.rotateM((float[])output, (int)0, (float)degrees, (float)x, (float)y, (float)z);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object = this.controllerStateLock;
        synchronized (object) {
            if (this.timestamp == this.currentControllerState.timestamp) {
                return;
            }
            this.timestamp = this.currentControllerState.timestamp;
            this.orientation.w = this.currentControllerState.orientation.w;
            this.orientation.x = this.currentControllerState.orientation.x;
            this.orientation.y = this.currentControllerState.orientation.y;
            this.orientation.z = this.currentControllerState.orientation.z;
            this.isTouching = this.currentControllerState.isTouching;
            this.touch.x = this.currentControllerState.touch.x;
            this.touch.y = this.currentControllerState.touch.y;
            System.arraycopy(this.currentControllerState.position, 0, this.position, 0, this.position.length);
            this.trackingStatusFlags = this.currentControllerState.trackingStatusFlags;
            this.appButtonState = this.currentControllerState.appButtonState;
            this.homeButtonState = this.currentControllerState.homeButtonState;
            this.clickButtonState = this.currentControllerState.clickButtonState;
            this.triggerButtonState = this.currentControllerState.triggerButtonState;
            this.gripButtonState = this.currentControllerState.gripButtonState;
            this.volumeDownButtonState = this.currentControllerState.volumeDownButtonState;
            this.volumeUpButtonState = this.currentControllerState.volumeUpButtonState;
            this.isCharging = this.currentControllerState.isCharging;
            this.batteryLevelBucket = this.currentControllerState.batteryLevelBucket;
        }
    }

    void notifyConnectionStateChange(int state) {
        this.controllerEventListener.onConnectionStateChanged(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTouchEvent(ControllerTouchEvent event) {
        Object object = this.controllerStateLock;
        synchronized (object) {
            this.currentControllerState.timestamp = event.timestampNanos;
            this.currentControllerState.touch.x = event.x;
            this.currentControllerState.touch.y = event.y;
            switch (event.action) {
                case 1: 
                case 2: {
                    this.currentControllerState.isTouching = true;
                    break;
                }
                case 0: 
                case 3: 
                case 4: {
                    this.currentControllerState.isTouching = false;
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)String.format(".handleTouchEvent didn't handle %d", event.action));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOrientationEvent(ControllerOrientationEvent event) {
        Object object = this.controllerStateLock;
        synchronized (object) {
            this.currentControllerState.timestamp = event.timestampNanos;
            this.currentControllerState.setOrientationInSensorSpace(event.qx, event.qy, event.qz, event.qw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleButtonEvent(ControllerButtonEvent event) {
        Object object = this.controllerStateLock;
        synchronized (object) {
            this.currentControllerState.timestamp = event.timestampNanos;
            switch (event.button) {
                case 3: {
                    this.currentControllerState.appButtonState = event.down;
                    break;
                }
                case 1: {
                    this.currentControllerState.clickButtonState = event.down;
                    break;
                }
                case 2: {
                    this.currentControllerState.homeButtonState = event.down;
                    break;
                }
                case 7: {
                    this.currentControllerState.triggerButtonState = event.down;
                    break;
                }
                case 8: {
                    this.currentControllerState.gripButtonState = event.down;
                    break;
                }
                case 5: {
                    this.currentControllerState.volumeUpButtonState = event.down;
                    break;
                }
                case 6: {
                    this.currentControllerState.volumeDownButtonState = event.down;
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)String.format("handleButtonEvent didn't handle %d", event.button));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePositionEvent(ControllerPositionEvent event) {
        Object object = this.controllerStateLock;
        synchronized (object) {
            this.currentControllerState.timestamp = event.timestampNanos;
            this.currentControllerState.position[0] = event.x;
            this.currentControllerState.position[1] = event.y;
            this.currentControllerState.position[2] = event.z;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTrackingStatusEvent(ControllerTrackingStatusEvent event) {
        Object object = this.controllerStateLock;
        synchronized (object) {
            this.currentControllerState.timestamp = event.timestampNanos;
            this.currentControllerState.trackingStatusFlags = event.trackingStatusFlags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBatteryEvent(ControllerBatteryEvent event) {
        Object object = this.controllerStateLock;
        synchronized (object) {
            this.currentControllerState.isCharging = event.charging;
            switch (event.batteryLevelBucket) {
                case 0: {
                    this.currentControllerState.batteryLevelBucket = 0;
                    break;
                }
                case 1: {
                    this.currentControllerState.batteryLevelBucket = 1;
                    break;
                }
                case 2: {
                    this.currentControllerState.batteryLevelBucket = 2;
                    break;
                }
                case 3: {
                    this.currentControllerState.batteryLevelBucket = 3;
                    break;
                }
                case 4: {
                    this.currentControllerState.batteryLevelBucket = 4;
                    break;
                }
                case 5: {
                    this.currentControllerState.batteryLevelBucket = 5;
                    break;
                }
                default: {
                    this.currentControllerState.batteryLevelBucket = 0;
                }
            }
        }
    }

    void notifyClient() {
        this.controllerEventListener.onUpdate();
    }

    private void setOrientationInSensorSpace(float x, float y, float z, float w) {
        this.controllerPoseInSensorSpace.set(x, y, z, w);
        this.orientation.set(this.startFromSensorTransformation);
        this.orientation.multiply(this.controllerPoseInSensorSpace);
    }

    public static class BetaTrackingStatusFlags {
        public static final int UNKNOWN = 1;
        public static final int NOMINAL = 2;
        public static final int OCCLUDED = 4;
        public static final int OUT_OF_FOV = 8;
    }

    public static class BatteryLevels {
        public static final int UNKNOWN = 0;
        public static final int CRITICAL_LOW = 1;
        public static final int LOW = 2;
        public static final int MEDIUM = 3;
        public static final int ALMOST_FULL = 4;
        public static final int FULL = 5;

        public static final String toString(int level) {
            switch (level) {
                case 0: {
                    return "UNKNOWN";
                }
                case 1: {
                    return "CRITICAL_LOW";
                }
                case 2: {
                    return "LOW";
                }
                case 3: {
                    return "MEDIUM";
                }
                case 4: {
                    return "ALMOST_FULL";
                }
                case 5: {
                    return "FULL";
                }
            }
            return new StringBuilder(36).append("[UNKNOWN BATTERY LEVEL: ").append(level).append("]").toString();
        }
    }

    public static class ConnectionStates {
        public static final int DISCONNECTED = 0;
        public static final int SCANNING = 1;
        public static final int CONNECTING = 2;
        public static final int CONNECTED = 3;

        private ConnectionStates() {
        }

        public static final String toString(int state) {
            switch (state) {
                case 0: {
                    return "DISCONNECTED";
                }
                case 1: {
                    return "SCANNING";
                }
                case 2: {
                    return "CONNECTING";
                }
                case 3: {
                    return "CONNECTED";
                }
            }
            return new StringBuilder(39).append("[UNKNOWN CONTROLLER STATE: ").append(state).append("]").toString();
        }
    }

    public static class EventListener {
        public void onConnectionStateChanged(int state) {
        }

        public void onUpdate() {
        }
    }
}

