/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.google.vrtoolkit.cardboard.SensorReadingStats;

public class ScreenOnFlagHelper
implements SensorEventListener {
    private static final String TAG = "ScreenOnFlagHelper";
    private static final boolean DEBUG = false;
    private static final long IDLE_TIMEOUT_MS = 30000L;
    private static final long SAMPLE_INTERVAL_MS = 250L;
    private static final int NUM_SAMPLES = 120;
    private static final float SENSOR_THRESHOLD = 0.2f;
    private boolean screenAlwaysOn = false;
    private Activity activity;
    private SensorReadingStats sensorStats = new SensorReadingStats(120, 3);
    private long lastSampleTimestamp = 0L;
    private boolean isFlagSet = false;
    private SensorManager sensorManager;
    private Sensor sensor;

    public ScreenOnFlagHelper(Activity activity) {
        this.activity = activity;
    }

    void setSensorManager(SensorManager sensorManager) {
        this.sensorManager = sensorManager;
    }

    public void setScreenAlwaysOn(boolean bl) {
        this.screenAlwaysOn = bl;
        this.updateFlag();
    }

    public void start() {
        if (this.sensorManager == null) {
            this.sensorManager = (SensorManager)this.activity.getSystemService("sensor");
        }
        if (this.sensor == null) {
            this.sensor = this.sensorManager.getDefaultSensor(1);
        }
        this.isFlagSet = false;
        this.setKeepScreenOnFlag(true);
        this.sensorStats.reset();
        this.sensorManager.registerListener((SensorEventListener)this, this.sensor, 250000);
    }

    public void stop() {
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
        this.setKeepScreenOnFlag(false);
    }

    public void onAccuracyChanged(Sensor sensor, int n) {
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        long l = (sensorEvent.timestamp - this.lastSampleTimestamp) / 1000000L;
        if (l < 250L) {
            return;
        }
        this.sensorStats.addSample(sensorEvent.values);
        this.lastSampleTimestamp = sensorEvent.timestamp;
        this.updateFlag();
    }

    private void updateFlag() {
        if (this.screenAlwaysOn || !this.sensorStats.statsAvailable()) {
            this.setKeepScreenOnFlag(true);
            return;
        }
        float f = this.sensorStats.getMaxAbsoluteDeviation();
        this.setKeepScreenOnFlag(f > 0.2f);
    }

    private void setKeepScreenOnFlag(boolean bl) {
        if (bl == this.isFlagSet) {
            return;
        }
        if (bl) {
            this.activity.getWindow().addFlags(128);
        } else {
            this.activity.getWindow().clearFlags(128);
        }
        this.isFlagSet = bl;
    }
}

