/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.performance.api;

import android.content.ComponentName;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.vr.vrcore.performance.api.IThrottlingTriggerCallback;
import com.google.vr.vrcore.performance.api.TimestampedTemperature;

public interface IPerformanceService
extends IInterface {
    public void getCurrentThrottlingRelativeTemperature(TimestampedTemperature var1) throws RemoteException;

    public long getCurrentEstimatedThrottleWarningTime() throws RemoteException;

    public void addTrigger(ComponentName var1, IThrottlingTriggerCallback var2, long var3, float var5, int var6) throws RemoteException;

    public void removeAllTriggers(ComponentName var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPerformanceService {
        private static final String DESCRIPTOR = "com.google.vr.vrcore.performance.api.IPerformanceService";
        static final int TRANSACTION_getCurrentThrottlingRelativeTemperature = 1;
        static final int TRANSACTION_getCurrentEstimatedThrottleWarningTime = 2;
        static final int TRANSACTION_addTrigger = 3;
        static final int TRANSACTION_removeAllTriggers = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPerformanceService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IPerformanceService) {
                return (IPerformanceService)iInterface;
            }
            return new Proxy(iBinder);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    TimestampedTemperature timestampedTemperature = new TimestampedTemperature();
                    this.getCurrentThrottlingRelativeTemperature(timestampedTemperature);
                    parcel2.writeNoException();
                    parcel2.writeInt(1);
                    timestampedTemperature.writeToParcel(parcel2, 1);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = this.getCurrentEstimatedThrottleWarningTime();
                    parcel2.writeNoException();
                    parcel2.writeLong(l);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = 0 != parcel.readInt() ? (ComponentName)ComponentName.CREATOR.createFromParcel(parcel) : null;
                    IThrottlingTriggerCallback iThrottlingTriggerCallback = IThrottlingTriggerCallback.Stub.asInterface(parcel.readStrongBinder());
                    long l = parcel.readLong();
                    float f = parcel.readFloat();
                    int n3 = parcel.readInt();
                    this.addTrigger(componentName, iThrottlingTriggerCallback, l, f, n3);
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = 0 != parcel.readInt() ? (ComponentName)ComponentName.CREATOR.createFromParcel(parcel) : null;
                    this.removeAllTriggers(componentName);
                    parcel2.writeNoException();
                    return true;
                }
            }
            return super.onTransact(n, parcel, parcel2, n2);
        }

        private static class Proxy
        implements IPerformanceService {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void getCurrentThrottlingRelativeTemperature(TimestampedTemperature timestampedTemperature) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    if (0 != parcel2.readInt()) {
                        timestampedTemperature.readFromParcel(parcel2);
                    }
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public long getCurrentEstimatedThrottleWarningTime() throws RemoteException {
                long l;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    l = parcel2.readLong();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return l;
            }

            @Override
            public void addTrigger(ComponentName componentName, IThrottlingTriggerCallback iThrottlingTriggerCallback, long l, float f, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(iThrottlingTriggerCallback != null ? iThrottlingTriggerCallback.asBinder() : null);
                    parcel.writeLong(l);
                    parcel.writeFloat(f);
                    parcel.writeInt(n);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removeAllTriggers(ComponentName componentName) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

