/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.animation.AnimationUtils;

class FadeOverlayView
extends View {
    private static final String TAG = "FadeOverlayView";
    private static final boolean DEBUG = true;
    private static final int MSG_AUTO_FADE = 77337733;
    private static final int BACKGROUND_COLOR = -16777216;
    static final long AUTO_FADE_DURATION_MILLIS = 350L;
    static final long AUTO_FADE_START_DELAY_MILLIS = 1000L;
    private int fadeType = 0;
    private long fadeStartTimeMillis;
    private long fadeDurationMillis;
    private boolean visible;
    private final Runnable fadeUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            FadeOverlayView.this.updateFade();
        }
    };
    private final Handler autoFadeHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message message) {
            if (message.what == 77337733) {
                FadeOverlayView.this.startFade(1, 350L);
                return;
            }
            super.handleMessage(message);
        }
    };

    public FadeOverlayView(Context context) {
        super(context);
        this.setBackgroundColor(-16777216);
    }

    public void startFade(int n, long l) {
        Log.d((String)TAG, (String)new StringBuilder(23).append(".startFade: ").append(n).toString());
        if (!this.isEnabled()) {
            Log.w((String)TAG, (String)"Ignoring fade request while disabled.");
            return;
        }
        if (!this.visible) {
            Log.w((String)TAG, (String)"Ignoring fade request while invisible.");
            return;
        }
        this.removeFadeCallbacks();
        this.fadeType = n;
        this.fadeDurationMillis = l;
        this.fadeStartTimeMillis = AnimationUtils.currentAnimationTimeMillis();
        this.updateFade();
    }

    public void onInvisible() {
        if (!this.visible) {
            return;
        }
        this.visible = false;
        if (this.isEnabled()) {
            this.removeFadeCallbacks();
            this.fadeType = 2;
            this.endFade();
        }
    }

    public void onVisible() {
        if (this.visible && this.getAlpha() == 0.0f) {
            return;
        }
        this.visible = true;
        if (this.isEnabled()) {
            this.autoFadeHandler.removeMessages(77337733);
            this.autoFadeHandler.sendEmptyMessageDelayed(77337733, 1000L);
        }
    }

    public void flushAutoFade(long l) {
        Log.d((String)TAG, (String)".flushAutoFade");
        if (this.autoFadeHandler.hasMessages(77337733)) {
            this.autoFadeHandler.removeMessages(77337733);
            this.autoFadeHandler.sendEmptyMessageDelayed(77337733, l);
        }
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        if (!bl) {
            this.removeFadeCallbacks();
            this.fadeType = 1;
            this.endFade();
        }
    }

    int getFadeType() {
        return this.fadeType;
    }

    boolean isVisible() {
        return this.visible;
    }

    private void removeFadeCallbacks() {
        this.autoFadeHandler.removeMessages(77337733);
        this.removeCallbacks(this.fadeUpdateRunnable);
    }

    private void endFade() {
        if (this.fadeType == 0) {
            return;
        }
        this.setVisibility(this.fadeType == 2 ? 0 : 8);
        this.setAlpha(this.fadeType == 2 ? 1.0f : 0.0f);
        this.removeCallbacks(this.fadeUpdateRunnable);
        this.fadeType = 0;
        Log.d((String)TAG, (String)".endFade");
    }

    private void updateFade() {
        long l = AnimationUtils.currentAnimationTimeMillis() - this.fadeStartTimeMillis;
        float f = (float)l / (float)this.fadeDurationMillis;
        float f2 = this.fadeType == 2 ? f : 1.0f - f;
        this.setAlpha(Math.min(Math.max(f2, 0.0f), 1.0f));
        if (l < this.fadeDurationMillis && this.getVisibility() != 0) {
            this.setVisibility(0);
        }
        if (l < this.fadeDurationMillis) {
            this.postOnAnimation(this.fadeUpdateRunnable);
            return;
        }
        this.endFade();
    }
}

