/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.cardboard.VrParamsProviderFactory;
import com.google.vr.cardboard.VrSettingsProviderContract;
import com.google.vr.cardboard.annotations.UsedByReflection;
import com.google.vr.ndk.base.DaydreamUtils;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;
import com.google.vr.vrcore.base.api.VrCoreUtils;
import com.google.vr.vrcore.common.api.IDaydreamManager;
import com.google.vr.vrcore.common.api.ITransitionCallbacks;
import com.google.vr.vrcore.common.api.IVrCoreSdkService;
import com.google.vrtoolkit.cardboard.proto.nano.CardboardDevice;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=24)
@UsedByReflection(value="IAP")
public class DaydreamApi
implements AutoCloseable {
    private static final String TAG = DaydreamApi.class.getSimpleName();
    private static final int MIN_VRCORE_API_VERSION = 8;
    private static final int MIN_API_FOR_HEADSET_INSERTION = 11;
    private static final String DAYDREAM_CATEGORY = "com.google.intent.category.DAYDREAM";
    private IVrCoreSdkService vrCoreSdkService;
    private IDaydreamManager daydreamManager;
    private final Context context;
    private boolean closed;
    private ArrayList<Runnable> queuedRunnables = new ArrayList();
    private int vrCoreApiVersion;
    private final ServiceConnection connection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            DaydreamApi.this.vrCoreSdkService = IVrCoreSdkService.Stub.asInterface(iBinder);
            try {
                DaydreamApi.this.daydreamManager = DaydreamApi.this.vrCoreSdkService.getDaydreamManager();
            }
            catch (RemoteException remoteException) {
                Log.e((String)TAG, (String)"RemoteException in onServiceConnected");
            }
            if (DaydreamApi.this.daydreamManager == null) {
                Log.w((String)TAG, (String)"Daydream service component unavailable.");
            }
            ArrayList arrayList = DaydreamApi.this.queuedRunnables;
            int n = arrayList.size();
            Object var3_6 = null;
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                Runnable runnable = (Runnable)e;
                runnable.run();
            }
            DaydreamApi.this.queuedRunnables.clear();
        }

        public void onServiceDisconnected(ComponentName componentName) {
            DaydreamApi.this.vrCoreSdkService = null;
        }
    };

    @UsedByReflection(value="IAP")
    public static DaydreamApi create(Context context) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new IllegalStateException("DaydreamApi must only be used from the main thread.");
        }
        if (!DaydreamUtils.isDaydreamPhone(context)) {
            Log.i((String)TAG, (String)"Phone is not Daydream-compatible");
            return null;
        }
        DaydreamApi daydreamApi = new DaydreamApi(context);
        if (daydreamApi.init()) {
            return daydreamApi;
        }
        Log.w((String)TAG, (String)"Failed to initialize DaydreamApi object.");
        return null;
    }

    public static boolean isDaydreamReadyPlatform(Context context) {
        return DaydreamUtils.isDaydreamPhone(context);
    }

    public int getCurrentViewerType() {
        this.checkNotClosed();
        if (!DaydreamApi.isDaydreamReadyPlatform(this.context)) {
            return 0;
        }
        try (VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create(this.context);){
            CardboardDevice.DeviceParams deviceParams = vrParamsProvider.readDeviceParams();
            if (deviceParams == null) {
                return 0;
            }
            if (DaydreamUtils.isDaydreamViewer(deviceParams)) {
                return 1;
            }
            return 0;
        }
    }

    public void registerDaydreamIntent(final PendingIntent pendingIntent) {
        this.checkNotClosed();
        this.runWhenServiceConnected(new Runnable(){

            @Override
            public void run() {
                if (DaydreamApi.this.daydreamManager == null) {
                    Log.w((String)TAG, (String)"Can't register/unregister daydream intent: no DaydreamManager.");
                    return;
                }
                try {
                    if (pendingIntent == null) {
                        DaydreamApi.this.daydreamManager.unregisterDaydreamIntent();
                        return;
                    }
                    DaydreamApi.this.daydreamManager.registerDaydreamIntent(pendingIntent);
                }
                catch (RemoteException remoteException) {
                    Log.e((String)TAG, (String)"Error when attempting to register/unregister daydream intent: ", (Throwable)remoteException);
                }
            }
        });
    }

    public void unregisterDaydreamIntent() {
        this.checkNotClosed();
        this.registerDaydreamIntent(null);
    }

    public static boolean setDaydreamSetupCompleted(Context context, boolean bl) {
        VrParamsProviderFactory.ContentProviderClientHandle contentProviderClientHandle = VrParamsProviderFactory.tryToGetContentProviderClientHandle(context);
        if (contentProviderClientHandle == null) {
            Log.e((String)TAG, (String)"No ContentProvider available for Daydream setup.");
            return false;
        }
        Uri uri = VrSettingsProviderContract.createUri(contentProviderClientHandle.authority, "daydream_setup");
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("value", Boolean.valueOf(bl));
            int n = contentProviderClientHandle.client.update(uri, contentValues, null, null);
            return n > 0;
        }
        catch (RemoteException remoteException) {
            Log.e((String)TAG, (String)"Failed to indicate Daydream setup completion to ContentProvider", (Throwable)remoteException);
            return false;
        }
        catch (SecurityException securityException) {
            Log.e((String)TAG, (String)"Insufficient permissions to indicate Daydream setup completion to ContentProvider", (Throwable)securityException);
            return false;
        }
    }

    public static boolean getDaydreamSetupCompleted(Context context) {
        VrParamsProviderFactory.ContentProviderClientHandle contentProviderClientHandle = VrParamsProviderFactory.tryToGetContentProviderClientHandle(context);
        if (contentProviderClientHandle == null) {
            Log.e((String)TAG, (String)"No ContentProvider available for Daydream setup.");
            return false;
        }
        Uri uri = VrSettingsProviderContract.createUri(contentProviderClientHandle.authority, "daydream_setup");
        try (Cursor cursor = null;){
            cursor = contentProviderClientHandle.client.query(uri, null, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                boolean bl = cursor.getInt(0) == 1;
                return bl;
            }
            return false;
        }
    }

    @UsedByReflection(value="IAP")
    public void launchInVr(PendingIntent pendingIntent) {
        this.checkNotClosed();
        this.launchInVr(pendingIntent, null);
    }

    private void launchInVr(final PendingIntent pendingIntent, final ComponentName componentName) {
        this.runWhenServiceConnected(new Runnable(){

            @Override
            public void run() {
                if (DaydreamApi.this.daydreamManager != null) {
                    try {
                        DaydreamApi.this.daydreamManager.launchInVr(pendingIntent, componentName);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)TAG, (String)"RemoteException while launching PendingIntent in VR.", (Throwable)remoteException);
                        return;
                    }
                }
                Log.w((String)TAG, (String)"Can't launch PendingIntent via DaydreamManager: not available.");
                try {
                    pendingIntent.send();
                    return;
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)"Couldn't launch PendingIntent: ", (Throwable)exception);
                    return;
                }
            }
        });
    }

    private void launchTransitionCallbackInVr(final ITransitionCallbacks iTransitionCallbacks) {
        this.runWhenServiceConnected(new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                if (DaydreamApi.this.daydreamManager != null) {
                    try {
                        bl = DaydreamApi.this.daydreamManager.launchVrTransition(iTransitionCallbacks);
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)TAG, (String)"RemoteException while launching VR transition: ", (Throwable)remoteException);
                    }
                }
                if (!bl) {
                    Log.w((String)TAG, (String)"Can't launch callbacks via DaydreamManager, sending manually");
                    try {
                        iTransitionCallbacks.onTransitionComplete();
                        return;
                    }
                    catch (RemoteException remoteException) {}
                }
            }
        });
    }

    @UsedByReflection(value="IAP")
    public void launchVrHomescreen() {
        this.checkNotClosed();
        this.runWhenServiceConnected(new Runnable(){

            @Override
            public void run() {
                if (DaydreamApi.this.daydreamManager == null) {
                    Log.e((String)TAG, (String)"Can't launch VR homescreen via DaydreamManager. Giving up trying to leave current VR activity...");
                    return;
                }
                try {
                    if (DaydreamApi.this.daydreamManager.launchVrHome()) {
                        return;
                    }
                    Log.e((String)TAG, (String)"There is no VR homescreen installed.");
                    return;
                }
                catch (RemoteException remoteException) {
                    String string2 = String.valueOf((Object)remoteException);
                    Log.e((String)TAG, (String)new StringBuilder(47 + String.valueOf(string2).length()).append("RemoteException while launching VR homescreen: ").append(string2).toString());
                    return;
                }
            }
        });
    }

    @UsedByReflection(value="IAP")
    public void launchInVr(Intent intent) throws ActivityNotFoundException {
        this.checkNotClosed();
        if (intent == null) {
            throw new IllegalArgumentException("Null argument 'intent' passed to launchInVr");
        }
        this.checkIntent(intent);
        this.launchInVr(PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent, (int)0x48000000), intent.getComponent());
    }

    @UsedByReflection(value="IAP")
    public void launchInVr(ComponentName componentName) throws ActivityNotFoundException {
        this.checkNotClosed();
        if (componentName == null) {
            throw new IllegalArgumentException("Null argument 'componentName' passed to launchInVr");
        }
        Intent intent = DaydreamApi.createVrIntent(componentName);
        this.checkIntent(intent);
        this.launchInVr(PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent, (int)0x40000000), intent.getComponent());
    }

    @UsedByReflection(value="IAP")
    public void launchInVrForResult(final Activity activity, final PendingIntent pendingIntent, final int n) {
        this.checkNotClosed();
        ITransitionCallbacks.Stub stub = new ITransitionCallbacks.Stub(this){

            @Override
            public void onTransitionComplete() {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            activity.startIntentSenderForResult(pendingIntent.getIntentSender(), n, null, 0, 0, 0);
                            return;
                        }
                        catch (IntentSender.SendIntentException sendIntentException) {
                            String string2 = String.valueOf((Object)sendIntentException);
                            Log.e((String)TAG, (String)new StringBuilder(43 + String.valueOf(string2).length()).append("Exception while starting next VR activity: ").append(string2).toString());
                            return;
                        }
                    }
                });
            }
        };
        this.launchTransitionCallbackInVr(stub);
    }

    @UsedByReflection(value="IAP")
    public static Intent createVrIntent(ComponentName componentName) {
        Intent intent = new Intent();
        intent.setComponent(componentName);
        return DaydreamApi.setupVrIntent(intent);
    }

    @UsedByReflection(value="IAP")
    public static Intent setupVrIntent(Intent intent) {
        intent.addCategory(DAYDREAM_CATEGORY);
        intent.addFlags(0x14010000);
        return intent;
    }

    @UsedByReflection(value="IAP")
    public void exitFromVr(Activity activity, int n, Intent intent) {
        this.checkNotClosed();
        if (intent == null) {
            intent = new Intent();
        }
        final PendingIntent pendingIntent = activity.createPendingResult(n, intent, 0x40000000);
        final Runnable runnable = new Runnable(this){

            @Override
            public void run() {
                try {
                    pendingIntent.send(0);
                    return;
                }
                catch (Exception exception) {
                    String string2 = String.valueOf(exception);
                    Log.e((String)TAG, (String)new StringBuilder(31 + String.valueOf(string2).length()).append("Couldn't launch PendingIntent: ").append(string2).toString());
                    return;
                }
            }
        };
        this.runWhenServiceConnected(new Runnable(){

            @Override
            public void run() {
                if (DaydreamApi.this.daydreamManager == null) {
                    Log.w((String)TAG, (String)"Failed to exit VR: Daydream service unavailable.");
                    runnable.run();
                    return;
                }
                try {
                    if (!DaydreamApi.this.daydreamManager.exitFromVr(pendingIntent)) {
                        Log.w((String)TAG, (String)"Failed to exit VR: Invalid request.");
                        runnable.run();
                    }
                    return;
                }
                catch (RemoteException remoteException) {
                    String string2 = String.valueOf((Object)remoteException);
                    Log.e((String)TAG, (String)new StringBuilder(49 + String.valueOf(string2).length()).append("Failed to exit VR: RemoteException while exiting:").append(string2).toString());
                    runnable.run();
                    return;
                }
            }
        });
    }

    public void setInhibitSystemButtons(final ComponentName componentName, final boolean bl) {
        this.checkNotClosed();
        this.runWhenServiceConnected(new Runnable(){

            @Override
            public void run() {
                try {
                    Bundle bundle = new Bundle();
                    bundle.putBoolean("OPTION_INHIBIT_SYSTEM_BUTTONS", bl);
                    if (!DaydreamApi.this.vrCoreSdkService.setClientOptions(componentName, bundle)) {
                        Log.w((String)TAG, (String)"Failed to set client options to inhibit system button.");
                    }
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e((String)TAG, (String)"RemoteException while setting client options.", (Throwable)remoteException);
                    return;
                }
            }
        });
    }

    public void handleInsertionIntoHeadset(final byte[] byArray) {
        this.runWhenServiceConnected(new Runnable(){

            @Override
            public void run() {
                if (DaydreamApi.this.vrCoreApiVersion < 11) {
                    String string2 = String.valueOf("Can't handle insertion of phone into headset: VrCore API too old. Need: 11, found: ");
                    int n = DaydreamApi.this.vrCoreApiVersion;
                    Log.e((String)TAG, (String)new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(n).toString());
                    return;
                }
                if (DaydreamApi.this.daydreamManager == null) {
                    Log.e((String)TAG, (String)"Can't handle insertion of phone into headset: no DaydreamManager.");
                    return;
                }
                try {
                    DaydreamApi.this.daydreamManager.handleInsertionIntoHeadset(byArray);
                    return;
                }
                catch (SecurityException securityException) {
                    Log.e((String)TAG, (String)"SecurityException when notifying phone insertion. Check that the calling app is in the system image (must have the SYSTEM flag in package manager).", (Throwable)securityException);
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e((String)TAG, (String)"RemoteException while notifying phone insertion.", (Throwable)remoteException);
                    return;
                }
            }
        });
    }

    public void handleRemovalFromHeadset() {
        this.runWhenServiceConnected(new Runnable(){

            @Override
            public void run() {
                if (DaydreamApi.this.vrCoreApiVersion < 11) {
                    String string2 = String.valueOf("Can't handle removal of phone from headset: VrCore API too old. Need: 11, found: ");
                    int n = DaydreamApi.this.vrCoreApiVersion;
                    Log.e((String)TAG, (String)new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(n).toString());
                    return;
                }
                if (DaydreamApi.this.daydreamManager == null) {
                    Log.e((String)TAG, (String)"Can't handle removal of phone from headset: no DaydreamManager.");
                    return;
                }
                try {
                    DaydreamApi.this.daydreamManager.handleRemovalFromHeadset();
                    return;
                }
                catch (SecurityException securityException) {
                    Log.e((String)TAG, (String)"SecurityException when notifying phone removal. Check that the calling app is in the system image (must have the SYSTEM flag in package manager).", (Throwable)securityException);
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e((String)TAG, (String)"RemoteException while notifying phone removal.", (Throwable)remoteException);
                    return;
                }
            }
        });
    }

    @Override
    @UsedByReflection(value="IAP")
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.runWhenServiceConnected(new Runnable(){

            @Override
            public void run() {
                DaydreamApi.this.context.unbindService(DaydreamApi.this.connection);
                DaydreamApi.this.vrCoreSdkService = null;
            }
        });
    }

    private DaydreamApi(Context context) {
        this.context = context;
    }

    private boolean init() {
        try {
            this.vrCoreApiVersion = VrCoreUtils.getVrCoreClientApiVersion(this.context);
            if (this.vrCoreApiVersion < 8) {
                int n = this.vrCoreApiVersion;
                Log.e((String)TAG, (String)new StringBuilder(79).append("VrCore out of date, current version: ").append(n).append(", required version: 8").toString());
                return false;
            }
            Intent intent = new Intent("com.google.vr.vrcore.BIND_SDK_SERVICE");
            intent.setPackage("com.google.vr.vrcore");
            if (this.context.bindService(intent, this.connection, 1)) {
                return true;
            }
            Log.e((String)TAG, (String)"Unable to bind to VrCoreSdkService");
        }
        catch (VrCoreNotAvailableException vrCoreNotAvailableException) {
            String string2 = String.valueOf(vrCoreNotAvailableException);
            Log.e((String)TAG, (String)new StringBuilder(22 + String.valueOf(string2).length()).append("VrCore not available: ").append(string2).toString());
        }
        return false;
    }

    private void runWhenServiceConnected(Runnable runnable) {
        if (this.vrCoreSdkService != null) {
            runnable.run();
            return;
        }
        this.queuedRunnables.add(runnable);
    }

    private void checkIntent(Intent intent) throws ActivityNotFoundException {
        PackageManager packageManager = this.context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 0);
        if (list == null || list.isEmpty()) {
            String string2 = String.valueOf(intent);
            throw new ActivityNotFoundException(new StringBuilder(43 + String.valueOf(string2).length()).append("No activity is available to handle intent: ").append(string2).toString());
        }
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("DaydreamApi object is closed and can no longer be used.");
        }
    }
}

