/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.google.vr.cardboard.UsedByNative;
import com.google.vr.ndk.base.Version;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;
import com.google.vr.vrcore.base.api.VrCoreUtils;
import com.google.vr.vrcore.library.api.IVrCreator;
import com.google.vr.vrcore.library.api.IVrNativeLibraryLoader;
import com.google.vr.vrcore.library.api.ObjectWrapper;
import com.google.vr.vrcore.library.api.VrCoreLoader;

@UsedByNative
public class VrCoreLibraryLoader {
    private static final String TAG = VrCoreLibraryLoader.class.getSimpleName();

    public static void checkVrCoreGvrLibraryAvailable(Context context) throws VrCoreNotAvailableException {
        VrCoreLibraryLoader.checkVrCoreGvrLibraryAvailable(context, Version.CURRENT);
    }

    @UsedByNative
    public static long loadNativeGvrLibrary(Context context, int n, int n2, int n3) {
        try {
            Version version = new Version(n, n2, n3);
            if (!Version.CURRENT.equals(version)) {
                Log.w((String)TAG, (String)String.format("Native SDK version does not match Java; expected %s but received %s", Version.CURRENT, version.toString()));
            }
            VrCoreLibraryLoader.checkVrCoreGvrLibraryAvailable(context, version);
            Context context2 = VrCoreLoader.getRemoteContext(context);
            IVrCreator iVrCreator = VrCoreLoader.getRemoteCreator(context);
            IVrNativeLibraryLoader iVrNativeLibraryLoader = iVrCreator.newNativeLibraryLoader(ObjectWrapper.wrap(context2), ObjectWrapper.wrap(context));
            if (iVrNativeLibraryLoader == null) {
                Log.e((String)TAG, (String)"Failed to load native GVR library from VrCore: no library loader available.");
                return 0L;
            }
            return iVrNativeLibraryLoader.loadNativeGvrLibrary(version.majorVersion, version.minorVersion, version.patchVersion);
        }
        catch (RemoteException | VrCoreNotAvailableException | IllegalArgumentException | IllegalStateException | SecurityException | UnsatisfiedLinkError throwable) {
            String string2 = String.valueOf(throwable);
            Log.e((String)TAG, (String)new StringBuilder(49 + String.valueOf(string2).length()).append("Failed to load native GVR library from VrCore:\n  ").append(string2).toString());
            return 0L;
        }
    }

    private static void checkVrCoreGvrLibraryAvailable(Context context, Version version) throws VrCoreNotAvailableException {
        String string2 = VrCoreUtils.getVrCoreSdkLibraryVersion(context);
        Version version2 = Version.parse(string2);
        if (version2 == null) {
            Log.i((String)TAG, (String)"VrCore version does not support library loading.");
            throw new VrCoreNotAvailableException(4);
        }
        if (!version2.isAtLeast(version)) {
            Log.w((String)TAG, (String)String.format("VrCore GVR library version obsolete; VrCore supports %s but target version is %s", string2, version.toString()));
            throw new VrCoreNotAvailableException(4);
        }
    }
}

