/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import com.google.vr.cardboard.R;
import com.google.vr.cardboard.ThreadUtils;
import com.google.vr.cardboard.TransitionView;
import com.google.vr.cardboard.UiUtils;

public class UiLayer {
    private final Context context;
    private ImageButton settingsButton;
    private ImageButton backButton;
    private RelativeLayout alignmentMarker;
    private TransitionView transitionView;
    private RelativeLayout rootLayout;
    private volatile boolean isSettingsButtonEnabled = true;
    private volatile boolean isAlignmentMarkerEnabled = true;
    private volatile Runnable backButtonRunnable = null;
    private volatile Runnable settingsButtonRunnable;
    private volatile boolean transitionViewEnabled = false;
    private volatile String viewerName;

    public UiLayer(Context context) {
        this.context = context;
        this.initializeViewsWithLayoutId(R.layout.ui_layer);
    }

    public void setPortraitSupportEnabled(boolean bl) {
        this.initializeViewsWithLayoutId(bl ? R.layout.ui_layer_with_portrait_support : R.layout.ui_layer);
    }

    private void initializeViewsWithLayoutId(int n) {
        this.rootLayout = (RelativeLayout)LayoutInflater.from((Context)this.context).inflate(n, null, false);
        this.settingsButtonRunnable = new Runnable(){

            @Override
            public void run() {
                UiUtils.launchOrInstallCardboard(UiLayer.this.context);
            }
        };
        this.settingsButton = (ImageButton)this.rootLayout.findViewById(R.id.ui_settings_button);
        this.settingsButton.setVisibility(UiLayer.computeVisibility(this.isSettingsButtonEnabled));
        this.settingsButton.setContentDescription((CharSequence)"Settings");
        this.settingsButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Runnable runnable = UiLayer.this.settingsButtonRunnable;
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        this.backButton = (ImageButton)this.rootLayout.findViewById(R.id.ui_back_button);
        this.backButton.setVisibility(UiLayer.computeVisibility(this.getBackButtonEnabled()));
        this.backButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Runnable runnable = UiLayer.this.backButtonRunnable;
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        this.alignmentMarker = (RelativeLayout)this.rootLayout.findViewById(R.id.ui_alignment_marker);
        this.alignmentMarker.setVisibility(UiLayer.computeVisibility(this.getAlignmentMarkerEnabled()));
    }

    private TransitionView getTransitionView() {
        if (this.transitionView == null) {
            this.transitionView = new TransitionView(this.context);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            this.transitionView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.transitionView.setVisibility(UiLayer.computeVisibility(this.transitionViewEnabled));
            if (this.viewerName != null) {
                this.transitionView.setViewerName(this.viewerName);
            }
            this.transitionView.setBackButtonListener(this.backButtonRunnable);
            this.rootLayout.addView((View)this.transitionView);
        }
        return this.transitionView;
    }

    private static int computeVisibility(boolean bl) {
        if (bl) {
            return 0;
        }
        return 8;
    }

    public View getView() {
        return this.rootLayout;
    }

    public void setEnabled(final boolean bl) {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                UiLayer.this.rootLayout.setVisibility(UiLayer.computeVisibility(bl));
            }
        });
    }

    public void setSettingsButtonEnabled(final boolean bl) {
        this.isSettingsButtonEnabled = bl;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                UiLayer.this.settingsButton.setVisibility(UiLayer.computeVisibility(bl));
            }
        });
    }

    public void setSettingsButtonRunnable(Runnable runnable) {
        this.settingsButtonRunnable = runnable;
    }

    public void setBackButtonListener(final Runnable runnable) {
        this.backButtonRunnable = runnable;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                boolean bl = runnable != null;
                UiLayer.this.backButton.setVisibility(UiLayer.computeVisibility(bl));
                if (UiLayer.this.transitionView != null) {
                    UiLayer.this.transitionView.setBackButtonListener(runnable);
                }
            }
        });
    }

    public void setAlignmentMarkerEnabled(final boolean bl) {
        this.isAlignmentMarkerEnabled = bl;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                UiLayer.this.alignmentMarker.setVisibility(UiLayer.computeVisibility(bl));
            }
        });
    }

    @TargetApi(value=23)
    public void setAlignmentMarkerScale(final float f) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)UiLayer.this.alignmentMarker.getLayoutParams();
                int n = (int)UiLayer.this.context.getResources().getDimension(R.dimen.alignment_marker_height);
                int n2 = (int)((float)n * f);
                if (layoutParams.getRule(15) == -1) {
                    layoutParams.width = n2;
                } else {
                    layoutParams.height = n2;
                }
                UiLayer.this.alignmentMarker.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        });
    }

    public void setTransitionViewEnabled(final boolean bl) {
        this.transitionViewEnabled = bl;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!bl && UiLayer.this.transitionView == null) {
                    return;
                }
                UiLayer.this.getTransitionView().setVisibility(UiLayer.computeVisibility(bl));
            }
        });
    }

    public boolean getTransitionViewEnabled() {
        return this.transitionViewEnabled;
    }

    public void setTransitionViewListener(final TransitionView.TransitionListener transitionListener) {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (transitionListener == null && UiLayer.this.transitionView == null) {
                    return;
                }
                UiLayer.this.getTransitionView().setTransitionListener(transitionListener);
            }
        });
    }

    public void setViewerName(final String string2) {
        this.viewerName = string2;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (UiLayer.this.transitionView != null) {
                    UiLayer.this.transitionView.setViewerName(string2);
                }
            }
        });
    }

    public String getViewerName() {
        return this.viewerName;
    }

    public boolean getSettingsButtonEnabled() {
        return this.isSettingsButtonEnabled;
    }

    public boolean getBackButtonEnabled() {
        return this.backButtonRunnable != null;
    }

    public Runnable getBackButtonRunnable() {
        return this.backButtonRunnable;
    }

    public boolean getAlignmentMarkerEnabled() {
        return this.isAlignmentMarkerEnabled;
    }
}

