/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.audio;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import com.google.vr.cardboard.annotations.UsedByNative;

@UsedByNative
public class DeviceInfo {
    private static final String TAG = "DeviceInfo";
    private final long nativeObject;
    private final Context context;
    private final BroadcastReceiver headphoneStateReceiver;

    private DeviceInfo(long l, Context context) {
        this.nativeObject = l;
        this.context = context;
        this.headphoneStateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.HEADSET_PLUG")) {
                    int n = intent.getIntExtra("state", -1);
                    switch (n) {
                        case 0: {
                            DeviceInfo.this.nativeUpdateHeadphoneStateChange(DeviceInfo.this.nativeObject, 2);
                            return;
                        }
                        case 1: {
                            DeviceInfo.this.nativeUpdateHeadphoneStateChange(DeviceInfo.this.nativeObject, 1);
                            return;
                        }
                    }
                    DeviceInfo.this.nativeUpdateHeadphoneStateChange(DeviceInfo.this.nativeObject, 0);
                }
            }
        };
    }

    @UsedByNative
    private static DeviceInfo createDeviceInfo(long l, Context context) {
        return new DeviceInfo(l, context);
    }

    @UsedByNative
    private void registerHandlers() {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.HEADSET_PLUG");
        this.context.registerReceiver(this.headphoneStateReceiver, intentFilter);
    }

    @UsedByNative
    private void unregisterHandlers() {
        this.context.unregisterReceiver(this.headphoneStateReceiver);
    }

    @UsedByNative
    private boolean isHeadphonePluggedIn() {
        AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
        return audioManager.isWiredHeadsetOn();
    }

    private native void nativeUpdateHeadphoneStateChange(long var1, int var3);

    private static abstract class HeadphoneState {
        public static final int UNKNOWN = 0;
        public static final int PLUGGEDIN = 1;
        public static final int UNPLUGGED = 2;

        private HeadphoneState() {
        }
    }
}

