/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

class SensorReadingStats {
    private static final String TAG = SensorReadingStats.class.getSimpleName();
    private int sampleBufSize;
    private int numAxes;
    private float[][] sampleBuf;
    private int writePos;
    private int samplesAdded;

    SensorReadingStats(int n, int n2) {
        this.sampleBufSize = n;
        this.numAxes = n2;
        if (n <= 0) {
            throw new IllegalArgumentException("sampleBufSize is invalid.");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("numAxes is invalid.");
        }
        this.sampleBuf = new float[n][n2];
    }

    void addSample(float[] fArray) {
        if (fArray.length < this.numAxes) {
            throw new IllegalArgumentException("values.length is less than # of axes.");
        }
        this.writePos = (this.writePos + 1) % this.sampleBufSize;
        for (int i = 0; i < this.numAxes; ++i) {
            this.sampleBuf[this.writePos][i] = fArray[i];
        }
        ++this.samplesAdded;
    }

    void reset() {
        this.samplesAdded = 0;
        this.writePos = 0;
    }

    boolean statsAvailable() {
        return this.samplesAdded >= this.sampleBufSize;
    }

    float getAverage(int n) {
        if (!this.statsAvailable()) {
            throw new IllegalStateException("Average not available. Not enough samples.");
        }
        if (n < 0 || n >= this.numAxes) {
            int n2 = this.numAxes - 1;
            throw new IllegalStateException(new StringBuilder(38).append("axis must be between 0 and ").append(n2).toString());
        }
        float f = 0.0f;
        for (int i = 0; i < this.sampleBufSize; ++i) {
            f += this.sampleBuf[i][n];
        }
        return f / (float)this.sampleBufSize;
    }

    float getMaxAbsoluteDeviation(int n) {
        if (n < 0 || n >= this.numAxes) {
            int n2 = this.numAxes - 1;
            throw new IllegalStateException(new StringBuilder(38).append("axis must be between 0 and ").append(n2).toString());
        }
        float f = this.getAverage(n);
        float f2 = 0.0f;
        for (int i = 0; i < this.sampleBufSize; ++i) {
            f2 = Math.max(Math.abs(this.sampleBuf[i][n] - f), f2);
        }
        return f2;
    }

    float getMaxAbsoluteDeviation() {
        float f = 0.0f;
        for (int i = 0; i < this.numAxes; ++i) {
            f = Math.max(f, this.getMaxAbsoluteDeviation(i));
        }
        return f;
    }
}

