/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.vr.cardboard.ContextUtils;
import com.google.vr.cardboard.R;
import com.google.vr.cardboard.UiUtils;
import com.google.vr.ndk.base.DaydreamUtilsWrapper;
import com.google.vr.ndk.base.FadeOverlayView;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;
import com.google.vr.vrcore.base.api.VrCoreUtils;
import com.google.vr.vrcore.common.api.HeadTrackingState;
import com.google.vr.vrcore.common.api.IDaydreamListener;
import com.google.vr.vrcore.common.api.IDaydreamManager;
import com.google.vr.vrcore.common.api.IVrCoreSdkService;
import java.lang.ref.WeakReference;

class VrCoreSdkClient {
    private static final String TAG = "VrCoreSdkClient";
    private static final boolean DEBUG = false;
    static final int MIN_VRCORE_API_VERSION = 5;
    static final int TARGET_VRCORE_API_VERSION = 10;
    private final Context context;
    private final GvrApi gvrApi;
    private final ComponentName componentName;
    private final DaydreamUtilsWrapper daydreamUtils;
    private final Runnable closeVrRunnable;
    private final FadeOverlayView fadeOverlayView;
    private final IDaydreamListener daydreamListener;
    private final boolean shouldBind;
    private boolean isBound;
    private boolean isResumed;
    private IVrCoreSdkService vrCoreSdkService;
    private IDaydreamManager daydreamManager;
    private AlertDialog helpCenterDialog;
    private final ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            HeadTrackingState headTrackingState;
            block12: {
                IVrCoreSdkService iVrCoreSdkService = IVrCoreSdkService.Stub.asInterface(iBinder);
                try {
                    if (!iVrCoreSdkService.initialize(10)) {
                        Log.e((String)VrCoreSdkClient.TAG, (String)"Failed to initialize VrCore SDK Service.");
                        VrCoreSdkClient.this.handleBindFailed();
                        return;
                    }
                }
                catch (RemoteException remoteException) {
                    String string2 = String.valueOf((Object)remoteException);
                    Log.w((String)VrCoreSdkClient.TAG, (String)new StringBuilder(41 + String.valueOf(string2).length()).append("Failed to initialize VrCore SDK Service: ").append(string2).toString());
                    VrCoreSdkClient.this.handleBindFailed();
                    return;
                }
                VrCoreSdkClient.this.vrCoreSdkService = iVrCoreSdkService;
                try {
                    VrCoreSdkClient.this.daydreamManager = VrCoreSdkClient.this.vrCoreSdkService.getDaydreamManager();
                    if (VrCoreSdkClient.this.daydreamManager == null) {
                        Log.w((String)VrCoreSdkClient.TAG, (String)"Failed to obtain DaydreamManager from VrCore SDK Service.");
                        VrCoreSdkClient.this.handleNoDaydreamManager();
                        return;
                    }
                    VrCoreSdkClient.this.daydreamManager.registerListener(VrCoreSdkClient.this.componentName, VrCoreSdkClient.this.daydreamListener);
                }
                catch (RemoteException remoteException) {
                    String string3 = String.valueOf((Object)remoteException);
                    Log.w((String)VrCoreSdkClient.TAG, (String)new StringBuilder(57 + String.valueOf(string3).length()).append("Failed to obtain DaydreamManager from VrCore SDK Service:").append(string3).toString());
                    VrCoreSdkClient.this.handleNoDaydreamManager();
                    return;
                }
                headTrackingState = null;
                try {
                    HeadTrackingState headTrackingState2 = VrCoreSdkClient.this.getHeadTrackingState();
                    int n = VrCoreSdkClient.this.daydreamManager.prepareVr(VrCoreSdkClient.this.componentName, headTrackingState2);
                    if (n == 2) {
                        Log.e((String)VrCoreSdkClient.TAG, (String)"Daydream VR preparation failed, closing VR session.");
                        VrCoreSdkClient.this.handlePrepareVrFailed();
                        return;
                    }
                    if (n != 0) break block12;
                    headTrackingState = headTrackingState2;
                }
                catch (RemoteException remoteException) {
                    String string4 = String.valueOf((Object)remoteException);
                    Log.w((String)VrCoreSdkClient.TAG, (String)new StringBuilder(61 + String.valueOf(string4).length()).append("Error while registering listener with the VrCore SDK Service:").append(string4).toString());
                    return;
                }
                finally {
                    VrCoreSdkClient.this.resumeTracking(null);
                }
            }
            VrCoreSdkClient.this.resumeTracking(headTrackingState);
            return;
        }

        public void onServiceDisconnected(ComponentName componentName) {
            VrCoreSdkClient.this.vrCoreSdkService = null;
            VrCoreSdkClient.this.daydreamManager = null;
        }
    };

    public VrCoreSdkClient(Context context, GvrApi gvrApi, ComponentName componentName, DaydreamUtilsWrapper daydreamUtilsWrapper, Runnable runnable, FadeOverlayView fadeOverlayView) {
        this.context = context;
        this.gvrApi = gvrApi;
        this.componentName = componentName;
        this.daydreamUtils = daydreamUtilsWrapper;
        this.closeVrRunnable = runnable;
        this.fadeOverlayView = fadeOverlayView;
        this.daydreamListener = new DaydreamListenerImpl(gvrApi, fadeOverlayView);
        this.shouldBind = VrCoreSdkClient.hasCompatibleSdkService(context);
        gvrApi.setIgnoreManualTrackerPauseResume(true);
    }

    IDaydreamManager getDaydreamManager() {
        return this.daydreamManager;
    }

    HeadTrackingState getHeadTrackingState() {
        return new HeadTrackingState();
    }

    public boolean onResume() {
        this.isResumed = true;
        return this.doBind();
    }

    public void onPause() {
        this.isResumed = false;
        this.doUnbind();
    }

    public boolean launchInVr(PendingIntent pendingIntent) {
        if (this.daydreamManager != null) {
            try {
                this.daydreamManager.deprecatedLaunchInVr(pendingIntent);
            }
            catch (RemoteException remoteException) {
                String string2 = String.valueOf((Object)remoteException);
                Log.w((String)TAG, (String)new StringBuilder(28 + String.valueOf(string2).length()).append("Failed to launch app in VR: ").append(string2).toString());
            }
            return true;
        }
        return false;
    }

    private boolean doBind() {
        if (this.isBound) {
            return true;
        }
        if (this.shouldBind) {
            Intent intent = new Intent("com.google.vr.vrcore.BIND_SDK_SERVICE");
            intent.setPackage("com.google.vr.vrcore");
            this.isBound = this.context.bindService(intent, this.serviceConnection, 1);
        }
        if (!this.isBound) {
            this.handleBindFailed();
        }
        return this.isBound;
    }

    private void doUnbind() {
        if (this.isResumed) {
            this.gvrApi.resumeTrackingSetState(null);
        } else {
            this.gvrApi.pauseTrackingGetState();
        }
        if (!this.isBound) {
            return;
        }
        if (this.daydreamManager != null) {
            try {
                this.daydreamManager.unregisterListener(this.componentName);
            }
            catch (RemoteException remoteException) {
                String string2 = String.valueOf((Object)remoteException);
                Log.w((String)TAG, (String)new StringBuilder(40 + String.valueOf(string2).length()).append("Failed to unregister Daydream listener: ").append(string2).toString());
            }
            this.daydreamManager = null;
        }
        this.vrCoreSdkService = null;
        this.context.unbindService(this.serviceConnection);
        this.isBound = false;
    }

    private void handleBindFailed() {
        this.doUnbind();
        this.warnIfIncompatibleClient();
    }

    private void handleNoDaydreamManager() {
        this.doUnbind();
        this.warnIfIncompatibleClient();
    }

    private void handlePrepareVrFailed() {
        this.doUnbind();
        this.closeVrRunnable.run();
    }

    private void warnIfIncompatibleClient() {
        if (!this.daydreamUtils.isDaydreamPhone(this.context) && this.daydreamUtils.isDaydreamRequiredActivity(ContextUtils.getActivity(this.context)) && !ActivityManager.isRunningInTestHarness()) {
            if (this.helpCenterDialog != null) {
                this.helpCenterDialog.show();
                return;
            }
            this.helpCenterDialog = UiUtils.showDaydreamHelpCenterDialog(this.context, R.string.dialog_title_incompatible_phone, R.string.dialog_message_incompatible_phone, this.closeVrRunnable);
        }
    }

    private void resumeTracking(HeadTrackingState headTrackingState) {
        VrCoreSdkClient.resumeTracking(this.gvrApi, headTrackingState);
    }

    private static void resumeTracking(GvrApi gvrApi, HeadTrackingState headTrackingState) {
        gvrApi.resumeTrackingSetState(headTrackingState != null && !headTrackingState.isEmpty() ? headTrackingState.getData() : null);
    }

    private static boolean hasCompatibleSdkService(Context context) {
        try {
            int n = VrCoreUtils.getVrCoreClientApiVersion(context);
            if (n >= 5) {
                return true;
            }
            Log.w((String)TAG, (String)String.format("VrCore service obsolete, GVR SDK requires API %d but found API %d.", 5, n));
        }
        catch (VrCoreNotAvailableException vrCoreNotAvailableException) {}
        return false;
    }

    private static final class DaydreamListenerImpl
    extends IDaydreamListener.Stub {
        private final WeakReference<GvrApi> gvrApiWeak;
        private final WeakReference<FadeOverlayView> fadeOverlayViewWeak;

        DaydreamListenerImpl(GvrApi gvrApi, FadeOverlayView fadeOverlayView) {
            this.gvrApiWeak = new WeakReference<GvrApi>(gvrApi);
            this.fadeOverlayViewWeak = new WeakReference<FadeOverlayView>(fadeOverlayView);
        }

        @Override
        public final int getTargetApiVersion() throws RemoteException {
            return 10;
        }

        @Override
        public final HeadTrackingState requestStopTracking() throws RemoteException {
            GvrApi gvrApi = (GvrApi)this.gvrApiWeak.get();
            if (gvrApi == null) {
                Log.w((String)VrCoreSdkClient.TAG, (String)"Invalid requestStopTracking() call: GvrApi no longer valid");
                return null;
            }
            byte[] byArray = gvrApi.pauseTrackingGetState();
            if (byArray != null) {
                return new HeadTrackingState(byArray);
            }
            return null;
        }

        @Override
        public final void applyFade(final int n, final long l) {
            final FadeOverlayView fadeOverlayView = (FadeOverlayView)((Object)this.fadeOverlayViewWeak.get());
            if (fadeOverlayView != null) {
                fadeOverlayView.post(new Runnable(this){

                    @Override
                    public void run() {
                        fadeOverlayView.startFade(n, l);
                    }
                });
            }
        }

        @Override
        public final void recenterHeadTracking() throws RemoteException {
            GvrApi gvrApi = (GvrApi)this.gvrApiWeak.get();
            if (gvrApi == null) {
                Log.w((String)VrCoreSdkClient.TAG, (String)"Invalid recenterHeadTracking() call: GvrApi no longer valid");
                return;
            }
            gvrApi.recenterTracking();
        }

        @Override
        public final void dumpDebugData() throws RemoteException {
            GvrApi gvrApi = (GvrApi)this.gvrApiWeak.get();
            if (gvrApi == null) {
                Log.w((String)VrCoreSdkClient.TAG, (String)"Invalid dumpDebugData() call: GvrApi no longer valid");
                return;
            }
            gvrApi.dumpDebugData();
        }

        @Override
        public final void resumeHeadTracking(HeadTrackingState headTrackingState) {
            GvrApi gvrApi = (GvrApi)this.gvrApiWeak.get();
            if (gvrApi == null) {
                Log.w((String)VrCoreSdkClient.TAG, (String)"Invalid resumeHeadTracking() call: GvrApi no longer valid");
                return;
            }
            VrCoreSdkClient.resumeTracking(gvrApi, headTrackingState);
        }
    }
}

