/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.util.Log;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.vrcore.nano.SdkConfiguration;

public class SdkConfigurationReader {
    private static final String TAG = SdkConfigurationReader.class.getSimpleName();
    static final SdkConfiguration.SdkConfigurationParams REQUESTED_PARAMS;
    static final SdkConfiguration.SdkConfigurationParams DEFAULT_PARAMS;
    private SdkConfiguration.SdkConfigurationParams params;

    public SdkConfigurationReader(VrParamsProvider vrParamsProvider) {
        SdkConfiguration.SdkConfigurationRequest sdkConfigurationRequest = new SdkConfiguration.SdkConfigurationRequest();
        new SdkConfiguration.SdkConfigurationRequest().requestedParams = REQUESTED_PARAMS;
        sdkConfigurationRequest.setSdkVersion("1.0.3");
        this.params = vrParamsProvider.readSdkConfigurationParams(sdkConfigurationRequest);
        if (this.params == null) {
            Log.w((String)TAG, (String)"VrParamsProvider returned null params, using defaults.");
            this.params = DEFAULT_PARAMS;
            return;
        }
        String string2 = String.valueOf(this.params);
        Log.d((String)TAG, (String)new StringBuilder(38 + String.valueOf(string2).length()).append("Fetched params from VrParamsProvider: ").append(string2).toString());
    }

    public SdkConfiguration.SdkConfigurationParams getParams() {
        return this.params;
    }

    static {
        DEFAULT_PARAMS = new SdkConfiguration.SdkConfigurationParams();
        REQUESTED_PARAMS = new SdkConfiguration.SdkConfigurationParams();
        REQUESTED_PARAMS.setDaydreamImageAlignmentEnabled(true);
        REQUESTED_PARAMS.setUseSystemClockForSensorTimestamps(true);
        REQUESTED_PARAMS.setUseMagnetometerInSensorFusion(true);
        REQUESTED_PARAMS.setAllowDynamicLibraryLoading(true);
        REQUESTED_PARAMS.setCpuLateLatchingEnabled(true);
    }
}

