/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.content.Context;
import com.google.vr.cardboard.ThreadUtils;
import com.google.vr.internal.controller.ServiceBridge;
import com.google.vr.vrcore.controller.api.ControllerEventPacket;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;

class CardboardEmulator {
    private static final String TAG = CardboardEmulator.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final ServiceBridge controllerServiceBridge;

    public CardboardEmulator(Context context, Runnable runnable) {
        this.controllerServiceBridge = this.createServiceBridge(context, new ControllerCallbacks(runnable));
        this.controllerServiceBridge.setOrientationEnabled(false);
        this.controllerServiceBridge.setGyroEnabled(false);
        this.controllerServiceBridge.setAccelEnabled(false);
        this.controllerServiceBridge.setTouchEnabled(false);
        this.controllerServiceBridge.setGesturesEnabled(false);
    }

    public void onResume() {
        this.controllerServiceBridge.requestBind();
    }

    public void onPause() {
        this.controllerServiceBridge.requestUnbind();
    }

    protected ServiceBridge createServiceBridge(Context context, ServiceBridge.Callbacks callbacks) {
        return new ServiceBridge(context, callbacks);
    }

    private static class ControllerCallbacks
    implements ServiceBridge.Callbacks {
        private final Runnable cardboardTriggerCallback;

        ControllerCallbacks(Runnable runnable) {
            this.cardboardTriggerCallback = runnable;
        }

        @Override
        public void onServiceConnected(int n) {
        }

        @Override
        public void onServiceDisconnected() {
        }

        @Override
        public void onServiceUnavailable() {
        }

        @Override
        public void onServiceFailed() {
        }

        @Override
        public void onServiceInitFailed(int n) {
        }

        @Override
        public void onControllerStateChanged(int n, int n2) {
        }

        @Override
        public void onControllerEventPacket(ControllerEventPacket controllerEventPacket) {
            for (int i = 0; i < controllerEventPacket.getButtonEventCount(); ++i) {
                switch (controllerEventPacket.getButtonEvent((int)i).button) {
                    case 1: 
                    case 3: {
                        ThreadUtils.runOnUiThread(this.cardboardTriggerCallback);
                    }
                }
            }
        }

        @Override
        public void onControllerRecentered(ControllerOrientationEvent controllerOrientationEvent) {
        }
    }
}

