/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.graphics.Point;
import android.util.Log;
import com.google.vr.ndk.base.GvrApi;

public class BufferSpec {
    private static final String TAG = BufferSpec.class.getSimpleName();
    long nativeBufferSpec;

    BufferSpec(long l) {
        this.nativeBufferSpec = l;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.nativeBufferSpec != 0L) {
                Log.w((String)TAG, (String)"BufferSpec.shutdown() should be called to ensure resource cleanup");
                this.shutdown();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public void shutdown() {
        if (this.nativeBufferSpec != 0L) {
            GvrApi.nativeBufferSpecDestroy(this.nativeBufferSpec);
            this.nativeBufferSpec = 0L;
        }
    }

    public void getSize(Point point) {
        GvrApi.nativeBufferSpecGetSize(this.nativeBufferSpec, point);
    }

    public void setSize(Point point) {
        GvrApi.nativeBufferSpecSetSize(this.nativeBufferSpec, point.x, point.y);
    }

    public int getSamples() {
        return GvrApi.nativeBufferSpecGetSamples(this.nativeBufferSpec);
    }

    public void setSamples(int n) {
        GvrApi.nativeBufferSpecSetSamples(this.nativeBufferSpec, n);
    }
}

