/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.internal.controller;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import android.util.Log;
import com.google.vr.cardboard.annotations.UsedByNative;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;
import com.google.vr.vrcore.base.api.VrCoreUtils;
import com.google.vr.vrcore.controller.api.ControllerAccelEvent;
import com.google.vr.vrcore.controller.api.ControllerButtonEvent;
import com.google.vr.vrcore.controller.api.ControllerEventPacket;
import com.google.vr.vrcore.controller.api.ControllerGyroEvent;
import com.google.vr.vrcore.controller.api.ControllerInitResults;
import com.google.vr.vrcore.controller.api.ControllerListenerOptions;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;
import com.google.vr.vrcore.controller.api.ControllerTouchEvent;
import com.google.vr.vrcore.controller.api.IControllerListener;
import com.google.vr.vrcore.controller.api.IControllerService;

@UsedByNative
public class ServiceBridge
implements ServiceConnection {
    private static final String TAG = ServiceBridge.class.getSimpleName();
    private static final boolean DEBUG = false;
    static final int TARGET_SERVICE_API_VERSION = 10;
    static final String LISTENER_KEY = "com.google.vr.internal.controller.LISTENER_KEY";
    private static final int MIN_SERVICE_API_FOR_RECENTERING = 8;
    public static final int FLAG_SUPPORTS_RECENTER = 1;
    private final Context context;
    private final ControllerListenerOptions options = new ControllerListenerOptions();
    private final Handler mainThreadHandler;
    private IControllerService service;
    private final Callbacks callbacks;
    private boolean isBound;
    private final Runnable bindRunnable = new Runnable(){

        @Override
        public void run() {
            ServiceBridge.this.doBind();
        }
    };
    private final Runnable unbindRunnable = new Runnable(){

        @Override
        public void run() {
            ServiceBridge.this.doUnbind();
        }
    };
    private final IControllerListener controllerListener = new IControllerListener.Stub(){

        @Override
        public int getApiVersion() throws RemoteException {
            return 10;
        }

        @Override
        public ControllerListenerOptions getOptions() throws RemoteException {
            return ServiceBridge.this.options;
        }

        @Override
        public void onControllerStateChanged(int n, int n2) throws RemoteException {
            ServiceBridge.this.callbacks.onControllerStateChanged(n, n2);
        }

        @Override
        public void onControllerEventPacket(ControllerEventPacket controllerEventPacket) throws RemoteException {
            ServiceBridge.this.callbacks.onControllerEventPacket(controllerEventPacket);
            controllerEventPacket.recycle();
        }

        @Override
        public void onControllerRecentered(ControllerOrientationEvent controllerOrientationEvent) {
            ServiceBridge.this.callbacks.onControllerRecentered(controllerOrientationEvent);
        }

        @Override
        public boolean deprecatedOnControllerButtonEventV1(ControllerButtonEvent controllerButtonEvent) {
            return true;
        }

        @Override
        public void deprecatedOnControllerAccelEvent(ControllerAccelEvent controllerAccelEvent) {
            ControllerEventPacket controllerEventPacket = ControllerEventPacket.obtain();
            Parcel parcel = Parcel.obtain();
            controllerAccelEvent.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            controllerEventPacket.addAccelEvent().readFromParcel(parcel);
            ServiceBridge.this.callbacks.onControllerEventPacket(controllerEventPacket);
            controllerEventPacket.recycle();
            parcel.recycle();
        }

        @Override
        public void deprecatedOnControllerButtonEvent(ControllerButtonEvent controllerButtonEvent) {
            ControllerEventPacket controllerEventPacket = ControllerEventPacket.obtain();
            Parcel parcel = Parcel.obtain();
            controllerButtonEvent.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            controllerEventPacket.addButtonEvent().readFromParcel(parcel);
            ServiceBridge.this.callbacks.onControllerEventPacket(controllerEventPacket);
            controllerEventPacket.recycle();
            parcel.recycle();
        }

        @Override
        public void deprecatedOnControllerGyroEvent(ControllerGyroEvent controllerGyroEvent) {
            ControllerEventPacket controllerEventPacket = ControllerEventPacket.obtain();
            Parcel parcel = Parcel.obtain();
            controllerGyroEvent.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            controllerEventPacket.addGyroEvent().readFromParcel(parcel);
            ServiceBridge.this.callbacks.onControllerEventPacket(controllerEventPacket);
            controllerEventPacket.recycle();
            parcel.recycle();
        }

        @Override
        public void deprecatedOnControllerOrientationEvent(ControllerOrientationEvent controllerOrientationEvent) {
            ControllerEventPacket controllerEventPacket = ControllerEventPacket.obtain();
            Parcel parcel = Parcel.obtain();
            controllerOrientationEvent.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            controllerEventPacket.addOrientationEvent().readFromParcel(parcel);
            ServiceBridge.this.callbacks.onControllerEventPacket(controllerEventPacket);
            controllerEventPacket.recycle();
            parcel.recycle();
        }

        @Override
        public void deprecatedOnControllerTouchEvent(ControllerTouchEvent controllerTouchEvent) {
            ControllerEventPacket controllerEventPacket = ControllerEventPacket.obtain();
            Parcel parcel = Parcel.obtain();
            controllerTouchEvent.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            controllerEventPacket.addTouchEvent().readFromParcel(parcel);
            ServiceBridge.this.callbacks.onControllerEventPacket(controllerEventPacket);
            controllerEventPacket.recycle();
            parcel.recycle();
        }
    };

    @UsedByNative
    public ServiceBridge(Context context, Callbacks callbacks) {
        this.context = context.getApplicationContext();
        this.callbacks = callbacks;
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
    }

    @UsedByNative
    public void setOrientationEnabled(boolean bl) {
        this.options.enableOrientation = bl;
    }

    @UsedByNative
    public void setTouchEnabled(boolean bl) {
        this.options.enableTouch = bl;
    }

    @UsedByNative
    public void setGyroEnabled(boolean bl) {
        this.options.enableGyro = bl;
    }

    @UsedByNative
    public void setAccelEnabled(boolean bl) {
        this.options.enableAccel = bl;
    }

    @UsedByNative
    public void setGesturesEnabled(boolean bl) {
        this.options.enableGestures = bl;
    }

    @UsedByNative
    public void requestBind() {
        this.mainThreadHandler.post(this.bindRunnable);
    }

    @UsedByNative
    public void requestUnbind() {
        this.mainThreadHandler.post(this.unbindRunnable);
    }

    private void doBind() {
        this.ensureOnMainThread();
        if (this.isBound) {
            Log.w((String)TAG, (String)"Service is already bound.");
            return;
        }
        Intent intent = new Intent("com.google.vr.vrcore.controller.BIND");
        intent.setPackage("com.google.vr.vrcore");
        if (!this.context.bindService(intent, (ServiceConnection)this, 1)) {
            Log.w((String)TAG, (String)"Bind failed. Service is not available.");
            this.callbacks.onServiceUnavailable();
            return;
        }
        this.isBound = true;
    }

    private void unregisterListener() {
        if (this.service == null) {
            return;
        }
        try {
            this.service.unregisterListener(LISTENER_KEY);
            return;
        }
        catch (RemoteException remoteException) {
            RemoteException remoteException2 = remoteException;
            remoteException.printStackTrace();
            Log.w((String)TAG, (String)"RemoteException while unregistering listener.");
            return;
        }
    }

    private void doUnbind() {
        this.ensureOnMainThread();
        if (!this.isBound) {
            Log.w((String)TAG, (String)"Service is already unbound.");
            return;
        }
        this.unregisterListener();
        this.context.unbindService((ServiceConnection)this);
        this.isBound = false;
    }

    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        int n;
        this.ensureOnMainThread();
        this.service = IControllerService.Stub.asInterface(iBinder);
        try {
            n = this.service.initialize(10);
        }
        catch (RemoteException remoteException) {
            RemoteException remoteException2 = remoteException;
            remoteException.printStackTrace();
            Log.e((String)TAG, (String)"Failed to call initialize() on controller service (RemoteException).");
            this.callbacks.onServiceFailed();
            this.doUnbind();
            return;
        }
        if (n != 0) {
            String string2 = String.valueOf(ControllerInitResults.toString(n));
            Log.e((String)TAG, (String)(string2.length() != 0 ? "initialize() returned error: ".concat(string2) : new String("initialize() returned error: ")));
            this.callbacks.onServiceInitFailed(n);
            this.doUnbind();
            return;
        }
        int n2 = this.getVrCoreClientApiVersion();
        if (n2 < 0) {
            Log.w((String)TAG, (String)"Failed to get VrCore client API version.");
            this.callbacks.onServiceFailed();
            this.doUnbind();
            return;
        }
        int n3 = 0;
        if (n2 >= 8) {
            n3 = 1;
        } else {
            Log.w((String)TAG, (String)new StringBuilder(62).append("Recentering is not supported by VrCore API version ").append(n2).toString());
        }
        this.callbacks.onServiceConnected(n3);
        try {
            if (!this.service.registerListener(0, LISTENER_KEY, this.controllerListener)) {
                Log.w((String)TAG, (String)"Failed to register listener.");
                this.callbacks.onServiceFailed();
                this.doUnbind();
                return;
            }
            return;
        }
        catch (RemoteException remoteException) {
            RemoteException remoteException3 = remoteException;
            remoteException.printStackTrace();
            Log.w((String)TAG, (String)"RemoteException while registering listener.");
            this.callbacks.onServiceFailed();
            this.doUnbind();
            return;
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
        this.ensureOnMainThread();
        this.service = null;
        this.callbacks.onServiceDisconnected();
    }

    protected int getVrCoreClientApiVersion() {
        try {
            return VrCoreUtils.getVrCoreClientApiVersion(this.context);
        }
        catch (VrCoreNotAvailableException vrCoreNotAvailableException) {
            Log.w((String)TAG, (String)"VrCore not available.", (Throwable)vrCoreNotAvailableException);
            return -1;
        }
    }

    private void ensureOnMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("This should be running on the main thread.");
        }
    }

    @UsedByNative
    public static interface Callbacks {
        public void onServiceConnected(int var1);

        public void onServiceDisconnected();

        public void onServiceUnavailable();

        public void onServiceFailed();

        public void onServiceInitFailed(int var1);

        public void onControllerStateChanged(int var1, int var2);

        public void onControllerEventPacket(ControllerEventPacket var1);

        public void onControllerRecentered(ControllerOrientationEvent var1);
    }
}

