/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.internal.controller;

import com.google.vr.cardboard.annotations.UsedByNative;
import com.google.vr.internal.controller.ServiceBridge;
import com.google.vr.vrcore.controller.api.ControllerButtonEvent;
import com.google.vr.vrcore.controller.api.ControllerEvent;
import com.google.vr.vrcore.controller.api.ControllerEventPacket;
import com.google.vr.vrcore.controller.api.ControllerGyroEvent;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;
import com.google.vr.vrcore.controller.api.ControllerTouchEvent;

@UsedByNative
public final class NativeCallbacks
implements ServiceBridge.Callbacks {
    private final long userData;
    private boolean closed;

    @UsedByNative
    public NativeCallbacks(long l) {
        this.userData = l;
    }

    @UsedByNative
    public final synchronized void close() {
        this.closed = true;
    }

    @Override
    public final synchronized void onControllerStateChanged(int n, int n2) {
        if (!this.closed) {
            this.handleStateChanged(this.userData, n, n2);
        }
    }

    @Override
    public final synchronized void onControllerEventPacket(ControllerEventPacket controllerEventPacket) {
        ControllerEvent controllerEvent;
        int n;
        if (this.closed) {
            return;
        }
        for (n = 0; !this.closed && n < controllerEventPacket.getAccelEventCount(); ++n) {
            controllerEvent = controllerEventPacket.getAccelEvent(n);
            this.handleAccelEvent(this.userData, controllerEvent.timestampNanos, controllerEvent.x, controllerEvent.y, controllerEvent.z);
        }
        for (n = 0; !this.closed && n < controllerEventPacket.getButtonEventCount(); ++n) {
            controllerEvent = controllerEventPacket.getButtonEvent(n);
            this.handleButtonEvent(this.userData, ((ControllerButtonEvent)controllerEvent).timestampNanos, ((ControllerButtonEvent)controllerEvent).button, ((ControllerButtonEvent)controllerEvent).down);
        }
        for (n = 0; !this.closed && n < controllerEventPacket.getGyroEventCount(); ++n) {
            controllerEvent = controllerEventPacket.getGyroEvent(n);
            this.handleGyroEvent(this.userData, ((ControllerGyroEvent)controllerEvent).timestampNanos, ((ControllerGyroEvent)controllerEvent).x, ((ControllerGyroEvent)controllerEvent).y, ((ControllerGyroEvent)controllerEvent).z);
        }
        for (n = 0; !this.closed && n < controllerEventPacket.getOrientationEventCount(); ++n) {
            controllerEvent = controllerEventPacket.getOrientationEvent(n);
            this.handleOrientationEvent(this.userData, ((ControllerOrientationEvent)controllerEvent).timestampNanos, ((ControllerOrientationEvent)controllerEvent).qx, ((ControllerOrientationEvent)controllerEvent).qy, ((ControllerOrientationEvent)controllerEvent).qz, ((ControllerOrientationEvent)controllerEvent).qw);
        }
        for (n = 0; !this.closed && n < controllerEventPacket.getTouchEventCount(); ++n) {
            controllerEvent = controllerEventPacket.getTouchEvent(n);
            this.handleTouchEvent(this.userData, ((ControllerTouchEvent)controllerEvent).timestampNanos, ((ControllerTouchEvent)controllerEvent).action, ((ControllerTouchEvent)controllerEvent).x, ((ControllerTouchEvent)controllerEvent).y);
        }
    }

    @Override
    public final synchronized void onControllerRecentered(ControllerOrientationEvent controllerOrientationEvent) {
        if (!this.closed) {
            this.handleControllerRecentered(this.userData, controllerOrientationEvent.timestampNanos, controllerOrientationEvent.qx, controllerOrientationEvent.qy, controllerOrientationEvent.qz, controllerOrientationEvent.qw);
        }
    }

    @Override
    public final synchronized void onServiceConnected(int n) {
        if (!this.closed) {
            this.handleServiceConnected(this.userData, n);
        }
    }

    @Override
    public final synchronized void onServiceDisconnected() {
        if (!this.closed) {
            this.handleServiceDisconnected(this.userData);
        }
    }

    @Override
    public final synchronized void onServiceFailed() {
        if (!this.closed) {
            this.handleServiceFailed(this.userData);
        }
    }

    @Override
    public final synchronized void onServiceUnavailable() {
        if (!this.closed) {
            this.handleServiceUnavailable(this.userData);
        }
    }

    @Override
    public final synchronized void onServiceInitFailed(int n) {
        if (!this.closed) {
            this.handleServiceInitFailed(this.userData, n);
        }
    }

    private final native void handleStateChanged(long var1, int var3, int var4);

    private final native void handleControllerRecentered(long var1, long var3, float var5, float var6, float var7, float var8);

    private final native void handleTouchEvent(long var1, long var3, int var5, float var6, float var7);

    private final native void handleOrientationEvent(long var1, long var3, float var5, float var6, float var7, float var8);

    private final native void handleButtonEvent(long var1, long var3, int var5, boolean var6);

    private final native void handleAccelEvent(long var1, long var3, float var5, float var6, float var7);

    private final native void handleGyroEvent(long var1, long var3, float var5, float var6, float var7);

    private final native void handleServiceInitFailed(long var1, int var3);

    private final native void handleServiceFailed(long var1);

    private final native void handleServiceUnavailable(long var1);

    private final native void handleServiceConnected(long var1, int var3);

    private final native void handleServiceDisconnected(long var1);
}

