/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import com.google.vr.ndk.base.GvrLayout;
import java.util.concurrent.atomic.AtomicBoolean;

public class SurfaceTextureManager {
    private static final String TAG = SurfaceTextureManager.class.getSimpleName();
    private final Object callbackInitLock = new Object();
    private ExternalSurfaceCallback[] surfaceTextureCallbacks;
    private AtomicBoolean isInitialized;
    private SurfaceTextureBundle[] surfaceTextureBundleList;

    public SurfaceTextureManager(int n) {
        this.surfaceTextureCallbacks = new ExternalSurfaceCallback[n];
        this.surfaceTextureBundleList = new SurfaceTextureBundle[n];
        this.isInitialized = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        for (int i = 0; i < this.surfaceTextureBundleList.length; ++i) {
            this.surfaceTextureBundleList[i] = new SurfaceTextureBundle(i);
        }
        Object object = this.callbackInitLock;
        synchronized (object) {
            this.isInitialized.set(true);
            for (int i = 0; i < this.surfaceTextureCallbacks.length; ++i) {
                ExternalSurfaceCallback externalSurfaceCallback = this.surfaceTextureCallbacks[i];
                if (externalSurfaceCallback == null) continue;
                this.surfaceTextureBundleList[i].setExternalSurfaceCallback(externalSurfaceCallback);
            }
            return;
        }
    }

    public boolean isInitialized() {
        return this.isInitialized.get();
    }

    public void shutdown() {
        if (this.isInitialized.getAndSet(false)) {
            for (int i = 0; i < this.surfaceTextureBundleList.length; ++i) {
                this.surfaceTextureBundleList[i].destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalSurfaceListener(int n, GvrLayout.ExternalSurfaceListener externalSurfaceListener, Handler handler) {
        if (n >= this.surfaceTextureCallbacks.length || n < 0) {
            Log.e((String)TAG, (String)new StringBuilder(59).append("Error: Cannot set listener. No Surface with ID: ").append(n).toString());
            return;
        }
        if (externalSurfaceListener == null || handler == null) {
            Log.e((String)TAG, (String)"Error: Cannot set ExternalSurfaceListener. Must provide a non-null ExternalSurfaceListener and Handler.");
            return;
        }
        ExternalSurfaceCallback externalSurfaceCallback = new ExternalSurfaceCallback(externalSurfaceListener, handler);
        Object object = this.callbackInitLock;
        synchronized (object) {
            this.surfaceTextureCallbacks[n] = externalSurfaceCallback;
            if (this.isInitialized.get()) {
                this.surfaceTextureBundleList[n].setExternalSurfaceCallback(externalSurfaceCallback);
            }
            return;
        }
    }

    public int getSurfaceCount() {
        return this.surfaceTextureBundleList.length;
    }

    public int getGLTextureHandle(int n) {
        if (this.isValidId(n)) {
            return this.surfaceTextureBundleList[n].getGlTextureHandle();
        }
        return 0;
    }

    public Surface getSurface(int n) {
        if (this.isValidId(n)) {
            return new Surface(this.surfaceTextureBundleList[n].getSurfaceTexture());
        }
        return null;
    }

    public boolean updateSurfaceTexture(int n) {
        if (this.isValidId(n)) {
            return this.surfaceTextureBundleList[n].updateSurfaceTexture();
        }
        return false;
    }

    public long getUpdateSurfaceTextureTimestamp(int n) {
        if (this.isValidId(n)) {
            return this.surfaceTextureBundleList[n].getTimestamp();
        }
        return 0L;
    }

    public float[] getUpdateSurfaceTextureTransformMatrix(int n) {
        if (this.isValidId(n)) {
            return this.surfaceTextureBundleList[n].getTransformMatrix();
        }
        float[] fArray = new float[16];
        Matrix.setIdentityM((float[])fArray, (int)0);
        return fArray;
    }

    public void attachSurfaceTextureToCurrentGLContext(int n) {
        if (this.isValidId(n)) {
            this.surfaceTextureBundleList[n].attachToCurrentGLContext();
        }
    }

    public void attachAllToCurrentGLContext() {
        if (this.isInitialized.get()) {
            SurfaceTextureBundle[] surfaceTextureBundleArray = this.surfaceTextureBundleList;
            int n = this.surfaceTextureBundleList.length;
            for (int i = 0; i < n; ++i) {
                SurfaceTextureBundle surfaceTextureBundle = surfaceTextureBundleArray[i];
                surfaceTextureBundle.attachToCurrentGLContext();
            }
        }
    }

    public void detachSurfaceTextureFromCurrentGLContext(int n) {
        if (this.isValidId(n)) {
            this.surfaceTextureBundleList[n].detachFromCurrentGLContext();
        }
    }

    public void detachAllFromCurrentGLContext() {
        if (this.isInitialized.get()) {
            SurfaceTextureBundle[] surfaceTextureBundleArray = this.surfaceTextureBundleList;
            int n = this.surfaceTextureBundleList.length;
            for (int i = 0; i < n; ++i) {
                SurfaceTextureBundle surfaceTextureBundle = surfaceTextureBundleArray[i];
                surfaceTextureBundle.detachFromCurrentGLContext();
            }
        }
    }

    private boolean isValidId(int n) {
        if (!this.isInitialized.get()) {
            Log.e((String)TAG, (String)"Error: external surfaces have not been initialized");
            return false;
        }
        if (n >= this.surfaceTextureBundleList.length || n < 0) {
            Log.e((String)TAG, (String)new StringBuilder(38).append("Error: No Surface with ID: ").append(n).toString());
            return false;
        }
        return true;
    }

    private static class SurfaceTextureBundle {
        private final Object hasNewFrameLock = new Object();
        private final Object appListenerLock = new Object();
        private final int id;
        private volatile boolean isAttachedToGLContext;
        private SurfaceTexture surfaceTexture;
        private int glTextureHandle;
        private boolean hasNewFrameUnsafe;
        private float[] transformMatrix;
        private long timestamp;
        private ExternalSurfaceCallback surfaceTextureListener;

        public SurfaceTextureBundle(int n) {
            this.id = n;
            this.hasNewFrameUnsafe = false;
            this.timestamp = 0L;
            this.transformMatrix = new float[16];
            Matrix.setIdentityM((float[])this.transformMatrix, (int)0);
            int[] nArray = new int[1];
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            this.glTextureHandle = nArray[0];
            this.surfaceTexture = new SurfaceTexture(this.glTextureHandle);
            this.surfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    Object object = SurfaceTextureBundle.this.hasNewFrameLock;
                    synchronized (object) {
                        SurfaceTextureBundle.this.hasNewFrameUnsafe = true;
                    }
                    object = SurfaceTextureBundle.this.appListenerLock;
                    synchronized (object) {
                        if (SurfaceTextureBundle.this.surfaceTextureListener != null) {
                            SurfaceTextureBundle.this.surfaceTextureListener.postOnFrameAvailable();
                        }
                        return;
                    }
                }
            });
            this.isAttachedToGLContext = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setExternalSurfaceCallback(ExternalSurfaceCallback externalSurfaceCallback) {
            Object object = this.appListenerLock;
            synchronized (object) {
                this.surfaceTextureListener = externalSurfaceCallback;
                if (this.isAttachedToGLContext) {
                    this.surfaceTextureListener.postOnAvailable(new Surface(this.surfaceTexture));
                }
                return;
            }
        }

        public SurfaceTexture getSurfaceTexture() {
            return this.surfaceTexture;
        }

        public int getGlTextureHandle() {
            return this.glTextureHandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachToCurrentGLContext() {
            if (this.isAttachedToGLContext) {
                int n = this.id;
                Log.e((String)TAG, (String)new StringBuilder(71).append("SurfaceTexture with ID ").append(n).append(" is already attached to a GL context.").toString());
                return;
            }
            int[] nArray = new int[1];
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            this.glTextureHandle = nArray[0];
            this.surfaceTexture.attachToGLContext(this.glTextureHandle);
            Object object = this.appListenerLock;
            synchronized (object) {
                this.isAttachedToGLContext = true;
                if (this.surfaceTextureListener != null) {
                    this.surfaceTextureListener.postOnAvailable(new Surface(this.surfaceTexture));
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detachFromCurrentGLContext() {
            if (!this.isAttachedToGLContext) {
                int n = this.id;
                Log.e((String)TAG, (String)new StringBuilder(75).append("SurfaceTexture with ID ").append(n).append(" is already detached from any GL context.").toString());
                return;
            }
            this.surfaceTexture.detachFromGLContext();
            this.glTextureHandle = 0;
            Object object = this.appListenerLock;
            synchronized (object) {
                this.isAttachedToGLContext = false;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateSurfaceTexture() {
            boolean bl;
            Object object = this.hasNewFrameLock;
            synchronized (object) {
                bl = this.hasNewFrameUnsafe;
                this.hasNewFrameUnsafe = false;
            }
            if (bl) {
                this.surfaceTexture.updateTexImage();
                this.surfaceTexture.getTransformMatrix(this.transformMatrix);
                this.timestamp = this.surfaceTexture.getTimestamp();
            }
            return bl;
        }

        public float[] getTransformMatrix() {
            return this.transformMatrix;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void destroy() {
            this.surfaceTexture.release();
        }
    }

    private static class ExternalSurfaceCallback {
        private final GvrLayout.ExternalSurfaceListener listener;
        private final Handler handler;
        private final Runnable frameAvailableRunnable;

        public ExternalSurfaceCallback(GvrLayout.ExternalSurfaceListener externalSurfaceListener, Handler handler) {
            this.listener = externalSurfaceListener;
            this.handler = handler;
            final GvrLayout.ExternalSurfaceListener externalSurfaceListener2 = this.listener;
            this.frameAvailableRunnable = new Runnable(this){

                @Override
                public void run() {
                    externalSurfaceListener2.onFrameAvailable();
                }
            };
        }

        public void postOnAvailable(final Surface surface) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ExternalSurfaceCallback.this.listener.onSurfaceAvailable(surface);
                }
            });
        }

        public void postOnFrameAvailable() {
            this.handler.post(this.frameAvailableRunnable);
        }
    }
}

