/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.Context;
import android.view.OrientationEventListener;

public class ScreenOrientationDetector
extends OrientationEventListener {
    private static final int DEFAULT_PORTRAIT_TOLERANCE_DEGREES = 30;
    private static final int DEFAULT_LANDSCAPE_TOLERANCE_DEGREES = 10;
    private final Listener clientListener;
    private final int landscapeToleranceDegrees;
    private final int portraitToleranceDegrees;
    private int currentScreenOrientation = -1;

    public ScreenOrientationDetector(Context context, Listener listener) {
        this(context, listener, 30, 10);
    }

    public ScreenOrientationDetector(Context context, Listener listener, int n, int n2) {
        super(context);
        if (n + n2 > 90) {
            throw new IllegalArgumentException("Portrait and landscape detection thresholds must sum to to <= 90 degrees");
        }
        this.clientListener = listener;
        this.portraitToleranceDegrees = n;
        this.landscapeToleranceDegrees = n2;
    }

    public void enable() {
        this.currentScreenOrientation = -1;
        super.enable();
    }

    public void disable() {
        super.disable();
        this.currentScreenOrientation = -1;
    }

    public void onOrientationChanged(int n) {
        int n2 = this.determineScreenOrientation(n);
        if (n2 != this.currentScreenOrientation) {
            this.currentScreenOrientation = n2;
            this.clientListener.onScreenOrientationChanged(n2);
        }
    }

    public int getCurrentScreenOrientation() {
        return this.currentScreenOrientation;
    }

    private int determineScreenOrientation(int n) {
        if (n == -1) {
            return -1;
        }
        if ((n %= 360) <= this.portraitToleranceDegrees || n >= 360 - this.portraitToleranceDegrees) {
            return 2;
        }
        if (Math.abs(n - 90) <= this.landscapeToleranceDegrees) {
            return 1;
        }
        if (Math.abs(n - 180) <= this.portraitToleranceDegrees) {
            return 3;
        }
        if (Math.abs(n - 270) <= this.landscapeToleranceDegrees) {
            return 0;
        }
        return this.currentScreenOrientation;
    }

    public static interface Listener {
        public void onScreenOrientationChanged(int var1);
    }

    public abstract class Orientation {
        public static final int UNKNOWN = -1;
        public static final int LANDSCAPE = 0;
        public static final int LANDSCAPE_REVERSE = 1;
        public static final int PORTRAIT = 2;
        public static final int PORTRAIT_REVERSE = 3;

        public Orientation(ScreenOrientationDetector screenOrientationDetector) {
        }
    }
}

