/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.graphics.Point;
import android.os.Handler;
import android.os.Process;
import android.view.Surface;
import com.google.vr.cardboard.AndroidNCompat;
import com.google.vr.cardboard.SurfaceTextureManager;
import com.google.vr.cardboard.ThreadUtils;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.ndk.base.GvrLayout;
import com.google.vr.ndk.base.GvrSurfaceView;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class ScanlineRacingRenderer
implements GvrSurfaceView.Renderer {
    private static final String TAG = "ScanlineRacingRenderer";
    private final GvrApi gvrApi;
    private final SurfaceTextureManager surfaceTextureManager;
    private GvrSurfaceView gvrSurfaceView;

    public ScanlineRacingRenderer(GvrApi gvrApi, int n) {
        if (gvrApi == null) {
            throw new IllegalArgumentException("GvrApi must be supplied for proper scanline rendering");
        }
        this.gvrApi = gvrApi;
        this.surfaceTextureManager = new SurfaceTextureManager(n);
    }

    public void setSurfaceView(GvrSurfaceView gvrSurfaceView) {
        if (gvrSurfaceView == null) {
            throw new IllegalArgumentException("GvrSurfaceView must be supplied for proper scanline rendering");
        }
        this.gvrSurfaceView = gvrSurfaceView;
    }

    public void setExternalSurfaceListener(int n, GvrLayout.ExternalSurfaceListener externalSurfaceListener, Handler handler) {
        this.surfaceTextureManager.setExternalSurfaceListener(n, externalSurfaceListener, handler);
    }

    public int getExternalSurfaceCount() {
        return this.surfaceTextureManager.getSurfaceCount();
    }

    public Surface getExternalSurface(int n) {
        return this.surfaceTextureManager.getSurface(n);
    }

    @Override
    public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
        Thread.currentThread().setPriority(10);
        AndroidNCompat.setVrThread(Process.myTid());
        this.gvrApi.onSurfaceCreatedReprojectionThread();
        this.surfaceTextureManager.initialize();
    }

    @Override
    public void onSurfaceChanged(GL10 gL10, int n, int n2) {
        if (this.surfaceTextureManager.isInitialized()) {
            this.surfaceTextureManager.attachAllToCurrentGLContext();
        }
    }

    @Override
    public void onDrawFrame(GL10 gL10) {
        this.updateManagedSurfaces();
        Point point = this.gvrApi.renderReprojectionThread();
        if (point != null) {
            this.setSurfaceSize(point.x, point.y);
        }
    }

    public void setSurfaceSize(final int n, final int n2) {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (n > 0 && n2 > 0) {
                    ScanlineRacingRenderer.this.gvrSurfaceView.getHolder().setFixedSize(n, n2);
                    return;
                }
                ScanlineRacingRenderer.this.gvrSurfaceView.getHolder().setSizeFromLayout();
            }
        });
    }

    public void onPause() {
        this.gvrApi.onPauseReprojectionThread();
        this.surfaceTextureManager.detachAllFromCurrentGLContext();
        this.gvrApi.removeAllSurfacesReprojectionThread();
    }

    public void shutdown() {
        this.surfaceTextureManager.shutdown();
    }

    private void updateManagedSurfaces() {
        for (int i = 0; i < this.surfaceTextureManager.getSurfaceCount(); ++i) {
            if (!this.surfaceTextureManager.updateSurfaceTexture(i)) continue;
            int n = this.surfaceTextureManager.getGLTextureHandle(i);
            float[] fArray = this.surfaceTextureManager.getUpdateSurfaceTextureTransformMatrix(i);
            long l = this.surfaceTextureManager.getUpdateSurfaceTextureTimestamp(i);
            this.gvrApi.updateSurfaceReprojectionThread(i, n, l, fArray);
        }
    }
}

