/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.util.Log;

public class NFCUtils {
    private static final String TAG = NFCUtils.class.getSimpleName();
    Context context;
    NfcAdapter nfcAdapter;
    BroadcastReceiver nfcBroadcastReceiver;
    IntentFilter[] nfcIntentFilters;

    public void onCreate(Activity activity) {
        this.context = activity.getApplicationContext();
        this.nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this.context);
        this.nfcBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                Log.i((String)TAG, (String)"Got an NFC tag!");
                NFCUtils.this.onNFCTagDetected((Tag)intent.getParcelableExtra("android.nfc.extra.TAG"));
            }
        };
        IntentFilter intentFilter = this.createNfcIntentFilter();
        intentFilter.addDataScheme("cardboard");
        IntentFilter intentFilter2 = this.createNfcIntentFilter();
        intentFilter2.addDataScheme("http");
        intentFilter2.addDataAuthority("goo.gl", null);
        IntentFilter intentFilter3 = this.createNfcIntentFilter();
        intentFilter3.addDataScheme("http");
        intentFilter3.addDataAuthority("google.com", null);
        intentFilter3.addDataPath("/cardboard/cfg.*", 2);
        this.nfcIntentFilters = new IntentFilter[]{intentFilter, intentFilter2, intentFilter3};
    }

    public void onResume(Activity activity) {
        activity.registerReceiver(this.nfcBroadcastReceiver, this.createNfcIntentFilter());
        Intent intent = new Intent("android.nfc.action.NDEF_DISCOVERED");
        intent.setPackage(activity.getPackageName());
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)0);
        if (this.isNFCEnabled()) {
            this.nfcAdapter.enableForegroundDispatch(activity, pendingIntent, this.nfcIntentFilters, null);
        }
    }

    public void onPause(Activity activity) {
        if (this.isNFCEnabled()) {
            this.nfcAdapter.disableForegroundDispatch(activity);
        }
        activity.unregisterReceiver(this.nfcBroadcastReceiver);
    }

    protected boolean isNFCEnabled() {
        return this.nfcAdapter != null && this.nfcAdapter.isEnabled();
    }

    protected void onNFCTagDetected(Tag tag) {
    }

    private IntentFilter createNfcIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.nfc.action.NDEF_DISCOVERED");
        intentFilter.addAction("android.nfc.action.TECH_DISCOVERED");
        intentFilter.addAction("android.nfc.action.TAG_DISCOVERED");
        return intentFilter;
    }
}

