/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.ContentProviderClient;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import android.net.Uri;
import android.os.RemoteException;
import android.util.Base64;
import android.util.Log;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.protobuf.nano.MessageNano;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.cardboard.VrSettingsProviderContract;
import com.google.vr.vrcore.nano.SdkConfiguration;
import com.google.vrtoolkit.cardboard.proto.nano.CardboardDevice;
import com.google.vrtoolkit.cardboard.proto.nano.Phone;
import com.google.vrtoolkit.cardboard.proto.nano.Preferences;

public class ContentProviderVrParamsProvider
implements VrParamsProvider {
    private static final String TAG = ContentProviderVrParamsProvider.class.getSimpleName();
    private final ContentProviderClient client;
    private final Uri deviceParamsSettingUri;
    private final Uri userPrefsUri;
    private final Uri phoneParamsSettingUri;
    private final Uri sdkConfigurationParamsSettingUri;

    public ContentProviderVrParamsProvider(ContentProviderClient contentProviderClient, String string2) {
        if (contentProviderClient == null) {
            throw new IllegalArgumentException("ContentProviderClient must not be null");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Authority key must be non-null and non-empty");
        }
        this.client = contentProviderClient;
        this.deviceParamsSettingUri = VrSettingsProviderContract.createUri(string2, "device_params");
        this.userPrefsUri = VrSettingsProviderContract.createUri(string2, "user_prefs");
        this.phoneParamsSettingUri = VrSettingsProviderContract.createUri(string2, "phone_params");
        this.sdkConfigurationParamsSettingUri = VrSettingsProviderContract.createUri(string2, "sdk_configuration_params");
    }

    @Override
    public CardboardDevice.DeviceParams readDeviceParams() {
        return this.readParams(CardboardDevice.DeviceParams.class, this.deviceParamsSettingUri, null);
    }

    @Override
    public boolean writeDeviceParams(CardboardDevice.DeviceParams deviceParams) {
        try {
            int n;
            if (deviceParams == null) {
                n = this.client.delete(this.deviceParamsSettingUri, null, null);
            } else {
                ContentValues contentValues = new ContentValues();
                byte[] byArray = MessageNano.toByteArray((MessageNano)deviceParams);
                contentValues.put("value", byArray);
                n = this.client.update(this.deviceParamsSettingUri, contentValues, null, null);
            }
            return n > 0;
        }
        catch (RemoteException remoteException) {
            Log.e((String)TAG, (String)"Failed to write device params to ContentProvider", (Throwable)remoteException);
            return false;
        }
        catch (SecurityException securityException) {
            Log.e((String)TAG, (String)"Insufficient permissions to write device params to ContentProvider", (Throwable)securityException);
            return false;
        }
    }

    @Override
    public Phone.PhoneParams readPhoneParams() {
        return this.readParams(Phone.PhoneParams.class, this.phoneParamsSettingUri, null);
    }

    @Override
    public SdkConfiguration.SdkConfigurationParams readSdkConfigurationParams(SdkConfiguration.SdkConfigurationRequest sdkConfigurationRequest) {
        String string2 = Base64.encodeToString((byte[])MessageNano.toByteArray((MessageNano)sdkConfigurationRequest), (int)0);
        return this.readParams(SdkConfiguration.SdkConfigurationParams.class, this.sdkConfigurationParamsSettingUri, string2);
    }

    @Override
    public Preferences.UserPrefs readUserPrefs() {
        return this.readParams(Preferences.UserPrefs.class, this.userPrefsUri, null);
    }

    @Override
    public void close() {
        this.client.release();
    }

    private <T extends MessageNano> T readParams(Class<T> clazz, Uri uri, String string2) {
        try {
            Cursor cursor = this.client.query(uri, null, string2, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                byte[] byArray = cursor.getBlob(0);
                if (byArray == null) {
                    return null;
                }
                return (T)MessageNano.mergeFrom((MessageNano)((MessageNano)clazz.newInstance()), (byte[])byArray);
            }
            String string3 = String.valueOf(uri);
            Log.e((String)TAG, (String)new StringBuilder(50 + String.valueOf(string3).length()).append("Invalid params result from ContentProvider query: ").append(string3).toString());
            return null;
        }
        catch (CursorIndexOutOfBoundsException | RemoteException | InvalidProtocolBufferNanoException | IllegalAccessException | IllegalArgumentException | InstantiationException throwable) {
            Log.e((String)TAG, (String)"Error reading params from ContentProvider", (Throwable)throwable);
            return null;
        }
    }
}

