/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.PowerManager;
import android.provider.Settings;
import android.util.Log;
import android.view.Window;
import com.google.vr.cardboard.R;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class AndroidNCompat {
    private static final String TAG = AndroidNCompat.class.getSimpleName();
    private static final boolean DEBUG = false;
    public static final int N_SDK_LEVEL = 24;
    public static final int NMR1_SDK_LEVEL = 25;
    private static final String DEFAULT_VR_MODE_PACKAGE = "com.google.vr.vrcore";
    private static final String DEFAULT_VR_MODE_CLASS = "com.google.vr.vrcore.common.VrCoreListenerService";
    private static final String ACTION_VR_LISTENER_SETTINGS = "android.settings.VR_LISTENER_SETTINGS";
    private static final String ENABLED_VR_LISTENERS = "enabled_vr_listeners";
    private static int sSdkLevelOverride = 0;
    private static final int SUCCESS = 0;
    private static final int PACKAGE_NOT_PRESENT = -1;
    private static final int PACKAGE_NOT_ENABLED = -2;
    public static final int FLAG_VR_MODE_ENABLE_FALLBACK = 1;

    public static boolean setVrModeEnabled(Activity activity, boolean bl) {
        return AndroidNCompat.setVrModeEnabled(activity, bl, 1);
    }

    public static boolean setVrModeEnabled(Activity activity, boolean bl, int n) {
        if (!AndroidNCompat.isAtLeastN()) {
            return false;
        }
        if (!activity.getPackageManager().hasSystemFeature("android.software.vr.mode")) {
            Log.d((String)TAG, (String)"VR mode is not supported on this device.");
            return false;
        }
        ComponentName componentName = new ComponentName(DEFAULT_VR_MODE_PACKAGE, DEFAULT_VR_MODE_CLASS);
        try {
            activity.setVrModeEnabled(bl, componentName);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)TAG, (String)new StringBuilder(25 + String.valueOf(string2).length()).append("No VR service component: ").append(string2).toString());
            if ((n & 1) != 0 && AndroidNCompat.handleVrCoreAbsence((Context)activity, AndroidNCompat.checkForVrCorePresence((Context)activity))) {
                Log.w((String)TAG, (String)"Failed to handle missing VrCore package.");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            String string3 = String.valueOf(unsupportedOperationException);
            Log.w((String)TAG, (String)new StringBuilder(23 + String.valueOf(string3).length()).append("Failed to set VR mode: ").append(string3).toString());
        }
        return false;
    }

    public static boolean setSustainedPerformanceMode(Activity activity, boolean bl) {
        if (!AndroidNCompat.isAtLeastN()) {
            return false;
        }
        PowerManager powerManager = (PowerManager)activity.getSystemService("power");
        if (!powerManager.isSustainedPerformanceModeSupported()) {
            Log.d((String)TAG, (String)"Sustained performance mode is not supported on this device.");
            return false;
        }
        Window window = activity.getWindow();
        if (window == null) {
            Log.e((String)TAG, (String)"Activity does not have a window");
            return false;
        }
        window.setSustainedPerformanceMode(bl);
        return true;
    }

    public static void setVrThread(int n) {
        Method method;
        if (!AndroidNCompat.isAtLeastN()) {
            return;
        }
        try {
            method = ActivityManager.class.getMethod("setVrThread", Integer.TYPE);
        }
        catch (NoSuchMethodException | RuntimeException exception) {
            if (AndroidNCompat.isAtLeastNMR1()) {
                String string2 = String.valueOf(exception);
                Log.e((String)TAG, (String)new StringBuilder(38 + String.valueOf(string2).length()).append("Failed to acquire setVrThread method: ").append(string2).toString());
                return;
            }
            String string3 = String.valueOf(exception);
            Log.w((String)TAG, (String)new StringBuilder(38 + String.valueOf(string3).length()).append("Failed to acquire setVrThread method: ").append(string3).toString());
            return;
        }
        try {
            method.invoke(null, n);
            return;
        }
        catch (IllegalAccessException | RuntimeException | InvocationTargetException exception) {
            String string4 = String.valueOf(exception);
            Log.e((String)TAG, (String)new StringBuilder(30 + String.valueOf(string4).length()).append("Failed to invoke setVrThread: ").append(string4).toString());
            return;
        }
    }

    public static void setSdkLevelForTesting(int n) {
        sSdkLevelOverride = n;
    }

    private static boolean isAtLeastN() {
        return sSdkLevelOverride >= 24 || Build.VERSION.SDK_INT >= 24;
    }

    private static boolean isAtLeastNMR1() {
        return sSdkLevelOverride >= 25 || "NMR1".equals(Build.VERSION.CODENAME) || Build.VERSION.SDK_INT >= 25;
    }

    private static int checkForVrCorePresence(Context context) {
        ApplicationInfo applicationInfo2;
        List list = context.getPackageManager().getInstalledApplications(0);
        boolean bl = false;
        for (ApplicationInfo applicationInfo2 : list) {
            if (!applicationInfo2.packageName.equals(DEFAULT_VR_MODE_PACKAGE)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return -1;
        }
        String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)ENABLED_VR_LISTENERS);
        applicationInfo2 = new ComponentName(DEFAULT_VR_MODE_PACKAGE, DEFAULT_VR_MODE_CLASS);
        if (string2 == null || !string2.contains(applicationInfo2.flattenToString())) {
            return -2;
        }
        return 0;
    }

    private static boolean handleVrCoreAbsence(final Context context, int n) {
        if (n == -1) {
            AndroidNCompat.showWarningDialog(context, R.string.dialog_vr_core_not_installed, R.string.go_to_playstore_button, new DialogInterface.OnClickListener(){

                public final void onClick(DialogInterface dialogInterface, int n) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)"market://details?id=com.google.vr.vrcore"));
                    intent.setPackage("com.android.vending");
                    try {
                        context.startActivity(intent);
                        return;
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        Log.e((String)TAG, (String)"Google Play Services is not installed, unable to download VrCore.");
                        return;
                    }
                }
            });
            return false;
        }
        if (n == -2) {
            AndroidNCompat.showWarningDialog(context, R.string.dialog_vr_core_not_enabled, R.string.go_to_vr_listeners_settings_button, new DialogInterface.OnClickListener(){

                public final void onClick(DialogInterface dialogInterface, int n) {
                    context.startActivity(new Intent(AndroidNCompat.ACTION_VR_LISTENER_SETTINGS));
                }
            });
            return false;
        }
        return true;
    }

    private static void showWarningDialog(Context context, int n, int n2, DialogInterface.OnClickListener onClickListener) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context, R.style.GvrDialogTheme);
        builder.setMessage(n).setTitle(R.string.dialog_title_warning).setPositiveButton(n2, onClickListener).setNegativeButton(R.string.cancel_button, new DialogInterface.OnClickListener(){

            public final void onClick(DialogInterface dialogInterface, int n) {
            }
        });
        builder.create().show();
    }

    private AndroidNCompat() {
    }
}

