/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.AutoValue_RecordType_Member;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeVisitor;
import com.google.template.soy.types.SoyTypes;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class RecordType
extends SoyType {
    private final ImmutableList<Member> members;
    private final ImmutableMap<String, Member> memberIndex;

    public static Member memberOf(String name, boolean optional, SoyType type) {
        return new AutoValue_RecordType_Member(name, optional, type);
    }

    private RecordType(Iterable<Member> members) {
        this.members = ImmutableList.copyOf(members);
        this.memberIndex = (ImmutableMap)Streams.stream(members).collect(ImmutableMap.toImmutableMap(Member::name, m -> m));
    }

    public static RecordType of(ImmutableMap<String, ? extends SoyType> members) {
        Preconditions.checkArgument((!(members instanceof NavigableMap) ? 1 : 0) != 0);
        return new RecordType(members.entrySet().stream().map(e -> RecordType.memberOf((String)e.getKey(), false, (SoyType)e.getValue())).collect(Collectors.toList()));
    }

    public static RecordType of(Iterable<Member> members) {
        return new RecordType(members);
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.RECORD;
    }

    @Override
    boolean doIsAssignableFromNonUnionType(SoyType srcType, SoyType.UnknownAssignmentPolicy policy) {
        if (srcType.getKind() == SoyType.Kind.RECORD) {
            RecordType srcRecord = (RecordType)srcType;
            for (Member mine : this.members) {
                SoyType theirType = srcRecord.getMemberType(mine.name());
                if (!(theirType == null ? !mine.optional() : !mine.checkedType().isAssignableFromInternal(theirType, policy))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ImmutableList<Member> getMembers() {
        return this.members;
    }

    @Nullable
    public Member getMember(String fieldName) {
        return (Member)this.memberIndex.get((Object)fieldName);
    }

    @Nullable
    public SoyType getMemberType(String fieldName) {
        Member member = (Member)this.memberIndex.get((Object)fieldName);
        return member != null ? member.checkedType() : null;
    }

    public Iterable<String> getMemberNames() {
        return this.members.stream().map(Member::name).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Member member : this.members) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(member.name());
            if (member.optional()) {
                sb.append("?");
            }
            sb.append(": ");
            sb.append(member.declaredType());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    void doToProto(SoyTypeP.Builder builder) {
        SoyTypeP.RecordTypeP.Builder recordBuilder = builder.getRecordBuilder();
        for (Member member : this.members) {
            recordBuilder.addMembers(SoyTypeP.RecordMemberP.newBuilder().setName(member.name()).setOptional(member.optional()).setType(member.declaredType().toProto()));
        }
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && ((RecordType)other).members.equals(this.members);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.members);
    }

    @Override
    public <T> T accept(SoyTypeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @AutoValue
    public static abstract class Member {
        public abstract String name();

        public abstract boolean optional();

        public abstract SoyType declaredType();

        @Memoized
        public SoyType checkedType() {
            return this.optional() ? SoyTypes.makeUndefinable(this.declaredType()) : this.declaredType();
        }
    }
}

