/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.AutoValue_TemplateDelegateNode_DelTemplateKey;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import javax.annotation.Nullable;

public final class TemplateDelegateNode
extends TemplateNode {
    private static final SoyErrorKind INVALID_VARIANT_STRING = SoyErrorKind.of("Invalid variant ''{0}'' string literal must be an identifier.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_VARIANT_INTEGER = SoyErrorKind.of("Invalid variant ''{0}'' integer literal must non-negative.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_VARIANT_EXPR = SoyErrorKind.of("Invalid variant expression with kind {0}; must be a string, int, or proto enum literal.", new SoyErrorKind.StyleAllowance[0]);
    public static final String VARIANT_ATTR = "variant";
    private final String delTemplateName;
    private DelTemplateKey delTemplateKey;
    private final TemplateNode.Priority delPriority;

    TemplateDelegateNode(TemplateDelegateNodeBuilder nodeBuilder, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String delTemplateName, TemplateNode.Priority delPriority, ImmutableList<TemplateHeaderVarDefn> params) {
        super(nodeBuilder, "deltemplate", soyFileHeaderInfo, Visibility.PUBLIC, params);
        this.delTemplateName = (String)Preconditions.checkNotNull((Object)delTemplateName);
        this.delPriority = (TemplateNode.Priority)((Object)Preconditions.checkNotNull((Object)((Object)delPriority)));
    }

    private TemplateDelegateNode(TemplateDelegateNode orig, CopyState copyState) {
        super(orig, copyState);
        this.delTemplateName = orig.delTemplateName;
        this.delTemplateKey = orig.delTemplateKey;
        this.delPriority = orig.delPriority;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.TEMPLATE_DELEGATE_NODE;
    }

    public String getDelTemplateName() {
        return this.delTemplateName;
    }

    @Override
    public String getTemplateNameForUserMsgs() {
        return this.getDelTemplateKey().toString();
    }

    public String getDelTemplateVariant() {
        return this.getDelTemplateKey().variant();
    }

    @VisibleForTesting
    DelTemplateKey getDelTemplateKey() {
        if (this.delTemplateKey != null) {
            return this.delTemplateKey;
        }
        return this.resolveVariantExpression();
    }

    public TemplateNode.Priority getDelPriority() {
        return this.delPriority;
    }

    @Override
    public TemplateDelegateNode copy(CopyState copyState) {
        return new TemplateDelegateNode(this, copyState);
    }

    private DelTemplateKey resolveVariantExpression() {
        ExprRootNode delTemplateVariantExpr = this.delTemplateVariantExpr();
        if (delTemplateVariantExpr == null) {
            this.delTemplateKey = DelTemplateKey.create(this.delTemplateName, "");
            return this.delTemplateKey;
        }
        ExprNode exprNode = delTemplateVariantExpr.getRoot();
        if (exprNode instanceof GlobalNode) {
            GlobalNode globalNode = (GlobalNode)exprNode;
            return DelTemplateKey.create(this.delTemplateName, globalNode.getName());
        }
        this.delTemplateKey = DelTemplateKey.create(this.delTemplateName, TemplateNode.variantExprToString(exprNode));
        return this.delTemplateKey;
    }

    @Nullable
    private ExprRootNode delTemplateVariantExpr() {
        return this.getAttributes().stream().filter(a -> VARIANT_ATTR.equals(a.getName().identifier()) && a.hasExprValue()).findFirst().map(a -> (ExprRootNode)a.valueAsExprList().get(0)).orElse(null);
    }

    public void validateVariantExpression(ErrorReporter errorReporter) {
        this.getAttributes().stream().filter(a -> VARIANT_ATTR.equals(a.getName().identifier())).forEach(a -> TemplateDelegateNode.validateVariantExpression(a.valueAsExpr(errorReporter).getRoot(), errorReporter));
    }

    private static void validateVariantExpression(ExprNode primitiveNode, ErrorReporter reporter) {
        switch (primitiveNode.getKind()) {
            case STRING_NODE: {
                StringNode sn = (StringNode)primitiveNode;
                if (sn.getValue().isEmpty() || BaseUtils.isIdentifier(sn.getValue())) break;
                reporter.report(sn.getSourceLocation(), INVALID_VARIANT_STRING, sn.getValue());
                break;
            }
            case INTEGER_NODE: {
                IntegerNode in = (IntegerNode)primitiveNode;
                if (in.getValue() >= 0L) break;
                reporter.report(in.getSourceLocation(), INVALID_VARIANT_INTEGER, in.getValue());
                break;
            }
            case PROTO_ENUM_VALUE_NODE: {
                break;
            }
            default: {
                reporter.report(primitiveNode.getSourceLocation(), INVALID_VARIANT_EXPR, new Object[]{primitiveNode.getKind()});
            }
        }
    }

    @AutoValue
    @VisibleForTesting
    public static abstract class DelTemplateKey {
        static DelTemplateKey create(String name, String variant) {
            return new AutoValue_TemplateDelegateNode_DelTemplateKey(name, variant);
        }

        abstract String name();

        abstract String variant();

        public final String toString() {
            return this.name() + (String)(this.variant().isEmpty() ? "" : ":" + this.variant());
        }
    }
}

