/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TemplateType;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TagName {
    private static final ImmutableSet<String> VOID_TAG_NAMES = ImmutableSet.of((Object)"area", (Object)"base", (Object)"basefont", (Object)"br", (Object)"col", (Object)"command", (Object[])new String[]{"embed", "hr", "img", "input", "isindex", "keygen", "link", "meta", "param", "plaintext", "source", "track", "wbr"});
    private static final ImmutableSet<String> INLINE_TAG_NAME = ImmutableSet.of((Object)"a", (Object)"abbr", (Object)"acronym", (Object)"b", (Object)"bdo", (Object)"big", (Object[])new String[]{"br", "button", "cite", "code", "dfn", "em", "i", "img", "input", "kbd", "label", "map", "object", "output", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "time", "tt", "var"});
    private static final ImmutableSetMultimap<String, String> OPTIONAL_TAG_CLOSE_TAG_RULES = new ImmutableSetMultimap.Builder().putAll((Object)"head", (Object[])new String[]{"body", "html"}).put((Object)"body", (Object)"html").putAll((Object)"li", (Object[])new String[]{"ul", "ol"}).put((Object)"dt", (Object)"dl").put((Object)"dd", (Object)"dl").put((Object)"rb", (Object)"ruby").put((Object)"rt", (Object)"ruby").put((Object)"rtc", (Object)"ruby").put((Object)"rp", (Object)"ruby").put((Object)"optgroup", (Object)"select").putAll((Object)"option", (Object[])new String[]{"select", "datalist", "optgroup"}).put((Object)"colgroup", (Object)"table").put((Object)"thead", (Object)"table").put((Object)"tbody", (Object)"table").put((Object)"tfoot", (Object)"table").putAll((Object)"tr", (Object[])new String[]{"thead", "tbody", "tfoot", "table"}).putAll((Object)"td", (Object[])new String[]{"tr", "thead", "tbody", "tfoot", "table"}).putAll((Object)"th", (Object[])new String[]{"tr", "thead", "tbody", "tfoot", "table"}).build();
    private static final ImmutableSet<String> PTAG_CLOSE_EXCEPTIONS = ImmutableSet.of((Object)"a", (Object)"audio", (Object)"del", (Object)"ins", (Object)"map", (Object)"noscript", (Object[])new String[]{"video"});
    private static final ImmutableSet<String> HTML_OPEN_TAG_EXCLUDE_SET = ImmutableSet.of((Object)"head", (Object)"body", (Object)"html");
    private static final ImmutableSet<String> FOCUSABLE_TAG_NAMES = ImmutableSet.of((Object)"a", (Object)"input", (Object)"textarea", (Object)"select", (Object)"button");
    public static final String WILDCARD = "";
    private static final ImmutableSetMultimap<String, String> OPTIONAL_TAG_OPEN_CLOSE_RULES = new ImmutableSetMultimap.Builder().put((Object)"li", (Object)"li").putAll((Object)"dt", (Object[])new String[]{"dt", "dd"}).putAll((Object)"dd", (Object[])new String[]{"dd", "dt"}).putAll((Object)"rt", (Object[])new String[]{"rt", "rp"}).putAll((Object)"rp", (Object[])new String[]{"rp", "rt"}).put((Object)"optgroup", (Object)"optgroup").putAll((Object)"option", (Object[])new String[]{"option", "optgroup"}).putAll((Object)"p", (Object[])new String[]{"p"}).putAll((Object)"thead", (Object[])new String[]{"tbody", "tfoot"}).putAll((Object)"tbody", (Object[])new String[]{"tbody", "tfoot"}).put((Object)"tfoot", (Object)"table").put((Object)"tr", (Object)"tr").putAll((Object)"td", (Object[])new String[]{"tr", "th", "td"}).putAll((Object)"th", (Object[])new String[]{"td", "th"}).build();
    private final SoyNode.StandaloneNode node;
    @Nullable
    private final String nameAsLowerCase;
    @Nullable
    private final RcDataTagName rcDataTagName;

    public TagName(RawTextNode node) {
        this.node = (SoyNode.StandaloneNode)Preconditions.checkNotNull((Object)node);
        switch (this.nameAsLowerCase = Ascii.toLowerCase((String)node.getRawText())) {
            case "script": {
                this.rcDataTagName = RcDataTagName.SCRIPT;
                break;
            }
            case "style": {
                this.rcDataTagName = RcDataTagName.STYLE;
                break;
            }
            case "textarea": {
                this.rcDataTagName = RcDataTagName.TEXTAREA;
                break;
            }
            case "title": {
                this.rcDataTagName = RcDataTagName.TITLE;
                break;
            }
            case "xmp": {
                this.rcDataTagName = RcDataTagName.XMP;
                break;
            }
            default: {
                this.rcDataTagName = null;
            }
        }
    }

    public TagName(PrintNode node) {
        this.node = (SoyNode.StandaloneNode)Preconditions.checkNotNull((Object)node);
        this.nameAsLowerCase = null;
        this.rcDataTagName = null;
    }

    public boolean isStatic() {
        return this.node instanceof RawTextNode;
    }

    public boolean isLegacyDynamicTagName() {
        if (this.isStatic()) {
            return false;
        }
        ExprNode root = this.getDynamicTagName().getExpr().getRoot();
        return root instanceof FunctionNode && ((FunctionNode)root).isResolved() && ((FunctionNode)root).getSoyFunction() == BuiltinFunction.LEGACY_DYNAMIC_TAG;
    }

    public boolean isTemplateCall() {
        return !this.isStatic() && !this.isLegacyDynamicTagName() && this.getDynamicTagName().getExpr().getType() != null && this.getDynamicTagName().getExpr().getType().getKind() == SoyType.Kind.TEMPLATE;
    }

    public boolean isWildCard() {
        return this.node instanceof RawTextNode && Objects.equals(((RawTextNode)this.node).getRawText(), WILDCARD);
    }

    public boolean isDefinitelyVoid() {
        return TagName.isDefinitelyVoid(this.nameAsLowerCase);
    }

    public static boolean isDefinitelyVoid(String tagName) {
        return VOID_TAG_NAMES.contains((Object)tagName);
    }

    public boolean isDefinitelyInline() {
        return INLINE_TAG_NAME.contains((Object)this.nameAsLowerCase);
    }

    public boolean isExcludedOptionalTag() {
        return HTML_OPEN_TAG_EXCLUDE_SET.contains((Object)this.nameAsLowerCase);
    }

    public boolean isDefinitelyOptional() {
        return OPTIONAL_TAG_CLOSE_TAG_RULES.containsKey((Object)this.nameAsLowerCase) || OPTIONAL_TAG_OPEN_CLOSE_RULES.containsKey((Object)this.nameAsLowerCase) || "html".equals(this.nameAsLowerCase);
    }

    public boolean isFocusable() {
        return FOCUSABLE_TAG_NAMES.contains((Object)this.nameAsLowerCase);
    }

    public static boolean checkCloseTagClosesOptional(TagName closeTag, TagName optionalOpenTag) {
        String closeTagName;
        if (!optionalOpenTag.isStatic() || !optionalOpenTag.isDefinitelyOptional()) {
            return false;
        }
        if (!closeTag.isStatic()) {
            return true;
        }
        String openTagName = optionalOpenTag.getStaticTagNameAsLowerCase();
        Preconditions.checkArgument((!openTagName.equals(closeTagName = closeTag.getStaticTagNameAsLowerCase()) ? 1 : 0) != 0);
        if ("p".equals(openTagName)) {
            return !PTAG_CLOSE_EXCEPTIONS.contains((Object)closeTagName);
        }
        return OPTIONAL_TAG_CLOSE_TAG_RULES.containsEntry((Object)openTagName, (Object)closeTagName);
    }

    public static boolean checkOpenTagClosesOptional(TagName openTag, TagName optionalOpenTag) {
        Preconditions.checkArgument((boolean)optionalOpenTag.isDefinitelyOptional(), (Object)"Open tag is not optional.");
        if (!openTag.isStatic() || !optionalOpenTag.isStatic()) {
            return false;
        }
        String optionalTagName = optionalOpenTag.getStaticTagNameAsLowerCase();
        String openTagName = openTag.getStaticTagNameAsLowerCase();
        return OPTIONAL_TAG_OPEN_CLOSE_RULES.containsEntry((Object)optionalTagName, (Object)openTagName);
    }

    public boolean isForeignContent() {
        return "svg".equals(this.nameAsLowerCase);
    }

    @Nullable
    public RcDataTagName getRcDataTagName() {
        return this.rcDataTagName;
    }

    public String getTagString() {
        if (this.isStatic()) {
            return this.getStaticTagName();
        }
        if (this.isTemplateCall()) {
            TemplateType templateType = (TemplateType)this.getDynamicTagName().getExpr().getType();
            return ((TemplateContentKind.ElementContentKind)templateType.getContentKind()).getTagName();
        }
        return null;
    }

    public String getStaticTagName() {
        Preconditions.checkState((boolean)this.isStatic());
        return ((RawTextNode)this.node).getRawText();
    }

    public String getStaticTagNameAsLowerCase() {
        Preconditions.checkState((boolean)this.isStatic());
        return this.nameAsLowerCase;
    }

    public SoyNode.StandaloneNode getNode() {
        return this.node;
    }

    public PrintNode getDynamicTagName() {
        Preconditions.checkState((!this.isStatic() ? 1 : 0) != 0);
        return (PrintNode)this.node;
    }

    public SourceLocation getTagLocation() {
        return this.node.getSourceLocation();
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof TagName) {
            TagName tag = (TagName)other;
            if (this.isStatic() != tag.isStatic()) {
                return false;
            }
            if (this.isStatic()) {
                return this.nameAsLowerCase.equals(tag.nameAsLowerCase);
            }
            return PrintNode.PrintEquivalence.get().equivalent((PrintNode)this.node, (PrintNode)tag.node);
        }
        return false;
    }

    public int hashCode() {
        return this.isStatic() ? this.nameAsLowerCase.hashCode() : PrintNode.PrintEquivalence.get().hash((PrintNode)this.node);
    }

    public String toString() {
        return this.node.toSourceString();
    }

    public static enum RcDataTagName {
        SCRIPT,
        STYLE,
        TITLE,
        TEXTAREA,
        XMP;


        public String toString() {
            return Ascii.toLowerCase((String)this.name());
        }
    }
}

