/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;

public final class SwitchCaseNode
extends CaseOrDefaultNode
implements SoyNode.ConditionalBlockNode,
SoyNode.ExprHolderNode {
    private final ImmutableList<ExprRootNode> exprList;

    public SwitchCaseNode(int id, SourceLocation location, SourceLocation openTagLocation, ImmutableList<ExprNode> exprList) {
        super(id, location, openTagLocation, "case");
        this.exprList = ExprRootNode.wrap(exprList);
    }

    private SwitchCaseNode(SwitchCaseNode orig, CopyState copyState) {
        super(orig, copyState);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ExprRootNode origExpr : orig.exprList) {
            builder.add((Object)origExpr.copy(copyState));
        }
        this.exprList = builder.build();
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SWITCH_CASE_NODE;
    }

    @Override
    public String getCommandText() {
        return SoyTreeUtils.toSourceString(this.exprList);
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return this.exprList;
    }

    @Override
    public SwitchCaseNode copy(CopyState copyState) {
        return new SwitchCaseNode(this, copyState);
    }
}

