/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.AbstractNodeVisitor;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.MapLiteralFromListNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.internal.util.TreeStreams;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.types.ast.FunctionTypeNode;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TemplateTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeVisitor;
import com.google.template.soy.types.ast.UnionTypeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class SoyTreeUtils {
    static final ImmutableSet<SoyNode.Kind> NODES_THAT_DONT_CONTRIBUTE_OUTPUT = Sets.immutableEnumSet((Enum)SoyNode.Kind.LET_CONTENT_NODE, (Enum[])new SoyNode.Kind[]{SoyNode.Kind.LET_VALUE_NODE, SoyNode.Kind.DEBUGGER_NODE, SoyNode.Kind.LOG_NODE});
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private static final TypeNodeVisitor<List<? extends TypeNode>> TRAVERSING = new TypeNodeVisitor<List<? extends TypeNode>>(){

        @Override
        public ImmutableList<? extends TypeNode> visit(NamedTypeNode node) {
            return ImmutableList.of();
        }

        @Override
        public ImmutableList<? extends TypeNode> visit(GenericTypeNode node) {
            return node.arguments();
        }

        @Override
        public ImmutableList<? extends TypeNode> visit(UnionTypeNode node) {
            return node.candidates();
        }

        @Override
        public ImmutableList<? extends TypeNode> visit(RecordTypeNode node) {
            return (ImmutableList)node.properties().stream().map(RecordTypeNode.Property::type).collect(ImmutableList.toImmutableList());
        }

        @Override
        public ImmutableList<? extends TypeNode> visit(TemplateTypeNode node) {
            ImmutableList.Builder types = ImmutableList.builder();
            types.add((Object)node.returnType());
            node.parameters().forEach(p -> types.add((Object)p.type()));
            return types.build();
        }

        @Override
        public ImmutableList<? extends TypeNode> visit(FunctionTypeNode node) {
            ImmutableList.Builder types = ImmutableList.builder();
            types.add((Object)node.returnType());
            node.parameters().forEach(p -> types.add((Object)p.type()));
            return types.build();
        }
    };

    private SoyTreeUtils() {
    }

    @SafeVarargs
    public static boolean hasNodesOfType(Node node, Class<? extends Node> ... types) {
        return SoyTreeUtils.allNodes(node).anyMatch(n -> {
            for (Class type : types) {
                if (!type.isInstance(n)) continue;
                return true;
            }
            return false;
        });
    }

    public static SoyNode nextSibling(SoyNode node) {
        return (SoyNode)SoyTreeUtils.nextSiblingNode(node);
    }

    @Nullable
    public static Node nextSiblingNode(Node node) {
        ParentNode<?> parent = node.getParent();
        if (parent == null) {
            return null;
        }
        int index = parent.getChildIndex(node);
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0);
        int nextIndex = index + 1;
        return parent.numChildren() > nextIndex ? (Node)parent.getChild(nextIndex) : null;
    }

    private static VisitDirective visitAll(Node n) {
        return VisitDirective.CONTINUE;
    }

    private static VisitDirective visitNonExpr(Node n) {
        return n instanceof ExprNode ? VisitDirective.SKIP_CHILDREN : VisitDirective.CONTINUE;
    }

    public static void visitAllNodes(Node node, NodeVisitor<? super Node, VisitDirective> visitor) {
        long unused = SoyTreeUtils.allNodes(node, visitor).count();
    }

    public static Stream<? extends Node> ancestors(Node root) {
        return TreeStreams.ancestor(root, Node::getParent);
    }

    public static Stream<? extends Node> allNodes(Node node) {
        return SoyTreeUtils.allNodes(node, SoyTreeUtils::visitAll);
    }

    public static Stream<? extends Node> allNodes(Node root, NodeVisitor<? super Node, VisitDirective> visitor) {
        return TreeStreams.breadthFirst(root, next -> {
            if (visitor.exec((Node)next) == VisitDirective.CONTINUE) {
                if (next instanceof ParentNode) {
                    if (next instanceof SoyNode.ExprHolderNode) {
                        return Iterables.concat(((ParentNode)next).getChildren(), ((SoyNode.ExprHolderNode)next).getExprList());
                    }
                    return ((ParentNode)next).getChildren();
                }
                if (next instanceof SoyNode.ExprHolderNode) {
                    return ((SoyNode.ExprHolderNode)next).getExprList();
                }
            }
            return ImmutableList.of();
        });
    }

    public static <T extends Node> Stream<T> allNodesOfType(Node rootSoyNode, Class<T> classObject) {
        boolean exploreExpressions = ExprNode.class.isAssignableFrom(classObject);
        return SoyTreeUtils.allNodesOfType(rootSoyNode, classObject, exploreExpressions ? SoyTreeUtils::visitAll : SoyTreeUtils::visitNonExpr);
    }

    public static Stream<ExprRootNode> allExprRootNodes(SoyNode root) {
        return SoyTreeUtils.allNodesOfType(root, SoyNode.ExprHolderNode.class).flatMap(n -> n.getExprList().stream());
    }

    public static <T extends Node> Stream<T> allNodesOfType(Node rootSoyNode, Class<T> classObject, NodeVisitor<? super Node, VisitDirective> visitor) {
        return SoyTreeUtils.allNodes(rootSoyNode, visitor).filter(classObject::isInstance).map(classObject::cast);
    }

    public static <T extends Node> ImmutableList<T> getAllNodesOfType(Node rootSoyNode, Class<T> classObject) {
        return (ImmutableList)SoyTreeUtils.allNodesOfType(rootSoyNode, classObject).collect(ImmutableList.toImmutableList());
    }

    public static Stream<FunctionNode> allFunctionInvocations(Node rootSoyNode, SoyFunction functionToMatch) {
        return SoyTreeUtils.allNodesOfType(rootSoyNode, FunctionNode.class).filter(function -> function.isResolved() && functionToMatch.equals(function.getSoyFunction()));
    }

    public static void visitExprNodesWithHolder(SoyNode root, BiConsumer<SoyNode.ExprHolderNode, ExprNode> visitor) {
        SoyTreeUtils.visitExprNodesWithHolder(root, ExprNode.class, visitor);
    }

    public static <T extends ExprNode> void visitExprNodesWithHolder(SoyNode root, Class<T> exprType, BiConsumer<SoyNode.ExprHolderNode, T> visitor) {
        SoyTreeUtils.allNodesOfType(root, SoyNode.ExprHolderNode.class).forEach(exprHolder -> exprHolder.getExprList().stream().flatMap(rootExpr -> SoyTreeUtils.allNodesOfType(rootExpr, exprType)).forEach(expr -> visitor.accept((SoyNode.ExprHolderNode)exprHolder, (Object)expr)));
    }

    public static String buildAstString(SoyNode.ParentSoyNode<?> node) {
        return SoyTreeUtils.buildAstStringHelper(node, 0, new StringBuilder()).toString();
    }

    public static String buildAstString(ExprNode.ParentExprNode node) {
        return SoyTreeUtils.buildAstStringHelper(node, 0, new StringBuilder()).toString();
    }

    private static StringBuilder buildAstStringHelper(ParentNode<?> node, int indent, StringBuilder sb) {
        for (Node child : node.getChildren()) {
            sb.append("  ".repeat(indent)).append(child.getKind()).append('\n');
            if (!(child instanceof ParentNode)) continue;
            SoyTreeUtils.buildAstStringHelper((ParentNode)child, indent + 1, sb);
        }
        return sb;
    }

    public static <R> void execOnAllV2Exprs(SoyNode node, AbstractNodeVisitor<ExprNode, R> exprNodeVisitor) {
        SoyTreeUtils.allNodes(node, SoyTreeUtils::visitNonExpr).filter(n -> n instanceof SoyNode.ExprHolderNode).map(SoyNode.ExprHolderNode.class::cast).flatMap(n -> n.getExprList().stream()).forEach(exprNodeVisitor::exec);
    }

    public static <T extends SoyNode> T cloneWithNewIds(T origNode, IdGenerator nodeIdGen) {
        SoyNode clone = origNode.copy(new CopyState());
        new GenNewIdsVisitor(nodeIdGen).exec(clone);
        return (T)clone;
    }

    public static <T extends SoyNode> List<T> cloneListWithNewIds(List<T> origNodes, IdGenerator nodeIdGen) {
        Preconditions.checkNotNull(origNodes);
        ArrayList<SoyNode> clones = new ArrayList<SoyNode>(origNodes.size());
        for (SoyNode origNode : origNodes) {
            SoyNode clone = origNode.copy(new CopyState());
            new GenNewIdsVisitor(nodeIdGen).exec(clone);
            clones.add(clone);
        }
        return clones;
    }

    public static boolean isDescendantOf(Node node, Node ancestor) {
        if (node instanceof ExprNode) {
            ExprNode nodeAsExpr = (ExprNode)node;
            if (ancestor instanceof ExprNode) {
                return SoyTreeUtils.isDescendantOf(nodeAsExpr, (ExprNode)ancestor);
            }
            return SoyTreeUtils.isDescendantOf(nodeAsExpr, (SoyNode)ancestor);
        }
        if (ancestor instanceof ExprNode) {
            return false;
        }
        return SoyTreeUtils.isDescendantOf((SoyNode)node, (SoyNode)ancestor);
    }

    public static boolean isDescendantOf(SoyNode node, SoyNode ancestor) {
        return SoyTreeUtils.doIsDescendantOf(node, ancestor);
    }

    public static boolean isDescendantOf(ExprNode node, ExprNode ancestor) {
        return SoyTreeUtils.doIsDescendantOf(node, ancestor);
    }

    public static boolean isDescendantOf(ExprNode node, SoyNode ancestor) {
        while (node.getParent() != null) {
            node = node.getParent();
        }
        ExprNode nodeRoot = node;
        return SoyTreeUtils.allNodesOfType(ancestor, SoyNode.ExprHolderNode.class).flatMap(holder -> holder.getExprList().stream()).anyMatch(root -> root == nodeRoot);
    }

    private static boolean doIsDescendantOf(Node node, Node ancestor) {
        while (node != null) {
            if (ancestor == node) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public static String toSourceString(List<? extends Node> nodes) {
        ArrayList<String> strings = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            strings.add(node.toSourceString());
        }
        return COMMA_JOINER.join(strings);
    }

    private static boolean isNonConstant(ExprNode expr) {
        switch (expr.getKind()) {
            case VAR_REF_NODE: {
                VarRefNode refNode = (VarRefNode)expr;
                VarDefn varDefs = refNode.getDefnDecl();
                if (varDefs != null && (varDefs.kind() == VarDefn.Kind.CONST || varDefs.kind() == VarDefn.Kind.IMPORT_VAR)) {
                    return false;
                }
                if (refNode.hasType()) {
                    switch (refNode.getType().getKind()) {
                        case TEMPLATE_TYPE: 
                        case TEMPLATE_MODULE: 
                        case PROTO_TYPE: 
                        case PROTO_ENUM_TYPE: 
                        case PROTO_MODULE: {
                            return false;
                        }
                    }
                    return true;
                }
                return true;
            }
            case FUNCTION_NODE: {
                return !((FunctionNode)expr).isPure();
            }
        }
        return false;
    }

    public static boolean isConstantExpr(ExprNode rootSoyNode) {
        return SoyTreeUtils.allNodes(rootSoyNode).map(ExprNode.class::cast).noneMatch(SoyTreeUtils::isNonConstant);
    }

    public static ImmutableList<ExprNode> getNonConstantChildren(ExprNode rootSoyNode) {
        return (ImmutableList)SoyTreeUtils.allNodes(rootSoyNode).map(ExprNode.class::cast).filter(SoyTreeUtils::isNonConstant).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    public static HtmlTagNode getNodeAsHtmlTagNode(SoyNode node, boolean openTag) {
        MsgHtmlTagNode msgHtmlTagNode;
        MsgPlaceholderNode placeholderNode;
        SoyNode.Kind tagKind;
        if (node == null) {
            return null;
        }
        SoyNode.Kind kind = tagKind = openTag ? SoyNode.Kind.HTML_OPEN_TAG_NODE : SoyNode.Kind.HTML_CLOSE_TAG_NODE;
        if (NODES_THAT_DONT_CONTRIBUTE_OUTPUT.contains((Object)node.getKind())) {
            return SoyTreeUtils.getNodeAsHtmlTagNode(SoyTreeUtils.nextSibling(node), openTag);
        }
        if (node.getKind() == tagKind) {
            return (HtmlTagNode)node;
        }
        if (node.getKind() == SoyNode.Kind.MSG_PLACEHOLDER_NODE && (placeholderNode = (MsgPlaceholderNode)node).numChildren() == 1 && ((SoyNode.StandaloneNode)placeholderNode.getChild(0)).getKind() == SoyNode.Kind.MSG_HTML_TAG_NODE && (msgHtmlTagNode = (MsgHtmlTagNode)placeholderNode.getChild(0)).numChildren() == 1 && ((SoyNode.StandaloneNode)msgHtmlTagNode.getChild(0)).getKind() == tagKind) {
            return (HtmlTagNode)msgHtmlTagNode.getChild(0);
        }
        return null;
    }

    public static Stream<? extends TypeNode> allTypeNodes(TypeNode root) {
        return TreeStreams.breadthFirst(root, next -> next.accept(TRAVERSING));
    }

    public static Stream<TypeNode> allTypeNodes(SoyNode root) {
        return SoyTreeUtils.allNodes(root, SoyTreeUtils::visitNonExpr).flatMap(node -> {
            if (node instanceof TemplateNode) {
                TemplateNode templateNode = (TemplateNode)node;
                return templateNode.getHeaderParams().stream().map(TemplateHeaderVarDefn::getTypeNode).filter(Objects::nonNull);
            }
            if (node instanceof ExternNode) {
                return Stream.of(((ExternNode)node).typeNode());
            }
            return Stream.of(new TypeNode[0]);
        });
    }

    public static ExprNodeToHolderIndex buildExprNodeToHolderIndex(SoyNode root) {
        return new ExprNodeToHolderIndex(root);
    }

    public static class ExprNodeToHolderIndex {
        private final ImmutableMap<ExprRootNode, SoyNode.ExprHolderNode> index;

        ExprNodeToHolderIndex(SoyNode root) {
            ImmutableMap.Builder index = ImmutableMap.builder();
            SoyTreeUtils.allNodesOfType(root, SoyNode.ExprHolderNode.class).forEach(holder -> {
                for (ExprRootNode exprRoot : holder.getExprList()) {
                    index.put((Object)exprRoot, holder);
                }
            });
            this.index = index.buildOrThrow();
        }

        SoyNode.ExprHolderNode getHolder(ExprRootNode root) {
            return (SoyNode.ExprHolderNode)Preconditions.checkNotNull((Object)((SoyNode.ExprHolderNode)this.index.get((Object)root)));
        }

        public SoyNode.ExprHolderNode getHolder(ExprNode node) {
            while (node.getParent() != null) {
                node = node.getParent();
            }
            return this.getHolder((ExprRootNode)node);
        }

        @Nullable
        public SoyNode.ExprHolderNode getNullableHolder(ExprNode node) {
            while (node.getParent() != null) {
                node = node.getParent();
            }
            return (SoyNode.ExprHolderNode)this.index.get((Object)((ExprRootNode)node));
        }
    }

    private static class GenNewIdsExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final IdGenerator nodeIdGen;

        public GenNewIdsExprVisitor(IdGenerator nodeIdGen) {
            this.nodeIdGen = nodeIdGen;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        @Override
        protected void visitListComprehensionNode(ListComprehensionNode node) {
            node.setNodeId(this.nodeIdGen.genId());
            this.visitChildren(node);
        }

        @Override
        protected void visitMapLiteralFromListNode(MapLiteralFromListNode node) {
            node.setNodeId(this.nodeIdGen.genId());
            this.visitChildren(node);
        }
    }

    private static class GenNewIdsVisitor
    extends AbstractNodeVisitor<SoyNode, Void> {
        private final IdGenerator nodeIdGen;

        public GenNewIdsVisitor(IdGenerator nodeIdGen) {
            this.nodeIdGen = nodeIdGen;
        }

        @Override
        protected void visit(SoyNode node) {
            node.setId(this.nodeIdGen.genId());
            if (node instanceof SoyNode.ExprHolderNode) {
                SoyNode.ExprHolderNode exprHolderNode = (SoyNode.ExprHolderNode)node;
                for (ExprRootNode expr : exprHolderNode.getExprList()) {
                    new GenNewIdsExprVisitor(this.nodeIdGen).exec(expr);
                }
            }
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }

    public static enum VisitDirective {
        SKIP_CHILDREN,
        CONTINUE;

    }
}

