/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.Comment;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.ImportsContext;
import com.google.template.soy.soytree.ModNameDeclaration;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Optional;
import javax.annotation.Nullable;

public final class SoyFileNode
extends AbstractParentSoyNode<SoyNode>
implements SoyNode.SplitLevelTopNode<SoyNode> {
    @Nullable
    private final ModNameDeclaration modName;
    private final NamespaceDeclaration namespaceDeclaration;
    private final ImmutableList<AliasDeclaration> aliasDeclarations;
    private final TemplateNode.SoyFileHeaderInfo headerInfo;
    private final ImmutableList<Comment> comments;
    private final ImportsContext importsContext;
    private final ImmutableList<CssPath> requiredCssPaths;

    public SoyFileNode(int id, SourceLocation sourceLocation, NamespaceDeclaration namespaceDeclaration, TemplateNode.SoyFileHeaderInfo headerInfo, ImmutableList<Comment> comments) {
        super(id, sourceLocation);
        this.headerInfo = headerInfo;
        this.modName = headerInfo.getModNameDeclaration();
        this.namespaceDeclaration = namespaceDeclaration;
        this.aliasDeclarations = headerInfo.getAliases();
        this.comments = comments;
        this.importsContext = new ImportsContext();
        this.requiredCssPaths = (ImmutableList)namespaceDeclaration.getRequiredCssPaths().stream().map(CssPath::new).collect(ImmutableList.toImmutableList());
    }

    private SoyFileNode(SoyFileNode orig, CopyState copyState) {
        super(orig, copyState);
        this.modName = orig.modName;
        this.namespaceDeclaration = orig.namespaceDeclaration.copy(copyState);
        this.aliasDeclarations = orig.aliasDeclarations;
        this.headerInfo = orig.headerInfo.copy();
        this.comments = orig.comments;
        this.importsContext = new ImportsContext();
        this.requiredCssPaths = (ImmutableList)orig.requiredCssPaths.stream().map(CssPath::copy).collect(ImmutableList.toImmutableList());
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SOY_FILE_NODE;
    }

    public ImmutableList<CommandTagAttribute> getNamespaceAttributes() {
        return this.namespaceDeclaration.attrs;
    }

    @Nullable
    public String getModName() {
        return this.modName == null ? null : this.modName.name().identifier();
    }

    @Nullable
    public ModNameDeclaration getModNameDeclaration() {
        return this.modName;
    }

    public String getNamespace() {
        return this.namespaceDeclaration.getNamespace();
    }

    public NamespaceDeclaration getNamespaceDeclaration() {
        return this.namespaceDeclaration;
    }

    public ImmutableList<String> getRequiredCssNamespaces() {
        return this.namespaceDeclaration.getRequiredCssNamespaces();
    }

    public ImmutableList<CssPath> getRequiredCssPaths() {
        return this.requiredCssPaths;
    }

    public ImmutableList<CssPath> getRequiredCssImportPaths() {
        return (ImmutableList)this.getImports().stream().map(ImportNode::getRequiredCssPath).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }

    public ImmutableList<CssPath> getAllRequiredCssPaths() {
        return ImmutableList.builder().addAll(this.getRequiredCssPaths()).addAll(this.getRequiredCssImportPaths()).build();
    }

    public ImmutableList<String> getRequireCss() {
        return ImmutableList.builder().addAll(this.getRequiredCssNamespaces()).addAll((Iterable)this.getAllRequiredCssPaths().stream().map(CssPath::sourcePath).collect(ImmutableList.toImmutableList())).build();
    }

    @Nullable
    public String getCssBaseNamespace() {
        return this.namespaceDeclaration.getCssBaseNamespace();
    }

    @Nullable
    public String getCssPrefix() {
        return this.namespaceDeclaration.getCssPrefix();
    }

    public ImmutableList<AliasDeclaration> getAliasDeclarations() {
        return this.aliasDeclarations;
    }

    public SourceFilePath getFilePath() {
        return this.getSourceLocation().getFilePath();
    }

    public boolean isEmpty() {
        return this.getChildren().stream().noneMatch(c -> c instanceof TemplateNode || c instanceof ConstNode || c instanceof ExternNode);
    }

    public ImmutableList<ConstNode> getConstants() {
        return this.getChildrenOfType(ConstNode.class);
    }

    public ImmutableList<TemplateNode> getTemplates() {
        return this.getChildrenOfType(TemplateNode.class);
    }

    public ImmutableList<ImportNode> getImports() {
        return this.getChildrenOfType(ImportNode.class);
    }

    public ImmutableList<ExternNode> getExterns() {
        return this.getChildrenOfType(ExternNode.class);
    }

    @Nullable
    public String getFileName() {
        return this.getSourceLocation().getFileName();
    }

    public ImmutableList<Comment> getComments() {
        return this.comments;
    }

    public Identifier resolveAlias(Identifier identifier) {
        return this.headerInfo.resolveAlias(identifier);
    }

    public boolean aliasUsed(String alias) {
        return this.headerInfo.aliasUsed(alias);
    }

    public TemplateNode.SoyFileHeaderInfo getHeaderInfo() {
        return this.headerInfo;
    }

    public SoyTypeRegistry getSoyTypeRegistry() {
        Preconditions.checkState((this.importsContext != null ? 1 : 0) != 0, (Object)"Called getSoyTypeRegistry() before ImportsPass was run.");
        return this.importsContext.getTypeRegistry();
    }

    public ImportsContext getImportsContext() {
        return this.importsContext;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        if (this.modName != null) {
            sb.append("{modname ").append(this.modName.name()).append("}\n");
        }
        sb.append(this.namespaceDeclaration.toSourceString());
        if (!this.aliasDeclarations.isEmpty()) {
            sb.append("\n");
            for (AliasDeclaration aliasDeclaration : this.aliasDeclarations) {
                String alias = aliasDeclaration.alias().identifier();
                String aliasNamespace = aliasDeclaration.namespace().identifier();
                if (aliasNamespace.equals(alias) || aliasNamespace.endsWith("." + alias)) {
                    sb.append("{alias ").append(aliasNamespace).append("}\n");
                    continue;
                }
                sb.append("{alias ").append(aliasNamespace).append(" as ").append(alias).append("}\n");
            }
        }
        for (SoyNode child : this.getChildren()) {
            sb.append("\n");
            sb.append(child.toSourceString());
        }
        return sb.toString();
    }

    @Override
    public SoyFileSetNode getParent() {
        return (SoyFileSetNode)super.getParent();
    }

    @Override
    public SoyFileNode copy(CopyState copyState) {
        return new SoyFileNode(this, copyState);
    }

    public static final class CssPath {
        private final String sourcePath;
        private String resolvedPath;
        private String namespace = null;

        CssPath(String sourcePath) {
            this.sourcePath = (String)Preconditions.checkNotNull((Object)sourcePath);
        }

        private CssPath(CssPath origin) {
            this.sourcePath = origin.sourcePath;
            this.resolvedPath = origin.resolvedPath;
        }

        public String sourcePath() {
            return this.sourcePath;
        }

        public Optional<String> resolvedPath() {
            return Optional.ofNullable(this.resolvedPath);
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setResolvedPath(String resolvedPath) {
            Preconditions.checkState((this.resolvedPath == null ? 1 : 0) != 0);
            this.resolvedPath = (String)Preconditions.checkNotNull((Object)resolvedPath);
        }

        CssPath copy() {
            return new CssPath(this);
        }
    }
}

