/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.SoyNode;

public final class SkipNode
extends AbstractParentCommandNode<SoyNode.StandaloneNode>
implements SoyNode.StatementNode {
    private final boolean skipOnlyChildren;

    public SkipNode(int id, SourceLocation location) {
        super(id, location, "skip");
        this.skipOnlyChildren = false;
    }

    public SkipNode(int id, SourceLocation location, boolean skipOnlyChildren) {
        super(id, location, "skipchildren");
        this.skipOnlyChildren = skipOnlyChildren;
    }

    private SkipNode(SkipNode orig, CopyState copyState) {
        super(orig, copyState);
        for (SoyNode.StandaloneNode node : this.getChildren()) {
            this.addChild(node.copy(copyState));
        }
        this.skipOnlyChildren = orig.skipOnlyChildren;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SKIP_NODE;
    }

    @Override
    public String getCommandText() {
        if (this.skipOnlyChildren) {
            return "{skipchildren}";
        }
        return "{skip}";
    }

    @Override
    public String toSourceString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getCommandText());
        for (SoyNode.StandaloneNode node : this.getChildren()) {
            builder.append(node.toSourceString());
        }
        if (this.skipOnlyChildren) {
            builder.append("{/skipchildren}");
        } else {
            builder.append("{/skip}");
        }
        return builder.toString();
    }

    public boolean skipOnlyChildren() {
        return this.skipOnlyChildren;
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public SkipNode copy(CopyState copyState) {
        return new SkipNode(this, copyState);
    }
}

