/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.VarRefNode;
import java.util.ArrayList;
import java.util.List;

public final class MsgSubstUnitPlaceholderNameUtils {
    private static final SoyErrorKind COLLIDING_EXPRESSIONS = SoyErrorKind.of("Cannot generate noncolliding base names for vars. Colliding expressions: ''{0}'' and ''{1}''. Add explicit base names with the ''phname'' attribute.", new SoyErrorKind.StyleAllowance[0]);

    private MsgSubstUnitPlaceholderNameUtils() {
    }

    public static String genNaiveBaseNameForExpr(ExprNode exprNode, String fallbackBaseName) {
        if (exprNode instanceof NullSafeAccessNode) {
            throw new IllegalStateException("Msg placeholders cannot be generated for NullSafeAccessNodes; they must be created before the NullSafeAccessPass");
        }
        if (exprNode instanceof VarRefNode) {
            return BaseUtils.convertToUpperUnderscore(((VarRefNode)exprNode).getNameWithoutLeadingDollar());
        }
        if (exprNode instanceof FieldAccessNode) {
            return BaseUtils.convertToUpperUnderscore(((FieldAccessNode)exprNode).getFieldName());
        }
        if (exprNode instanceof GlobalNode) {
            String globalName = ((GlobalNode)exprNode).getName();
            return BaseUtils.convertToUpperUnderscore(BaseUtils.extractPartAfterLastDot(globalName));
        }
        return fallbackBaseName;
    }

    public static String genShortestBaseNameForExpr(ExprNode exprNode, String fallbackBaseName) {
        return (String)Iterables.getFirst(MsgSubstUnitPlaceholderNameUtils.genCandidateBaseNamesForExpr(exprNode), (Object)fallbackBaseName);
    }

    public static List<String> genNoncollidingBaseNamesForExprs(List<ExprNode> exprNodes, String fallbackBaseName, ErrorReporter errorReporter) {
        List candidateBaseNameList;
        int numExprs = exprNodes.size();
        ArrayList candidateBaseNameLists = Lists.newArrayListWithCapacity((int)numExprs);
        for (ExprNode exprRoot : exprNodes) {
            candidateBaseNameLists.add(MsgSubstUnitPlaceholderNameUtils.genCandidateBaseNamesForExpr(exprRoot));
        }
        HashMultimap collisionStrToLongestCandidatesMultimap = HashMultimap.create();
        for (int i = 0; i < numExprs; ++i) {
            ExprNode exprRoot = exprNodes.get(i);
            candidateBaseNameList = (List)candidateBaseNameLists.get(i);
            if (candidateBaseNameList.isEmpty()) continue;
            String longestCandidate = (String)candidateBaseNameList.get(candidateBaseNameList.size() - 1);
            collisionStrToLongestCandidatesMultimap.put((Object)longestCandidate, (Object)exprRoot);
            int n = longestCandidate.length();
            for (int j = 0; j < n; ++j) {
                if (longestCandidate.charAt(j) != '_') continue;
                collisionStrToLongestCandidatesMultimap.put((Object)longestCandidate.substring(j + 1), (Object)exprRoot);
            }
        }
        ArrayList noncollidingBaseNames = Lists.newArrayListWithCapacity((int)numExprs);
        block3: for (int i = 0; i < numExprs; ++i) {
            candidateBaseNameList = (List)candidateBaseNameLists.get(i);
            if (!candidateBaseNameList.isEmpty()) {
                for (String candidateBaseName : candidateBaseNameList) {
                    if (collisionStrToLongestCandidatesMultimap.get((Object)candidateBaseName).size() != 1) continue;
                    noncollidingBaseNames.add(candidateBaseName);
                    continue block3;
                }
                ExprNode exprRoot = exprNodes.get(i);
                String longestCandidate = (String)candidateBaseNameList.get(candidateBaseNameList.size() - 1);
                Node collidingExprRoot = null;
                for (ExprNode er : collisionStrToLongestCandidatesMultimap.get((Object)longestCandidate)) {
                    if (er == exprRoot) continue;
                    collidingExprRoot = er;
                    break;
                }
                errorReporter.report(collidingExprRoot.getSourceLocation(), COLLIDING_EXPRESSIONS, exprRoot.toSourceString(), collidingExprRoot.toSourceString());
                return noncollidingBaseNames;
            }
            noncollidingBaseNames.add(fallbackBaseName);
        }
        return noncollidingBaseNames;
    }

    @VisibleForTesting
    static ImmutableList<String> genCandidateBaseNamesForExpr(ExprNode exprNode) {
        if (exprNode instanceof NullSafeAccessNode) {
            throw new IllegalStateException("Msg placeholders cannot be generated for NullSafeAccessNodes; they must be created before the NullSafeAccessPass");
        }
        if (exprNode instanceof VarRefNode || exprNode instanceof DataAccessNode) {
            ImmutableList.Builder baseNames = ImmutableList.builder();
            String baseName = null;
            while (exprNode != null) {
                String nameSegment;
                if (exprNode instanceof VarRefNode) {
                    nameSegment = ((VarRefNode)exprNode).getNameWithoutLeadingDollar();
                    exprNode = null;
                } else if (exprNode instanceof FieldAccessNode) {
                    FieldAccessNode fieldAccess = (FieldAccessNode)exprNode;
                    nameSegment = fieldAccess.getFieldName();
                    exprNode = fieldAccess.getBaseExprChild();
                } else {
                    IntegerNode keyValue;
                    if (!(exprNode instanceof ItemAccessNode)) break;
                    ItemAccessNode itemAccess = (ItemAccessNode)exprNode;
                    exprNode = itemAccess.getBaseExprChild();
                    if (!(itemAccess.getKeyExprChild() instanceof IntegerNode) || (keyValue = (IntegerNode)itemAccess.getKeyExprChild()).getValue() < 0L) break;
                    nameSegment = Long.toString(keyValue.getValue());
                    baseName = BaseUtils.convertToUpperUnderscore(nameSegment) + (String)(baseName != null ? "_" + (String)baseName : "");
                    continue;
                }
                baseName = BaseUtils.convertToUpperUnderscore(nameSegment) + (String)(baseName != null ? "_" + baseName : "");
                baseNames.add((Object)baseName);
            }
            return baseNames.build();
        }
        if (exprNode instanceof GlobalNode) {
            String[] globalNameParts = ((GlobalNode)exprNode).getName().split("\\.");
            ImmutableList.Builder baseNames = ImmutableList.builder();
            String baseName = null;
            for (int i = globalNameParts.length - 1; i >= 0; --i) {
                baseName = BaseUtils.convertToUpperUnderscore(globalNameParts[i]) + (String)(baseName != null ? "_" + baseName : "");
                baseNames.add((Object)baseName);
            }
            return baseNames.build();
        }
        return ImmutableList.of();
    }
}

