/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.MessagePlaceholder;
import com.google.template.soy.soytree.MsgSubstUnitPlaceholderNameUtils;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public final class MsgSelectNode
extends AbstractParentCommandNode<CaseOrDefaultNode>
implements SoyNode.MsgSubstUnitNode,
SoyNode.SplitLevelTopNode<CaseOrDefaultNode>,
SoyNode.ExprHolderNode,
CommandTagAttribute.CommandTagAttributesHolder {
    public static final String FALLBACK_BASE_SELECT_VAR_NAME = "STATUS";
    private final ExprRootNode selectExpr;
    private final SourceLocation openTagLocation;
    private final MessagePlaceholder placeholder;

    private MsgSelectNode(int id, SourceLocation sourceLocation, SourceLocation openTagLocation, ExprRootNode selectExpr, MessagePlaceholder placeholder) {
        super(id, sourceLocation, "select");
        this.openTagLocation = openTagLocation;
        this.selectExpr = selectExpr;
        this.placeholder = placeholder;
    }

    private MsgSelectNode(MsgSelectNode orig, CopyState copyState) {
        super(orig, copyState);
        this.openTagLocation = orig.openTagLocation;
        this.selectExpr = orig.selectExpr.copy(copyState);
        this.placeholder = orig.placeholder;
        copyState.updateRefs(orig, this);
    }

    public static MsgSelectNode fromSelectExpr(int id, SourceLocation sourceLocation, SourceLocation openTagLocation, ExprRootNode selectExpr, List<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        SourceLocation phNameLocation = null;
        String phName = null;
        for (CommandTagAttribute attribute : attributes) {
            if ("phname".equals(attribute.getName().identifier())) {
                phNameLocation = attribute.getValueLocation();
                phName = MessagePlaceholder.validatePlaceholderName(attribute.getValue(), phNameLocation, errorReporter);
                continue;
            }
            errorReporter.report(attribute.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY_SINGLE, attribute.getName().identifier(), "select", "phname");
        }
        return new MsgSelectNode(id, sourceLocation, openTagLocation, selectExpr, phName == null ? MessagePlaceholder.create(MsgSubstUnitPlaceholderNameUtils.genNaiveBaseNameForExpr(selectExpr.getRoot(), FALLBACK_BASE_SELECT_VAR_NAME)) : MessagePlaceholder.createWithUserSuppliedName(phName, phNameLocation));
    }

    public static MsgSelectNode fromGenderExpr(int id, SourceLocation sourceLocation, SourceLocation openTagLocation, ExprRootNode genderExpr, @Nullable String baseSelectVarName) {
        return new MsgSelectNode(id, sourceLocation, openTagLocation, genderExpr, baseSelectVarName == null ? MessagePlaceholder.create(MsgSubstUnitPlaceholderNameUtils.genNaiveBaseNameForExpr(genderExpr.getRoot(), FALLBACK_BASE_SELECT_VAR_NAME)) : MessagePlaceholder.create(baseSelectVarName));
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_SELECT_NODE;
    }

    public ExprRootNode getExpr() {
        return this.selectExpr;
    }

    @Override
    public SourceLocation getOpenTagLocation() {
        return this.openTagLocation;
    }

    public ImmutableList<CommandTagAttribute> getAttributes() {
        return ImmutableList.of();
    }

    @Override
    public MessagePlaceholder getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public boolean shouldUseSameVarNameAs(SoyNode.MsgSubstUnitNode other, ExprEquivalence exprEquivalence) {
        if (!(other instanceof MsgSelectNode)) {
            return false;
        }
        MsgSelectNode that = (MsgSelectNode)other;
        return exprEquivalence.equivalent(this.selectExpr, that.selectExpr);
    }

    @Override
    public String getCommandText() {
        Optional<String> phname = this.placeholder.userSuppliedName();
        return phname.isPresent() ? this.selectExpr.toSourceString() + " phname=\"" + phname.get() + "\"" : this.selectExpr.toSourceString();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.selectExpr);
    }

    @Override
    public SoyNode.MsgBlockNode getParent() {
        return (SoyNode.MsgBlockNode)super.getParent();
    }

    @Override
    public MsgSelectNode copy(CopyState copyState) {
        return new MsgSelectNode(this, copyState);
    }
}

