/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.ExternImplNode;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class JavaImplNode
extends ExternImplNode {
    public static final String CLASS = "class";
    public static final String METHOD = "method";
    public static final String PARAMS = "params";
    public static final String RETURN = "return";
    public static final String TYPE = "type";
    public static final String TYPE_STATIC = "static";
    public static final String TYPE_INSTANCE = "instance";
    public static final String TYPE_INTERFACE = "interface";
    public static final String TYPE_STATIC_INTERFACE = "static_interface";
    private static final ImmutableSet<String> ALLOWED_TYPES = ImmutableSet.of((Object)"static", (Object)"instance", (Object)"interface", (Object)"static_interface");
    public static final String DEFAULT_TYPE = "static";
    private static final SoyErrorKind INVALID_IMPL_ATTRIBUTE = SoyErrorKind.of("Invalid attribute ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_ATTR = SoyErrorKind.of("Missing required attribute ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_TYPE = SoyErrorKind.of(String.format("Valid values for ''%s'' are %s.", "type", ALLOWED_TYPES.stream().collect(Collectors.joining("'', ''", "''", "''"))), new SoyErrorKind.StyleAllowance[0]);
    private final ImmutableList<CommandTagAttribute> attributes;
    private CommandTagAttribute className;
    private CommandTagAttribute methodName;
    private CommandTagAttribute params;
    private CommandTagAttribute returnType;
    private CommandTagAttribute type;

    public JavaImplNode(int id, SourceLocation sourceLocation, List<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        super(id, sourceLocation, "javaimpl");
        this.attributes = ImmutableList.copyOf(attributes);
        this.initAttributes(errorReporter);
    }

    private JavaImplNode(JavaImplNode orig, CopyState copyState) {
        super(orig, copyState);
        this.attributes = (ImmutableList)orig.attributes.stream().map(origAttr -> origAttr.copy(copyState)).collect(ImmutableList.toImmutableList());
        this.initAttributes(ErrorReporter.devnull());
    }

    private void initAttributes(ErrorReporter errorReporter) {
        for (CommandTagAttribute attr : this.attributes) {
            if (attr.hasName(CLASS)) {
                this.className = attr;
                continue;
            }
            if (attr.hasName(METHOD)) {
                this.methodName = attr;
                continue;
            }
            if (attr.hasName(PARAMS)) {
                this.params = attr;
                continue;
            }
            if (attr.hasName(RETURN)) {
                this.returnType = attr;
                continue;
            }
            if (attr.hasName(TYPE)) {
                this.type = attr;
                if (ALLOWED_TYPES.contains((Object)this.type.getValue())) continue;
                errorReporter.report(attr.getSourceLocation(), BAD_TYPE, new Object[0]);
                continue;
            }
            errorReporter.report(attr.getSourceLocation(), INVALID_IMPL_ATTRIBUTE, attr.getName());
        }
        if (this.className == null) {
            errorReporter.report(this.getSourceLocation(), MISSING_ATTR, CLASS);
        }
        if (this.methodName == null) {
            errorReporter.report(this.getSourceLocation(), MISSING_ATTR, METHOD);
        }
        if (this.params == null) {
            errorReporter.report(this.getSourceLocation(), MISSING_ATTR, PARAMS);
        }
        if (this.returnType == null) {
            errorReporter.report(this.getSourceLocation(), MISSING_ATTR, RETURN);
        }
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.JAVA_IMPL_NODE;
    }

    @Override
    public JavaImplNode copy(CopyState copyState) {
        return new JavaImplNode(this, copyState);
    }

    public String className() {
        return this.className.getValue();
    }

    public String methodName() {
        return this.methodName.getValue();
    }

    public String type() {
        return this.type != null ? this.type.getValue() : "static";
    }

    public boolean isStatic() {
        String t = this.type();
        return "static".equals(t) || TYPE_STATIC_INTERFACE.equals(t);
    }

    public boolean isInterface() {
        String t = this.type();
        return TYPE_INTERFACE.equals(t) || TYPE_STATIC_INTERFACE.equals(t);
    }

    public ImmutableList<String> params() {
        String val = this.params.getValue();
        if (val.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(Arrays.asList(val.split("\\s*,\\s*")));
    }

    public String returnType() {
        return this.returnType.getValue();
    }

    @Override
    public SourceLocation getOpenTagLocation() {
        return this.getSourceLocation();
    }

    public ImmutableList<CommandTagAttribute> getAttributes() {
        return this.attributes;
    }

    public SourceLocation getAttributeValueLocation(String paramName) {
        Optional<CommandTagAttribute> attr = this.attributes.stream().filter(a -> paramName.equals(a.getName().identifier())).findFirst();
        return attr.isPresent() ? attr.get().getValueLocation() : SourceLocation.UNKNOWN;
    }

    @Override
    public ExternNode getParent() {
        return (ExternNode)super.getParent();
    }
}

