/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.SoyNode;
import javax.annotation.Nullable;

public final class ForNode
extends AbstractParentCommandNode<SoyNode.BlockNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<SoyNode.BlockNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode,
HtmlContext.HtmlContextHolder {
    private final ExprRootNode expr;
    private final SourceLocation openTagLocation;
    @Nullable
    private HtmlContext htmlContext;

    public ForNode(int id, SourceLocation location, SourceLocation openTagLocation, ExprNode expr) {
        super(id, location, "for");
        this.expr = new ExprRootNode(expr);
        this.openTagLocation = openTagLocation;
    }

    private ForNode(ForNode orig, CopyState copyState) {
        super(orig, copyState);
        this.expr = orig.expr.copy(copyState);
        this.openTagLocation = orig.openTagLocation;
        this.htmlContext = orig.htmlContext;
    }

    @Override
    public HtmlContext getHtmlContext() {
        return (HtmlContext)((Object)Preconditions.checkNotNull((Object)((Object)this.htmlContext), (Object)"Cannot access HtmlContext before HtmlContextVisitor or InferenceEngine."));
    }

    public void setHtmlContext(HtmlContext value) {
        this.htmlContext = value;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.FOR_NODE;
    }

    public ExprRootNode getExpr() {
        return this.expr;
    }

    public SourceLocation getOpenTagLocation() {
        return this.openTagLocation;
    }

    @Override
    public String getCommandText() {
        return ((ForNonemptyNode)this.getChild(0)).getIndexVar() == null ? String.format("%s in %s", ((ForNonemptyNode)this.getChild(0)).getVarRefName(), this.expr.toSourceString()) : String.format("%s, %s in %s", ((ForNonemptyNode)this.getChild(0)).getVarRefName(), ((ForNonemptyNode)this.getChild(0)).getIndexVar().refName(), this.expr.toSourceString());
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.expr);
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public ForNode copy(CopyState copyState) {
        return new ForNode(this, copyState);
    }
}

