/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.ExternImplNode;
import com.google.template.soy.soytree.JavaImplNode;
import com.google.template.soy.soytree.JsImplNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.ExternVar;
import com.google.template.soy.types.FunctionType;
import com.google.template.soy.types.ast.FunctionTypeNode;
import java.util.Optional;

public final class ExternNode
extends AbstractParentCommandNode<ExternImplNode>
implements CommandTagAttribute.CommandTagAttributesHolder {
    private final FunctionTypeNode typeNode;
    private final Identifier name;
    private final SourceLocation openTagLocation;
    private final boolean exported;
    private final ExternVar var;
    private FunctionType type;

    public ExternNode(int id, SourceLocation location, Identifier name, FunctionTypeNode typeNode, SourceLocation headerLocation, boolean exported) {
        super(id, location, "extern");
        this.name = name;
        this.openTagLocation = headerLocation;
        this.typeNode = typeNode;
        this.exported = exported;
        this.var = new ExternVar(name.identifier(), name.location(), null);
    }

    private ExternNode(ExternNode orig, CopyState copyState) {
        super(orig, copyState);
        this.name = orig.name;
        this.typeNode = orig.typeNode.copy();
        this.openTagLocation = orig.openTagLocation;
        this.exported = orig.exported;
        this.var = new ExternVar(orig.var);
        copyState.updateRefs(orig.var, this.var);
    }

    public Identifier getIdentifier() {
        return this.name;
    }

    public boolean isExported() {
        return this.exported;
    }

    public Optional<JsImplNode> getJsImpl() {
        return this.getChildOfType(JsImplNode.class);
    }

    public Optional<JavaImplNode> getJavaImpl() {
        return this.getChildOfType(JavaImplNode.class);
    }

    public FunctionTypeNode typeNode() {
        return this.typeNode;
    }

    public ImmutableList<CommandTagAttribute> getAttributes() {
        return ImmutableList.of();
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.EXTERN_NODE;
    }

    @Override
    public SourceLocation getOpenTagLocation() {
        return this.openTagLocation;
    }

    public FunctionType getType() {
        return this.type;
    }

    public void setType(FunctionType type) {
        this.type = type;
    }

    public ExternVar getVar() {
        return this.var;
    }

    @Override
    public ExternNode copy(CopyState copyState) {
        return new ExternNode(this, copyState);
    }
}

